/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.feign;

import feign.InvocationHandlerFactory;
import feign.Target;
import io.github.resilience4j.feign.FeignDecorator;
import io.vavr.CheckedFunction1;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Predicate;

class FallbackDecorator<T>
implements FeignDecorator {
    private final T fallback;
    private Predicate<Exception> filter;

    public FallbackDecorator(T fallback) {
        this(fallback, (Exception ex) -> true);
    }

    public FallbackDecorator(T fallback, Class<? extends Exception> filter) {
        this(fallback, filter::isInstance);
        Objects.requireNonNull(filter, "Filter cannot be null!");
    }

    public FallbackDecorator(T fallback, Predicate<Exception> filter) {
        this.fallback = Objects.requireNonNull(fallback, "Fallback cannot be null!");
        this.filter = Objects.requireNonNull(filter, "Filter cannot be null!");
    }

    @Override
    public CheckedFunction1<Object[], Object> decorate(CheckedFunction1<Object[], Object> invocationCall, Method method, InvocationHandlerFactory.MethodHandler methodHandler, Target<?> target) {
        this.validateFallback(method);
        Method fallbackMethod = this.getFallbackMethod(method);
        return (CheckedFunction1 & Serializable)args -> {
            try {
                return invocationCall.apply(args);
            }
            catch (Exception exception) {
                if (this.filter.test(exception)) {
                    return fallbackMethod.invoke(this.fallback, args);
                }
                throw exception;
            }
        };
    }

    private void validateFallback(Method method) {
        if (this.fallback.getClass().isAssignableFrom(method.getDeclaringClass())) {
            throw new IllegalArgumentException("Cannot use the fallback [" + this.fallback.getClass() + "] for [" + method.getDeclaringClass() + "]!");
        }
    }

    private Method getFallbackMethod(Method method) {
        Method fallbackMethod;
        try {
            fallbackMethod = this.fallback.getClass().getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException("Cannot use the fallback [" + this.fallback.getClass() + "] for [" + method.getDeclaringClass() + "]", e);
        }
        return fallbackMethod;
    }
}

