/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core;

import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.EventPublisher;
import io.github.resilience4j.core.lang.Nullable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantLock;

public class EventProcessor<T>
implements EventPublisher<T> {
    final Set<EventConsumer<T>> onEventConsumers = new CopyOnWriteArraySet<EventConsumer<T>>();
    final ConcurrentMap<String, Set<EventConsumer<T>>> eventConsumerMap = new ConcurrentHashMap<String, Set<EventConsumer<T>>>();
    private boolean consumerRegistered;
    private final ReentrantLock lock = new ReentrantLock();

    public boolean hasConsumers() {
        return this.consumerRegistered;
    }

    public void registerConsumer(String className, EventConsumer<? extends T> eventConsumer) {
        this.lock.lock();
        try {
            this.eventConsumerMap.compute(className, (k, consumers) -> {
                if (consumers == null) {
                    consumers = new CopyOnWriteArraySet<EventConsumer>();
                    consumers.add(eventConsumer);
                    return consumers;
                }
                consumers.add(eventConsumer);
                return consumers;
            });
            this.consumerRegistered = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public <E extends T> boolean processEvent(E event) {
        Set consumers;
        boolean consumed = false;
        if (!this.onEventConsumers.isEmpty()) {
            for (EventConsumer<E> eventConsumer : this.onEventConsumers) {
                eventConsumer.consumeEvent(event);
            }
            consumed = true;
        }
        if (!this.eventConsumerMap.isEmpty() && (consumers = (Set)this.eventConsumerMap.get(event.getClass().getName())) != null && !consumers.isEmpty()) {
            for (EventConsumer consumer : consumers) {
                consumer.consumeEvent(event);
            }
            consumed = true;
        }
        return consumed;
    }

    @Override
    public void onEvent(@Nullable EventConsumer<T> onEventConsumer) {
        this.lock.lock();
        try {
            this.onEventConsumers.add(onEventConsumer);
            this.consumerRegistered = true;
        }
        finally {
            this.lock.unlock();
        }
    }
}

