/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circularbuffer;

import io.github.resilience4j.circularbuffer.CircularFifoBuffer;
import io.github.resilience4j.circularbuffer.ConcurrentEvictingQueue;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class ConcurrentCircularFifoBuffer<T>
implements CircularFifoBuffer<T> {
    private final ConcurrentEvictingQueue<T> queue;
    private final int capacity;

    public ConcurrentCircularFifoBuffer(int capacity) {
        this.capacity = capacity;
        this.queue = new ConcurrentEvictingQueue(capacity);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public boolean isFull() {
        return this.queue.size() == this.capacity;
    }

    @Override
    public List<T> toList() {
        return List.copyOf(this.queue);
    }

    @Override
    public Stream<T> toStream() {
        return this.queue.stream();
    }

    @Override
    public void add(T element) {
        this.queue.offer(element);
    }

    @Override
    public Optional<T> take() {
        return Optional.ofNullable(this.queue.poll());
    }
}

