/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.internal;

import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadConfig;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadRegistry;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.registry.AbstractRegistry;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.vavr.collection.Array;
import io.vavr.collection.Seq;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public final class InMemoryThreadPoolBulkheadRegistry
extends AbstractRegistry<ThreadPoolBulkhead, ThreadPoolBulkheadConfig>
implements ThreadPoolBulkheadRegistry {
    public InMemoryThreadPoolBulkheadRegistry() {
        this(ThreadPoolBulkheadConfig.ofDefaults());
    }

    public InMemoryThreadPoolBulkheadRegistry(Map<String, ThreadPoolBulkheadConfig> configs) {
        this(configs.getOrDefault("default", ThreadPoolBulkheadConfig.ofDefaults()));
        this.configurations.putAll(configs);
    }

    public InMemoryThreadPoolBulkheadRegistry(Map<String, ThreadPoolBulkheadConfig> configs, RegistryEventConsumer<ThreadPoolBulkhead> registryEventConsumer) {
        this(configs.getOrDefault("default", ThreadPoolBulkheadConfig.ofDefaults()), registryEventConsumer);
        this.configurations.putAll(configs);
    }

    public InMemoryThreadPoolBulkheadRegistry(Map<String, ThreadPoolBulkheadConfig> configs, List<RegistryEventConsumer<ThreadPoolBulkhead>> registryEventConsumers) {
        this(configs.getOrDefault("default", ThreadPoolBulkheadConfig.ofDefaults()), registryEventConsumers);
        this.configurations.putAll(configs);
    }

    public InMemoryThreadPoolBulkheadRegistry(ThreadPoolBulkheadConfig defaultConfig) {
        super((Object)defaultConfig);
    }

    public InMemoryThreadPoolBulkheadRegistry(ThreadPoolBulkheadConfig defaultConfig, RegistryEventConsumer<ThreadPoolBulkhead> registryEventConsumer) {
        super((Object)defaultConfig, registryEventConsumer);
    }

    public InMemoryThreadPoolBulkheadRegistry(ThreadPoolBulkheadConfig defaultConfig, List<RegistryEventConsumer<ThreadPoolBulkhead>> registryEventConsumers) {
        super((Object)defaultConfig, registryEventConsumers);
    }

    @Override
    public Seq<ThreadPoolBulkhead> getAllBulkheads() {
        return Array.ofAll(this.entryMap.values());
    }

    @Override
    public ThreadPoolBulkhead bulkhead(String name) {
        return this.bulkhead(name, (ThreadPoolBulkheadConfig)this.getDefaultConfig());
    }

    @Override
    public ThreadPoolBulkhead bulkhead(String name, ThreadPoolBulkheadConfig config) {
        return (ThreadPoolBulkhead)this.computeIfAbsent(name, () -> ThreadPoolBulkhead.of(name, Objects.requireNonNull(config, "Config must not be null")));
    }

    @Override
    public ThreadPoolBulkhead bulkhead(String name, Supplier<ThreadPoolBulkheadConfig> bulkheadConfigSupplier) {
        return (ThreadPoolBulkhead)this.computeIfAbsent(name, () -> ThreadPoolBulkhead.of(name, (ThreadPoolBulkheadConfig)Objects.requireNonNull(Objects.requireNonNull(bulkheadConfigSupplier, "Supplier must not be null").get(), "Config must not be null")));
    }

    @Override
    public ThreadPoolBulkhead bulkhead(String name, String configName) {
        return (ThreadPoolBulkhead)this.computeIfAbsent(name, () -> ThreadPoolBulkhead.of(name, (ThreadPoolBulkheadConfig)this.getConfiguration(configName).orElseThrow(() -> new ConfigurationNotFoundException(configName))));
    }
}

