/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.internal;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.event.BulkheadEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallFinishedEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallPermittedEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallRejectedEvent;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.EventProcessor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class SemaphoreBulkhead
implements Bulkhead {
    private final String name;
    private final Semaphore semaphore;
    private final Object configChangesLock = new Object();
    private final AtomicReference<BulkheadConfig> config;
    private final BulkheadMetrics metrics;
    private final BulkheadEventProcessor eventProcessor;

    public SemaphoreBulkhead(String name, BulkheadConfig bulkheadConfig) {
        this.name = name;
        this.config = new AtomicReference<BulkheadConfig>(bulkheadConfig != null ? bulkheadConfig : BulkheadConfig.ofDefaults());
        this.semaphore = new Semaphore(this.config.get().getMaxConcurrentCalls(), true);
        this.metrics = new BulkheadMetrics();
        this.eventProcessor = new BulkheadEventProcessor();
    }

    public SemaphoreBulkhead(String name) {
        this(name, BulkheadConfig.ofDefaults());
    }

    public SemaphoreBulkhead(String name, Supplier<BulkheadConfig> configSupplier) {
        this(name, configSupplier.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeConfig(BulkheadConfig newConfig) {
        Object object = this.configChangesLock;
        synchronized (object) {
            int delta = newConfig.getMaxConcurrentCalls() - this.config.get().getMaxConcurrentCalls();
            if (delta < 0) {
                this.semaphore.acquireUninterruptibly(-delta);
            } else if (delta > 0) {
                this.semaphore.release(delta);
            }
            this.config.set(newConfig);
        }
    }

    @Override
    public boolean isCallPermitted() {
        boolean callPermitted = this.tryEnterBulkhead();
        this.publishBulkheadEvent(() -> callPermitted ? new BulkheadOnCallPermittedEvent(this.name) : new BulkheadOnCallRejectedEvent(this.name));
        return callPermitted;
    }

    @Override
    public void onComplete() {
        this.semaphore.release();
        this.publishBulkheadEvent(() -> new BulkheadOnCallFinishedEvent(this.name));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BulkheadConfig getBulkheadConfig() {
        return this.config.get();
    }

    @Override
    public Bulkhead.Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public Bulkhead.EventPublisher getEventPublisher() {
        return this.eventProcessor;
    }

    public String toString() {
        return String.format("Bulkhead '%s'", this.name);
    }

    boolean tryEnterBulkhead() {
        boolean callPermitted = false;
        long timeout = this.config.get().getMaxWaitTime();
        if (timeout == 0L) {
            callPermitted = this.semaphore.tryAcquire();
        } else {
            try {
                callPermitted = this.semaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                callPermitted = false;
            }
        }
        return callPermitted;
    }

    private void publishBulkheadEvent(Supplier<BulkheadEvent> eventSupplier) {
        if (this.eventProcessor.hasConsumers()) {
            this.eventProcessor.consumeEvent(eventSupplier.get());
        }
    }

    private final class BulkheadMetrics
    implements Bulkhead.Metrics {
        private BulkheadMetrics() {
        }

        @Override
        public int getAvailableConcurrentCalls() {
            return SemaphoreBulkhead.this.semaphore.availablePermits();
        }
    }

    private class BulkheadEventProcessor
    extends EventProcessor<BulkheadEvent>
    implements Bulkhead.EventPublisher,
    EventConsumer<BulkheadEvent> {
        private BulkheadEventProcessor() {
        }

        @Override
        public Bulkhead.EventPublisher onCallPermitted(EventConsumer<BulkheadOnCallPermittedEvent> onCallPermittedEventConsumer) {
            this.registerConsumer(BulkheadOnCallPermittedEvent.class, onCallPermittedEventConsumer);
            return this;
        }

        @Override
        public Bulkhead.EventPublisher onCallRejected(EventConsumer<BulkheadOnCallRejectedEvent> onCallRejectedEventConsumer) {
            this.registerConsumer(BulkheadOnCallRejectedEvent.class, onCallRejectedEventConsumer);
            return this;
        }

        @Override
        public Bulkhead.EventPublisher onCallFinished(EventConsumer<BulkheadOnCallFinishedEvent> onCallFinishedEventConsumer) {
            this.registerConsumer(BulkheadOnCallFinishedEvent.class, onCallFinishedEventConsumer);
            return this;
        }

        public void consumeEvent(BulkheadEvent event) {
            super.processEvent((Object)event);
        }
    }
}

