/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v1;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IContent;

class ReportContentWriterV1 {
    protected static Logger logger = Logger.getLogger(ReportContentWriterV1.class.getName());
    protected RAOutputStream raStream;
    protected DataOutputStream stream;
    protected Stack contents = new Stack();
    protected long parentOffset;
    protected long offset;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public ReportContentWriterV1(RAOutputStream aStream) {
        this.raStream = aStream;
        this.stream = new DataOutputStream((OutputStream)this.raStream);
        this.offset = 0L;
        this.parentOffset = -1L;
        this.contents.clear();
    }

    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed in close the writer", ex);
            }
            this.stream = null;
        }
    }

    public long getOffset() {
        return this.offset;
    }

    public long getParentOffset() {
        return this.parentOffset;
    }

    protected void writeContent(DataOutputStream oo, Object object) throws IOException {
        if (object instanceof IContent) {
            IContent content = (IContent)object;
            IOUtil.writeInt((OutputStream)oo, (int)content.getContentType());
            content.writeContent(oo);
        } else {
            IOUtil.writeInt((OutputStream)oo, (int)-1);
            IOUtil.writeObject((DataOutputStream)oo, (Object)object);
        }
    }

    public long openObject(Object content) {
        this.buffer.reset();
        try {
            long ptr = this.offset;
            try {
                DataOutputStream oo = new DataOutputStream(this.buffer);
                this.writeContent(oo, content);
                oo.flush();
                oo.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Failed in write the content", ex);
            }
            byte[] values = this.buffer.toByteArray();
            this.stream.writeInt(values.length);
            this.stream.write(values);
            this.parentOffset = this.offset;
            this.offset = this.offset + 4L + (long)values.length;
            this.contents.push(new Long(this.parentOffset));
            return ptr;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed in write the content", ex);
            return -1L;
        }
    }

    public long closeObject(Object content) {
        long ptr = this.parentOffset;
        this.contents.pop();
        this.parentOffset = this.contents.isEmpty() ? -1L : (Long)this.contents.peek();
        return ptr;
    }
}

