/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.internal.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.birt.data.oda.mongodb.impl.MDbResultSet;
import org.eclipse.birt.data.oda.mongodb.impl.MDbResultSetMetaData;
import org.eclipse.birt.data.oda.mongodb.internal.impl.DriverUtil;
import org.eclipse.birt.data.oda.mongodb.internal.impl.QueryModel;
import org.eclipse.birt.data.oda.mongodb.internal.impl.QueryProperties;
import org.eclipse.birt.data.oda.mongodb.nls.Messages;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class MDbOperation {
    private QueryModel m_model;
    private MongoCollection<Document> m_queryCollection;
    private BasicDBObject m_fieldsObj;
    private BasicDBObject m_queryObj;
    private MDbResultSetMetaData m_rsMetaData;
    private static final MDbOperation sm_factory = new MDbOperation();

    static MDbOperation createQueryOperation(QueryModel queryModel) {
        MDbOperation mDbOperation;
        if (queryModel == null || !queryModel.isValid()) {
            throw new IllegalArgumentException("null/invalid QueryModel");
        }
        if (queryModel.getQueryProperties().hasValidCommandOperation()) {
            MDbOperation mDbOperation2 = sm_factory;
            mDbOperation2.getClass();
            mDbOperation = mDbOperation2.new CommandOperation(queryModel);
        } else {
            mDbOperation = new MDbOperation(queryModel);
        }
        return mDbOperation;
    }

    private MDbOperation() {
    }

    private MDbOperation(QueryModel queryModel) {
        this.m_model = queryModel;
    }

    protected QueryModel getModel() {
        return this.m_model;
    }

    protected void setResultSetMetaData(MDbResultSetMetaData rsmd) {
        this.m_rsMetaData = rsmd;
    }

    MDbResultSetMetaData getResultSetMetaData() {
        return this.m_rsMetaData;
    }

    protected void resetPreparedState() {
        this.m_queryCollection = null;
        this.m_fieldsObj = null;
        this.m_queryObj = null;
        this.m_rsMetaData = null;
    }

    protected void prepare(MongoCollection<Document> dbCollection) throws OdaException {
        BasicDBObject queryObj;
        this.resetPreparedState();
        QueryProperties queryProps = this.getModel().getQueryProperties();
        ReadPreference readPref = queryProps.getTaggableReadPreference();
        if (readPref != null) {
            dbCollection = dbCollection.withReadPreference(readPref);
        }
        if ((queryObj = queryProps.getFindQueryExprAsParsedObject()) == null) {
            queryObj = new BasicDBObject();
        }
        BasicDBObject fieldsObj = queryProps.getSelectedFieldsAsProjectionKeys();
        try {
            FindIterable findIterable = dbCollection.find((Bson)queryObj);
            findIterable = findIterable.projection((Bson)fieldsObj);
            this.applyPropertiesToCursor((MongoIterable<Document>)findIterable, queryProps, true, false);
            this.m_rsMetaData = new MDbResultSetMetaData((Iterable<Document>)findIterable, queryProps.getSelectedFieldNames(), queryProps.isAutoFlattening());
            this.m_queryCollection = dbCollection;
            this.m_fieldsObj = fieldsObj;
            this.m_queryObj = queryObj;
        }
        catch (RuntimeException ex) {
            DriverUtil.getLogger().log(Level.SEVERE, "Encountered RuntimeException in QueryModel#prepareQuery(DBCollection).", ex);
            throw new OdaException((Throwable)ex);
        }
    }

    protected MDbResultSet execute() throws OdaException {
        if (this.m_queryObj == null || this.m_queryCollection == null) {
            throw new OdaException(Messages.mDbOp_invalidQueryExpr);
        }
        try {
            FindIterable findIterable = this.m_queryCollection.find((Bson)this.m_queryObj);
            findIterable = findIterable.projection((Bson)this.m_fieldsObj);
            this.applyPropertiesToCursor((MongoIterable<Document>)findIterable, this.getModel().getQueryProperties(), false, true);
            return new MDbResultSet((Iterator<Document>)findIterable.iterator(), this.getResultSetMetaData(), this.getModel().getQueryProperties());
        }
        catch (RuntimeException ex) {
            DriverUtil.getLogger().log(Level.SEVERE, "Encountered RuntimeException: ", ex);
            throw new OdaException((Throwable)ex);
        }
    }

    private void applyPropertiesToCursor(MongoIterable<Document> mongoIterable, QueryProperties queryProps, boolean includeMetaDataSearchLimit, boolean includeSortExpr) {
        Integer searchLimit;
        if (includeMetaDataSearchLimit && (searchLimit = Integer.valueOf(this.getModel().getEffectiveMDSearchLimit(queryProps))) > 0) {
            if (mongoIterable instanceof FindIterable) {
                FindIterable findIterable = (FindIterable)mongoIterable;
                findIterable.limit(searchLimit.intValue());
            } else if (mongoIterable instanceof MapReduceIterable) {
                MapReduceIterable mapReduceIterable = (MapReduceIterable)mongoIterable;
                mapReduceIterable.limit(searchLimit.intValue());
            }
        }
        MDbOperation.applyPropertiesToCursor(mongoIterable, queryProps, includeSortExpr);
    }

    static void applyPropertiesToCursor(MongoIterable<Document> mongoIterable, QueryProperties queryProps, boolean includeSortExpr) {
        BasicDBObject sortExprObj = null;
        if (includeSortExpr) {
            try {
                sortExprObj = queryProps.getSortExprAsParsedObject();
            }
            catch (OdaException ex) {
                DriverUtil.getLogger().log(Level.WARNING, Messages.bind((String)"Unable to parse the user-defined Sort Expression: {0}", (Object)queryProps.getSortExpr()), ex);
            }
        }
        FindIterable findIterable = null;
        AggregateIterable aggregateIterable = null;
        MapReduceIterable mapReduceIterable = null;
        if (mongoIterable instanceof FindIterable) {
            findIterable = (FindIterable)mongoIterable;
        } else if (mongoIterable instanceof AggregateIterable) {
            aggregateIterable = (AggregateIterable)mongoIterable;
        } else if (mongoIterable instanceof MapReduceIterable) {
            mapReduceIterable = (MapReduceIterable)mongoIterable;
        }
        if (findIterable != null || aggregateIterable == null) {
            // empty if block
        }
        if (findIterable != null) {
            if (sortExprObj != null) {
                findIterable.sort((Bson)sortExprObj);
            }
            if (queryProps.getBatchSize() > 0) {
                findIterable.batchSize(queryProps.getBatchSize().intValue());
            }
            if (queryProps.getNumDocsToSkip() > 0) {
                findIterable.skip(queryProps.getNumDocsToSkip().intValue());
            }
            if (queryProps.isPartialResultsOk()) {
                findIterable.partial(true);
            }
        }
        if (aggregateIterable != null && queryProps.getBatchSize() > 0) {
            aggregateIterable.batchSize(queryProps.getBatchSize().intValue());
        }
        if (mapReduceIterable != null) {
            if (sortExprObj != null) {
                mapReduceIterable.sort((Bson)sortExprObj);
            }
            if (queryProps.getBatchSize() > 0) {
                mapReduceIterable.batchSize(queryProps.getBatchSize().intValue());
            }
        }
    }

    protected QueryProperties getEffectiveProperties() {
        return this.getModel().getQueryProperties();
    }

    static AggregateIterable<Document> callAggregateCmd(MongoCollection<Document> mongoCollection, QueryProperties queryProps) throws OdaException {
        if (!queryProps.hasAggregateCommand()) {
            return null;
        }
        DBObject operationExprObj = queryProps.getOperationExprAsParsedObject(true);
        if (operationExprObj == null) {
            return null;
        }
        List<Document> operationList = QueryProperties.getObjectsAsDocumentList(operationExprObj);
        if (operationList == null) {
            return null;
        }
        try {
            return mongoCollection.aggregate(operationList);
        }
        catch (RuntimeException ex) {
            OdaException odaEx = new OdaException(Messages.mDbOp_aggrCmdFailed);
            odaEx.initCause((Throwable)ex);
            throw odaEx;
        }
    }

    static MapReduceIterable<Document> callMapReduceCmd(MongoCollection<Document> mongoCollection, QueryProperties queryProps) throws OdaException {
        if (!queryProps.hasMapReduceCommand()) {
            return null;
        }
        DBObject command = queryProps.getOperationExprAsParsedObject(false);
        if (command == null) {
            return null;
        }
        if (!(command instanceof BasicDBObject)) {
            throw new OdaException(Messages.bind((String)"Unexpected data type ({0}) in Selected Fields property value in MapReduce command", (Object)command.getClass().getSimpleName()));
        }
        String mapFunction = null;
        String reduceFunction = null;
        Object object = command.get("map");
        if (!(object instanceof String)) {
            throw new OdaException(Messages.bind((String)"Unexpected data type ({0}) in {1} function", (Object)command.getClass().getSimpleName(), (Object)"map"));
        }
        mapFunction = (String)object;
        object = command.get("reduce");
        if (!(object instanceof String)) {
            throw new OdaException(Messages.bind((String)Messages.driverUtil_invalidExpr, (Object)(String.valueOf(command.getClass().getSimpleName()) + " in " + "reduce")));
        }
        reduceFunction = (String)object;
        try {
            MapReduceIterable mapReduceIterable = mongoCollection.mapReduce(mapFunction, reduceFunction);
            object = command.get("finalize");
            String finalizeFunction = null;
            if (object != null) {
                if (object instanceof String) {
                    finalizeFunction = (String)object;
                } else {
                    throw new OdaException(Messages.bind((String)"Unexpected data type ({0}) in {1} function", (Object)command.getClass().getSimpleName(), (Object)"finalize"));
                }
            }
            if (finalizeFunction != null) {
                mapReduceIterable = mapReduceIterable.finalizeFunction(finalizeFunction);
            }
            return mapReduceIterable;
        }
        catch (RuntimeException ex) {
            OdaException odaEx = new OdaException(Messages.bind((String)Messages.mDbOp_mapReduceCmdFailed, (Object)queryProps.getOperationExpression()));
            odaEx.initCause((Throwable)ex);
            throw odaEx;
        }
    }

    static Iterable<Document> callDBCommand(MongoDatabase connectedDB, QueryProperties queryProps) throws OdaException {
        if (!queryProps.hasRunCommand()) {
            return null;
        }
        DBObject command = queryProps.getOperationExprAsParsedObject(false);
        if (command == null) {
            return null;
        }
        try {
            Document documentCommand = QueryProperties.getDocument((BasicDBObject)command);
            Document result = connectedDB.runCommand((Bson)documentCommand);
            ArrayList<Document> iterable = new ArrayList<Document>();
            iterable.add(result);
            return iterable;
        }
        catch (RuntimeException ex) {
            OdaException odaEx = new OdaException(Messages.bind((String)Messages.mDbOp_dbCmdFailed, (Object)queryProps.getOperationExpression()));
            odaEx.initCause((Throwable)ex);
            throw odaEx;
        }
    }

    /* synthetic */ MDbOperation(QueryModel queryModel, MDbOperation mDbOperation) {
        this(queryModel);
    }

    public class CommandOperation
    extends MDbOperation {
        private Iterable<Document> m_cmdResultObjs;
        private boolean m_hasOutputCollection;

        private CommandOperation(QueryModel queryModel) {
            super(queryModel, null);
        }

        @Override
        protected void resetPreparedState() {
            this.m_cmdResultObjs = null;
            this.m_hasOutputCollection = false;
            super.resetPreparedState();
        }

        @Override
        protected void prepare(MongoCollection<Document> dbCollection) throws OdaException {
            this.resetPreparedState();
            QueryProperties queryProps = this.getModel().getQueryProperties();
            QueryModel.validateCommandSyntax(queryProps.getOperationType(), queryProps.getOperationExpression());
            Object cmdResults = null;
            if (queryProps.hasAggregateCommand()) {
                cmdResults = CommandOperation.callAggregateCmd(dbCollection, queryProps);
            } else if (queryProps.hasRunCommand()) {
                cmdResults = CommandOperation.callDBCommand(this.getModel().getConnectedDB(), queryProps);
            } else if (queryProps.hasMapReduceCommand() && (cmdResults = CommandOperation.callMapReduceCmd(dbCollection, queryProps)) != null) {
                this.m_hasOutputCollection = true;
            }
            if (cmdResults == null) {
                return;
            }
            this.setResultSetMetaData(new MDbResultSetMetaData((Iterable<Document>)cmdResults, this.getModel().getEffectiveMDSearchLimit(queryProps), queryProps.getSelectedFieldNames(), queryProps.isAutoFlattening()));
            this.m_cmdResultObjs = cmdResults;
        }

        @Override
        protected MDbResultSet execute() throws OdaException {
            if (this.m_cmdResultObjs != null) {
                return this.getCommandResults();
            }
            return super.execute();
        }

        private MDbResultSet getCommandResults() throws OdaException {
            if (this.m_cmdResultObjs == null) {
                throw new OdaException(Messages.mDbOp_noCmdResults);
            }
            return new MDbResultSet(this.m_cmdResultObjs.iterator(), this.getResultSetMetaData(), this.getModel().getQueryProperties());
        }

        @Override
        protected QueryProperties getEffectiveProperties() {
            QueryProperties queryProps = super.getEffectiveProperties();
            if (this.m_hasOutputCollection) {
                return queryProps;
            }
            if (queryProps.getFindQueryExpr().isEmpty() && queryProps.getSortExpr().isEmpty()) {
                return queryProps;
            }
            QueryProperties effectiveProps = QueryProperties.copy(queryProps);
            effectiveProps.setFindQueryExpr(null);
            effectiveProps.setSortExpr(null);
            return effectiveProps;
        }
    }
}

