/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.internal.impl;

import com.mongodb.Bytes;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.bson.Document;
import org.eclipse.birt.data.oda.mongodb.impl.MDbConnection;
import org.eclipse.birt.data.oda.mongodb.internal.impl.DriverUtil;
import org.eclipse.birt.data.oda.mongodb.internal.impl.MDbOperation;
import org.eclipse.birt.data.oda.mongodb.internal.impl.QueryModel;
import org.eclipse.birt.data.oda.mongodb.internal.impl.QueryProperties;
import org.eclipse.birt.data.oda.mongodb.internal.impl.ResultDataHandler;
import org.eclipse.birt.data.oda.mongodb.nls.Messages;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;

public class MDbMetaData {
    public static final int DEFAULT_META_DATA_SEARCH_LIMIT = 1;
    public static int count = 0;
    private static final MDbMetaData sm_factory = new MDbMetaData();
    private static final DocumentsMetaData sm_emptyFields = sm_factory.new DocumentsMetaData();
    private static final FieldMetaData sm_emptyFieldMetaData;
    private static final String SYSTEM_NAMESPACE_PREFIX = "system.";
    static final String FIELD_FULL_NAME_SEPARATOR = ".";
    private static final Integer NULL_NATIVE_DATA_TYPE;
    private static final Integer STRING_NATIVE_DATA_TYPE;
    private static final Integer BOOLEAN_NATIVE_DATA_TYPE;
    private static final Integer NUMBER_NATIVE_DATA_TYPE;
    private static final Integer NUMBER_INT_NATIVE_DATA_TYPE;
    private static final Integer DATE_NATIVE_DATA_TYPE;
    private static final Integer TIMESTAMP_NATIVE_DATA_TYPE;
    private static final Integer BINARY_NATIVE_DATA_TYPE;
    private static final Integer ARRAY_NATIVE_DATA_TYPE;
    private static final Integer OBJECT_NATIVE_DATA_TYPE;
    private MongoDatabase m_connectedDB;
    private ArrayList<String> collectionNames = new ArrayList();

    static {
        MDbMetaData mDbMetaData = sm_factory;
        mDbMetaData.getClass();
        sm_emptyFieldMetaData = mDbMetaData.new FieldMetaData("");
        NULL_NATIVE_DATA_TYPE = 10;
        STRING_NATIVE_DATA_TYPE = 2;
        BOOLEAN_NATIVE_DATA_TYPE = 8;
        NUMBER_NATIVE_DATA_TYPE = 1;
        NUMBER_INT_NATIVE_DATA_TYPE = 16;
        DATE_NATIVE_DATA_TYPE = 9;
        TIMESTAMP_NATIVE_DATA_TYPE = 17;
        BINARY_NATIVE_DATA_TYPE = 5;
        ARRAY_NATIVE_DATA_TYPE = 4;
        OBJECT_NATIVE_DATA_TYPE = 3;
    }

    public MDbMetaData(Properties connProperties) throws OdaException {
        this.m_connectedDB = MDbConnection.getMongoDatabase(connProperties);
    }

    public MDbMetaData(MongoDatabase connectedDB) {
        if (connectedDB == null) {
            throw new IllegalArgumentException("null");
        }
        this.m_connectedDB = connectedDB;
    }

    private MDbMetaData() {
    }

    public String getDatabaseName() {
        return this.m_connectedDB.getName();
    }

    public List<String> getCollectionsList() {
        return this.getCollectionsList(true);
    }

    public List<String> getCollectionsList(boolean excludeSystemCollections) {
        if (this.collectionNames.isEmpty()) {
            try {
                MongoIterable collectionNamesIterable = this.m_connectedDB.listCollectionNames();
                for (String collectionName : collectionNamesIterable) {
                    this.collectionNames.add(collectionName);
                }
            }
            catch (MongoException ex) {
                DriverUtil.getLogger().log(Level.INFO, "Ignoring error to get collection names from database.", ex);
                return Collections.emptyList();
            }
        }
        if (excludeSystemCollections) {
            ArrayList<String> filteredNames = new ArrayList<String>(this.collectionNames.size());
            for (String collectionName : this.collectionNames) {
                if (collectionName.startsWith(SYSTEM_NAMESPACE_PREFIX)) continue;
                filteredNames.add(collectionName);
            }
            return filteredNames;
        }
        ArrayList<String> collectionNamesCopy = new ArrayList<String>(Collections.nCopies(this.collectionNames.size(), " "));
        Collections.copy(collectionNamesCopy, this.collectionNames);
        return new ArrayList<String>(collectionNamesCopy);
    }

    public boolean collectionExists(String collectionName) {
        if (this.collectionNames.isEmpty()) {
            this.getCollectionsList();
        }
        for (String name : this.collectionNames) {
            if (!name.equalsIgnoreCase(collectionName)) continue;
            return true;
        }
        return false;
    }

    public MongoCollection<Document> getCollection(String collectionName) {
        if (!this.collectionExists(collectionName)) {
            return null;
        }
        return this.m_connectedDB.getCollection(collectionName);
    }

    public DocumentsMetaData getAvailableFields(String collectionName, int searchLimit, QueryProperties runtimeProps) throws OdaException {
        MongoCollection<Document> collection = this.getCollection(collectionName);
        if (collection == null && !runtimeProps.hasRunCommand()) {
            if (runtimeProps.getOperationType() == QueryProperties.CommandOperationType.RUN_DB_COMMAND && runtimeProps.getOperationExpression().isEmpty()) {
                throw new OdaException(Messages.bind((String)Messages.mDbMetaData_missingCmdExprText, (Object)runtimeProps.getOperationType().displayName()));
            }
            throw new OdaException(Messages.bind((String)Messages.mDbMetaData_invalidCollectionName, (Object)collectionName));
        }
        if (searchLimit <= 0) {
            searchLimit = 1;
        }
        if (runtimeProps.hasValidCommandOperation()) {
            QueryModel.validateCommandSyntax(runtimeProps.getOperationType(), runtimeProps.getOperationExpression());
            Object commandResults = null;
            if (runtimeProps.hasAggregateCommand()) {
                commandResults = MDbOperation.callAggregateCmd(collection, runtimeProps);
            } else if (runtimeProps.hasMapReduceCommand()) {
                commandResults = MDbOperation.callMapReduceCmd(collection, runtimeProps);
            } else if (runtimeProps.hasRunCommand()) {
                commandResults = MDbOperation.callDBCommand(this.m_connectedDB, runtimeProps);
            }
            if (commandResults != null) {
                return MDbMetaData.getMetaData(commandResults, searchLimit);
            }
            return sm_emptyFields;
        }
        FindIterable rowsCursor = collection.find();
        if (searchLimit > 0) {
            rowsCursor.limit(searchLimit);
        }
        QueryProperties mdCursorProps = runtimeProps != null ? runtimeProps : QueryProperties.defaultValues();
        MDbOperation.applyPropertiesToCursor((MongoIterable<Document>)rowsCursor, mdCursorProps, false);
        return MDbMetaData.getMetaData((Iterable<Document>)rowsCursor);
    }

    public static int defaultPort() {
        return ServerAddress.defaultPort();
    }

    static String[] splitFieldName(String fieldFullName) {
        if (fieldFullName == null || fieldFullName.isEmpty()) {
            return new String[0];
        }
        return fieldFullName.split("\\.");
    }

    static String getSimpleName(String fieldFullName) {
        String[] nameFragments = MDbMetaData.splitFieldName(fieldFullName);
        if (nameFragments.length == 0) {
            return "";
        }
        return nameFragments[nameFragments.length - 1];
    }

    static String stripParentName(String fieldFullName, String parentName) {
        if (parentName == null || parentName.isEmpty()) {
            return fieldFullName;
        }
        int stripFromIndex = parentName.length() + FIELD_FULL_NAME_SEPARATOR.length();
        if (stripFromIndex > fieldFullName.length()) {
            return fieldFullName;
        }
        return fieldFullName.substring(stripFromIndex);
    }

    static String formatFieldLevelNames(String[] fieldLevelNames, int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex >= fieldLevelNames.length || fromIndex > toIndex) {
            throw new IllegalArgumentException("MDbMetaData#formatFieldLevelNames: Index argument(s) out of range.");
        }
        StringBuffer fieldName = new StringBuffer();
        int i = fromIndex;
        while (i <= toIndex) {
            if (fieldName.length() > 0) {
                fieldName.append(FIELD_FULL_NAME_SEPARATOR);
            }
            fieldName.append(fieldLevelNames[i]);
            ++i;
        }
        return fieldName.toString();
    }

    public static FieldMetaData findFieldByFullName(String fieldFullName, DocumentsMetaData fromDocMetaData) {
        String[] nameFragments = MDbMetaData.splitFieldName(fieldFullName);
        if (nameFragments.length == 0) {
            return null;
        }
        FieldMetaData firstLevelMd = fromDocMetaData.getFieldMetaData(nameFragments[0]);
        if (nameFragments.length == 1) {
            return firstLevelMd;
        }
        if (!firstLevelMd.hasChildDocuments()) {
            return null;
        }
        String childFullName = MDbMetaData.stripParentName(fieldFullName, nameFragments[0]);
        return MDbMetaData.findFieldByFullName(childFullName, firstLevelMd.getChildMetaData());
    }

    public static boolean isFlattenableNestedField(FieldMetaData fieldMd, DocumentsMetaData topLevelDocMD) {
        String cachedAncestorName;
        if (fieldMd == null) {
            return false;
        }
        DocumentsMetaData containingDocMD = fieldMd.getContainingMetaData();
        if (containingDocMD == null) {
            containingDocMD = topLevelDocMD;
        }
        if ((cachedAncestorName = containingDocMD.getFlattenableFieldName()) != null && cachedAncestorName.equals(fieldMd.getFullName())) {
            return true;
        }
        if (fieldMd.isChildField()) {
            return MDbMetaData.isFlattenableNestedField(fieldMd.getParentMetaData(), topLevelDocMD);
        }
        return false;
    }

    public static Map<String, FieldMetaData> flattenFieldsMetaData(List<String> fieldFullNames, DocumentsMetaData fromDocMetaData) {
        if (fieldFullNames.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, FieldMetaData> resultFieldsMD = new LinkedHashMap<String, FieldMetaData>(fieldFullNames.size());
        for (String fieldFullName : fieldFullNames) {
            FieldMetaData fieldMD = MDbMetaData.findFieldByFullName(fieldFullName, fromDocMetaData);
            if (fieldMD == null) continue;
            resultFieldsMD.put(fieldFullName, fieldMD);
        }
        return resultFieldsMD;
    }

    public static Map<String, FieldMetaData> flattenFieldsMetaData(DocumentsMetaData fromDocMetaData, Map<String, FieldMetaData> toResultFieldsMD) {
        if (toResultFieldsMD == null) {
            toResultFieldsMD = new LinkedHashMap<String, FieldMetaData>();
        }
        for (FieldMetaData fieldMD : fromDocMetaData.m_fieldsMetaData.values()) {
            toResultFieldsMD.put(fieldMD.getFullName(), fieldMD);
            if (!fieldMD.hasChildDocuments()) continue;
            toResultFieldsMD = MDbMetaData.flattenFieldsMetaData(fieldMD.getChildMetaData(), toResultFieldsMD);
        }
        return toResultFieldsMD;
    }

    public static DocumentsMetaData getMetaData(Iterable<Document> iterable) {
        if (iterable == null) {
            return sm_emptyFields;
        }
        DocumentsMetaData newMetaData = sm_factory.new DocumentsMetaData();
        for (Document document : iterable) {
            newMetaData.addDocumentMetaData(document, null);
        }
        return newMetaData;
    }

    public static DocumentsMetaData getMetaData(Iterable<Document> iterable, int searchLimit) {
        if (iterable == null) {
            return sm_emptyFields;
        }
        DocumentsMetaData newMetaData = sm_factory.new DocumentsMetaData();
        int count = 1;
        for (Document document : iterable) {
            if (searchLimit > 0 && count > searchLimit) break;
            newMetaData.addDocumentMetaData(document, null);
            ++count;
        }
        return newMetaData;
    }

    private static Integer getPreferredScalarNativeDataType(Set<Integer> nativeDataTypes) {
        if (nativeDataTypes.isEmpty()) {
            return NULL_NATIVE_DATA_TYPE;
        }
        if (nativeDataTypes.size() == 1) {
            return nativeDataTypes.iterator().next();
        }
        if (nativeDataTypes.contains(STRING_NATIVE_DATA_TYPE)) {
            return STRING_NATIVE_DATA_TYPE;
        }
        HashSet<Integer> nonStringNativeDataTypes = new HashSet<Integer>(nativeDataTypes.size());
        for (Integer nativeDataType : nativeDataTypes) {
            if (nativeDataType == NULL_NATIVE_DATA_TYPE || nativeDataType == ARRAY_NATIVE_DATA_TYPE || nativeDataType == OBJECT_NATIVE_DATA_TYPE) continue;
            int odaDataType = ManifestExplorer.getInstance().getDefaultOdaDataTypeCode(nativeDataType.intValue(), "org.eclipse.birt.data.oda.mongodb", "org.eclipse.birt.data.oda.mongodb.dataSet");
            if (odaDataType == 1) {
                return nativeDataType;
            }
            nonStringNativeDataTypes.add(nativeDataType);
        }
        if (nonStringNativeDataTypes.isEmpty()) {
            return NULL_NATIVE_DATA_TYPE;
        }
        if (nonStringNativeDataTypes.size() == 1) {
            return (Integer)nonStringNativeDataTypes.iterator().next();
        }
        boolean isNumeric = nonStringNativeDataTypes.contains(NUMBER_NATIVE_DATA_TYPE) || nonStringNativeDataTypes.contains(NUMBER_INT_NATIVE_DATA_TYPE) || nonStringNativeDataTypes.contains(BOOLEAN_NATIVE_DATA_TYPE);
        boolean isDatetime = nonStringNativeDataTypes.contains(DATE_NATIVE_DATA_TYPE) || nonStringNativeDataTypes.contains(TIMESTAMP_NATIVE_DATA_TYPE);
        boolean isBinary = nonStringNativeDataTypes.contains(BINARY_NATIVE_DATA_TYPE);
        if (isNumeric && !isDatetime && !isBinary) {
            if (nonStringNativeDataTypes.contains(NUMBER_NATIVE_DATA_TYPE)) {
                return NUMBER_NATIVE_DATA_TYPE;
            }
            return NUMBER_INT_NATIVE_DATA_TYPE;
        }
        if (!isNumeric && isDatetime && !isBinary) {
            return TIMESTAMP_NATIVE_DATA_TYPE;
        }
        return STRING_NATIVE_DATA_TYPE;
    }

    public class DocumentsMetaData {
        private Map<String, FieldMetaData> m_fieldsMetaData = new LinkedHashMap<String, FieldMetaData>();
        private String m_nestedCollFieldName;

        private void addDocumentMetaData(Object documentObj, FieldMetaData parentMd) {
            if (documentObj == null) {
                return;
            }
            Document doc = null;
            if (documentObj instanceof List) {
                List docList = (List)documentObj;
                if (docList.size() > 0) {
                    doc = (Document)((List)documentObj).get(0);
                }
            } else {
                doc = (Document)documentObj;
            }
            if (doc != null) {
                Set fieldNames = doc.keySet();
                for (String fieldName : fieldNames) {
                    Object value = doc.get((Object)fieldName);
                    this.addDataTypeOfFieldValue(fieldName, value, parentMd);
                }
            }
        }

        private FieldMetaData addDataTypeOfFieldValue(String fieldName, Object fieldValue, FieldMetaData parentMd) {
            FieldMetaData fieldMd = this.m_fieldsMetaData.get(fieldName);
            if (fieldMd == null) {
                fieldMd = new FieldMetaData(fieldName);
                fieldMd.setParentMetaData(parentMd);
            }
            fieldMd.addDataType(fieldValue);
            this.m_fieldsMetaData.put(fieldMd.getSimpleName(), fieldMd);
            return fieldMd;
        }

        private void removeField(String fieldName) {
            if (fieldName != null) {
                this.m_fieldsMetaData.remove(fieldName);
            }
        }

        public List<String> getFieldNames() {
            ArrayList<String> docFields = new ArrayList<String>(this.m_fieldsMetaData.size());
            for (String fieldName : this.m_fieldsMetaData.keySet()) {
                docFields.add(fieldName);
            }
            return docFields;
        }

        public List<String> getSortedFieldNames() {
            Set<String> attributeNames = this.m_fieldsMetaData.keySet();
            return this.sortFieldNames(attributeNames);
        }

        private List<String> sortFieldNames(Set<String> fieldNames) {
            if (fieldNames == null || fieldNames.isEmpty()) {
                return Collections.emptyList();
            }
            Object[] attrNamesArray = fieldNames.toArray(new String[fieldNames.size()]);
            Arrays.sort(attrNamesArray);
            ArrayList<String> sortedAttrList = new ArrayList<String>(attrNamesArray.length);
            sortedAttrList.addAll(Arrays.asList(attrNamesArray));
            return sortedAttrList;
        }

        public FieldMetaData getFieldMetaData(String fieldSimpleName) {
            FieldMetaData fieldMd = this.m_fieldsMetaData.get(fieldSimpleName);
            return fieldMd != null ? fieldMd : sm_emptyFieldMetaData;
        }

        public void setFlattenableFields(Map<String, FieldMetaData> resultFieldsMD, boolean isTopLevelDoc) {
            if (resultFieldsMD == null || resultFieldsMD.isEmpty()) {
                return;
            }
            FieldMetaData flattenableFieldMD = null;
            if (this.m_nestedCollFieldName != null) {
                flattenableFieldMD = resultFieldsMD.get(this.m_nestedCollFieldName);
            }
            if (flattenableFieldMD == null) {
                Iterator<FieldMetaData> iterator = resultFieldsMD.values().iterator();
                while (iterator.hasNext()) {
                    FieldMetaData resultFieldMD;
                    FieldMetaData fieldLevelMD = resultFieldMD = iterator.next();
                    while (fieldLevelMD != null) {
                        if (!this.m_fieldsMetaData.containsValue(fieldLevelMD)) {
                            fieldLevelMD = fieldLevelMD.getParentMetaData();
                            continue;
                        }
                        if (fieldLevelMD.isArrayOfDocuments()) {
                            this.m_nestedCollFieldName = fieldLevelMD.getFullName();
                            flattenableFieldMD = fieldLevelMD;
                        }
                        fieldLevelMD = null;
                    }
                    if (flattenableFieldMD != null) break;
                }
            }
            if (flattenableFieldMD != null) {
                if (flattenableFieldMD.hasChildDocuments()) {
                    flattenableFieldMD.getChildMetaData().setFlattenableFields(resultFieldsMD, false);
                }
                return;
            }
            if (this.m_nestedCollFieldName == null && isTopLevelDoc) {
                for (FieldMetaData resultFieldMD : resultFieldsMD.values()) {
                    if (!resultFieldMD.isArrayOfScalarValues()) continue;
                    this.m_nestedCollFieldName = resultFieldMD.getFullName();
                    break;
                }
            }
        }

        public String getFlattenableFieldName() {
            return this.m_nestedCollFieldName;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("\n " + this.getClass().getSimpleName() + ":");
            buf.append("; flattenableFieldName: " + this.m_nestedCollFieldName);
            for (Map.Entry<String, FieldMetaData> entry : this.m_fieldsMetaData.entrySet()) {
                buf.append("\n  field key: " + entry.getKey());
                buf.append("; metadata: " + entry.getValue());
            }
            return buf.toString();
        }
    }

    public class FieldMetaData {
        private static final String ARRAY_NOTATION = "[]";
        private String m_simpleName;
        private Set<Integer> m_nativeDataTypes;
        private DocumentsMetaData m_childDocMetaData;
        private FieldMetaData m_parentMd;
        private String[] m_nameFragments;

        private FieldMetaData(String simpleName) {
            this.m_simpleName = simpleName;
        }

        public String getSimpleName() {
            return this.m_simpleName;
        }

        public String getSimpleDisplayName() {
            return this.hasArrayDataType() ? String.valueOf(this.getSimpleName()) + ARRAY_NOTATION : this.getSimpleName();
        }

        public String getFullName() {
            if (this.m_parentMd == null) {
                return this.getSimpleName();
            }
            StringBuffer fullName = new StringBuffer(this.m_parentMd.getFullName());
            fullName.append(MDbMetaData.FIELD_FULL_NAME_SEPARATOR);
            fullName.append(this.getSimpleName());
            return fullName.toString();
        }

        public String getFullDisplayName() {
            if (this.m_parentMd == null) {
                return this.getSimpleDisplayName();
            }
            StringBuffer fullName = new StringBuffer(this.m_parentMd.getFullDisplayName());
            fullName.append(MDbMetaData.FIELD_FULL_NAME_SEPARATOR);
            fullName.append(this.getSimpleDisplayName());
            return fullName.toString();
        }

        String[] getLevelNames() {
            if (this.m_nameFragments == null) {
                this.m_nameFragments = MDbMetaData.splitFieldName(this.getFullName());
            }
            return this.m_nameFragments;
        }

        private void setParentMetaData(FieldMetaData parentMd) {
            if (parentMd != null) {
                this.m_parentMd = parentMd;
            }
        }

        private FieldMetaData getParentMetaData() {
            return this.m_parentMd;
        }

        private DocumentsMetaData getContainingMetaData() {
            if (this.m_parentMd == null) {
                return null;
            }
            return this.m_parentMd.getChildMetaData();
        }

        public boolean isChildField() {
            return this.m_parentMd != null;
        }

        private void addDataType(Object fieldValue) {
            List listOfObjects;
            byte nativeBSonDataTypeCode = Bytes.getType((Object)fieldValue);
            if (this.m_nativeDataTypes == null) {
                this.m_nativeDataTypes = new HashSet<Integer>(2);
            }
            if (nativeBSonDataTypeCode == -1 && fieldValue instanceof Document) {
                nativeBSonDataTypeCode = 3;
            }
            this.m_nativeDataTypes.add(Integer.valueOf(nativeBSonDataTypeCode));
            if (nativeBSonDataTypeCode == 4 && fieldValue instanceof List && (listOfObjects = (List)fieldValue).size() > 0) {
                this.addDataType(listOfObjects.get(0));
                return;
            }
            Object fieldObjValue = ResultDataHandler.fetchFieldDocument(fieldValue, nativeBSonDataTypeCode);
            if (fieldObjValue != null) {
                if (this.m_childDocMetaData == null) {
                    this.m_childDocMetaData = sm_factory.new DocumentsMetaData();
                }
                this.m_childDocMetaData.addDocumentMetaData(fieldObjValue, this);
            }
        }

        public Integer getPreferredNativeDataType(boolean isAutoFlattening) {
            Set<Integer> nativeDataTypes = this.getNativeDataTypes();
            if (nativeDataTypes.isEmpty()) {
                return NULL_NATIVE_DATA_TYPE;
            }
            if (this.hasArrayDataType()) {
                if (isAutoFlattening && !this.hasDocumentDataType()) {
                    return this.getScalarNativeDataType();
                }
                return ARRAY_NATIVE_DATA_TYPE;
            }
            if (this.hasDocumentDataType()) {
                return OBJECT_NATIVE_DATA_TYPE;
            }
            return MDbMetaData.getPreferredScalarNativeDataType(nativeDataTypes);
        }

        public Set<Integer> getNativeDataTypes() {
            if (this.m_nativeDataTypes == null) {
                return Collections.emptySet();
            }
            return this.m_nativeDataTypes;
        }

        private Integer getScalarNativeDataType() {
            Set<Integer> nativeDataTypes = this.getNativeDataTypes();
            HashSet<Integer> scalarNativeDataTypes = new HashSet<Integer>(nativeDataTypes.size());
            for (Integer nativeDataType : nativeDataTypes) {
                if (nativeDataType == ARRAY_NATIVE_DATA_TYPE || nativeDataType == OBJECT_NATIVE_DATA_TYPE) continue;
                scalarNativeDataTypes.add(nativeDataType);
            }
            return MDbMetaData.getPreferredScalarNativeDataType(scalarNativeDataTypes);
        }

        public boolean isArrayOfScalarValues() {
            if (!this.hasArrayDataType()) {
                return false;
            }
            return !this.hasDocumentDataType();
        }

        public boolean isArrayOfDocuments() {
            if (!this.hasArrayDataType()) {
                return false;
            }
            return this.hasDocumentDataType();
        }

        public boolean hasDocumentDataType() {
            return this.getNativeDataTypes().contains(OBJECT_NATIVE_DATA_TYPE);
        }

        public boolean hasArrayDataType() {
            return this.getNativeDataTypes().contains(ARRAY_NATIVE_DATA_TYPE);
        }

        public boolean isDescendantOfArrayField() {
            if (!this.isChildField()) {
                return false;
            }
            return this.m_parentMd.hasArrayDataType() || this.m_parentMd.isDescendantOfArrayField();
        }

        public String getArrayAncestorName() {
            if (!this.isChildField()) {
                return null;
            }
            if (this.m_parentMd.hasArrayDataType()) {
                return this.m_parentMd.getFullName();
            }
            return this.m_parentMd.getArrayAncestorName();
        }

        public boolean hasChildDocuments() {
            return this.m_childDocMetaData != null;
        }

        public DocumentsMetaData getChildMetaData() {
            return this.m_childDocMetaData != null ? this.m_childDocMetaData : sm_emptyFields;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("name: " + this.m_simpleName);
            buf.append("; full display name: " + this.getFullDisplayName());
            buf.append("; nativeDataTypes: " + this.m_nativeDataTypes);
            String parentName = this.m_parentMd != null ? this.m_parentMd.getFullDisplayName() : "null";
            buf.append("; parent field: " + parentName);
            buf.append("; child document metadata: " + this.m_childDocMetaData);
            return buf.toString();
        }
    }
}

