/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.gef.commands.Command;

public class CreateCommand
extends Command {
    private static Logger logger = Logger.getLogger(CreateCommand.class.getName());
    private Object parent;
    private Object after;
    private Map extendsData;

    public CreateCommand(Map extendsData) {
        this.extendsData = extendsData;
    }

    public void execute() {
        DesignElementHandle newObject = this.getNewObject();
        if (DesignerConstants.TRACING_COMMANDS) {
            System.out.println("CreateCommand >> Starts ... ");
        }
        try {
            if (this.parent instanceof SlotHandle) {
                if (this.after != null) {
                    int pos = DEUtil.findInsertPosition(((SlotHandle)this.parent).getElementHandle(), (DesignElementHandle)this.after, ((SlotHandle)this.parent).getSlotID());
                    ((SlotHandle)this.parent).add(newObject, pos);
                } else {
                    ((SlotHandle)this.parent).add(newObject);
                }
            } else if (newObject instanceof DataSourceHandle) {
                ((DesignElementHandle)this.parent).addElement(newObject, 2);
            } else if (newObject instanceof MasterPageHandle) {
                ((DesignElementHandle)this.parent).addElement(newObject, 4);
                ReportRequest r = new ReportRequest();
                r.setType("selection");
                ArrayList<DesignElementHandle> selection = new ArrayList<DesignElementHandle>();
                selection.add(newObject);
                r.setSelectionObject(selection);
                SessionHandleAdapter.getInstance().getMediator().notifyRequest(r);
                r = new ReportRequest();
                r.setType("open editor");
                r.setSelectionObject(selection);
                SessionHandleAdapter.getInstance().getMediator().notifyRequest(r);
            } else if (this.parent instanceof CellHandle && newObject instanceof TableGroupHandle) {
                CellHandle cellHandle = (CellHandle)this.parent;
                TableHandle tableHandle = null;
                while (cellHandle.getContainer() != null) {
                    if (!((cellHandle = cellHandle.getContainer()) instanceof TableHandle)) continue;
                    tableHandle = (TableHandle)cellHandle;
                    break;
                }
                if (tableHandle != null) {
                    tableHandle.getGroups().add(newObject, tableHandle.getGroups().getCount());
                }
            } else if (DEUtil.getDefaultSlotID(this.parent) != -1) {
                if (this.after != null) {
                    int pos = DEUtil.findInsertPosition((DesignElementHandle)this.parent, (DesignElementHandle)this.after);
                    int slotID = DEUtil.findSlotID(this.parent, this.after);
                    ((DesignElementHandle)this.parent).addElement(newObject, slotID, pos);
                } else {
                    ((DesignElementHandle)this.parent).addElement(newObject, DEUtil.getDefaultSlotID(this.parent));
                }
            } else if (DEUtil.getDefaultSlotID(this.parent) == -1) {
                if (this.after != null) {
                    int pos = DEUtil.findInsertPosition((DesignElementHandle)this.parent, (DesignElementHandle)this.after, DEUtil.getDefaultContentName(this.parent));
                    ((DesignElementHandle)this.parent).add(DEUtil.getDefaultContentName(this.parent), newObject, pos);
                } else {
                    ((DesignElementHandle)this.parent).add(DEUtil.getDefaultContentName(this.parent), newObject);
                }
            }
            DEUtil.setDefaultTheme(newObject);
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("CreateCommand >> Finished. " + DEUtil.getDisplayLabel(newObject) + " created");
            }
        }
        catch (SemanticException e) {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("CreateCommand >> Failed");
            }
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public void setAfter(Object model) {
        this.after = model;
    }

    public DesignElementHandle getNewObject() {
        return (DesignElementHandle)this.extendsData.get("newObject");
    }
}

