/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.function.bre;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.function.bre.Function_temp;
import org.eclipse.birt.core.script.function.i18n.Messages;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionContext;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionExecutor;
import org.mozilla.javascript.UniqueTag;

public class BirtDateTime
implements IScriptFunctionExecutor {
    private static final long serialVersionUID = 1L;
    private static ThreadLocal<List<SimpleDateFormat>> threadSDFArray = new ThreadLocal();
    private static ThreadLocal<ULocale> threadLocale = new ThreadLocal();
    private static ThreadLocal<TimeZone> threadTimeZone = new ThreadLocal();
    private IScriptFunctionExecutor executor;
    public static final String PROPERTY_FISCAL_YEAR_START_DATE = "FISCAL_YEAR_START_DATE";
    private static final DateFormat FISCAL_YEAR_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    protected static Logger logger = Logger.getLogger(BirtDateTime.class.getName());

    private static SimpleDateFormat getAbbrMonthFormat() {
        return threadSDFArray.get().get(0);
    }

    private static SimpleDateFormat getMonthFormat() {
        return threadSDFArray.get().get(1);
    }

    private static SimpleDateFormat getAbbrWeekFormat() {
        return threadSDFArray.get().get(2);
    }

    private static SimpleDateFormat getWeekFormat() {
        return threadSDFArray.get().get(3);
    }

    BirtDateTime(String functionName) throws BirtException {
        if ("year".equals(functionName)) {
            this.executor = new Function_Year();
        } else if ("quarter".equals(functionName)) {
            this.executor = new Function_Quarter();
        } else if ("month".equals(functionName)) {
            this.executor = new Function_Month();
        } else if ("week".equals(functionName)) {
            this.executor = new Function_Week();
        } else if ("weekOfMonth".equals(functionName)) {
            this.executor = new Function_WeekOfMonth();
        } else if ("day".equals(functionName)) {
            this.executor = new Function_Day();
        } else if ("weekDay".equals(functionName)) {
            this.executor = new Function_WeekDay();
        } else if ("dayOfWeek".equals(functionName)) {
            this.executor = new Function_DayOfWeek();
        } else if ("dayOfYear".equals(functionName)) {
            this.executor = new Function_DayOfYear();
        } else if ("today".equals(functionName)) {
            this.executor = new Function_Today();
        } else if ("now".equals(functionName)) {
            this.executor = new Function_Now();
        } else if ("diffYear".equals(functionName)) {
            this.executor = new Function_DiffYear();
        } else if ("diffMonth".equals(functionName)) {
            this.executor = new Function_DiffMonth();
        } else if ("diffQuarter".equals(functionName)) {
            this.executor = new Function_DiffQuarter();
        } else if ("diffWeek".equals(functionName)) {
            this.executor = new Function_DiffWeek();
        } else if ("diffDay".equals(functionName)) {
            this.executor = new Function_DiffDay();
        } else if ("diffHour".equals(functionName)) {
            this.executor = new Function_DiffHour();
        } else if ("diffMinute".equals(functionName)) {
            this.executor = new Function_DiffMinute();
        } else if ("diffSecond".equals(functionName)) {
            this.executor = new Function_DiffSecond();
        } else if ("addYear".equals(functionName)) {
            this.executor = new Function_AddYear();
        } else if ("addMonth".equals(functionName)) {
            this.executor = new Function_AddMonth();
        } else if ("addQuarter".equals(functionName)) {
            this.executor = new Function_AddQuarter();
        } else if ("addWeek".equals(functionName)) {
            this.executor = new Function_AddWeek();
        } else if ("addDay".equals(functionName)) {
            this.executor = new Function_AddDay();
        } else if ("addHour".equals(functionName)) {
            this.executor = new Function_AddHour();
        } else if ("addMinute".equals(functionName)) {
            this.executor = new Function_AddMinute();
        } else if ("addSecond".equals(functionName)) {
            this.executor = new Function_AddSecond();
        } else if ("firstDayOfYear".equals(functionName)) {
            this.executor = new Function_FirstDayOfYear();
        } else if ("firstDayOfQuarter".equals(functionName)) {
            this.executor = new Function_FirstDayOfQuarter();
        } else if ("firstDayOfMonth".equals(functionName)) {
            this.executor = new Function_FirstDayOfMonth();
        } else if ("firstDayOfWeek".equals(functionName)) {
            this.executor = new Function_FirstDayOfWeek();
        } else if ("date".equals(functionName)) {
            this.executor = new Function_Date();
        } else if ("fiscalYear".equals(functionName)) {
            this.executor = new Function_FiscalYear();
        } else if ("fiscalQuarter".equals(functionName)) {
            this.executor = new Function_FiscalQuarter();
        } else if ("fiscalMonth".equals(functionName)) {
            this.executor = new Function_FiscalMonth();
        } else if ("fiscalWeek".equals(functionName)) {
            this.executor = new Function_FiscalWeek();
        } else if ("fiscalDay".equals(functionName)) {
            this.executor = new Function_FiscalDay();
        } else if ("firstDayOfFiscalYear".equals(functionName)) {
            this.executor = new Function_FirstDayOfFiscalYear();
        } else if ("firstDayOfFiscalQuarter".equals(functionName)) {
            this.executor = new Function_FirstDayOfFiscalQuarter();
        } else if ("firstDayOfFiscalMonth".equals(functionName)) {
            this.executor = new Function_FirstDayOfFiscalMonth();
        } else if ("firstDayOfFiscalWeek".equals(functionName)) {
            this.executor = new Function_FirstDayOfFiscalWeek();
        } else if ("hour".equals(functionName)) {
            this.executor = new Function_Hour();
        } else if ("minute".equals(functionName)) {
            this.executor = new Function_Minute();
        } else if ("second".equals(functionName)) {
            this.executor = new Function_Second();
        } else if ("weekOfYear".equals(functionName)) {
            this.executor = new Function_WeekOfYear();
        } else if ("weekOfQuarter".equals(functionName)) {
            this.executor = new Function_WeekOfQuarter();
        } else if ("dayOfQuarter".equals(functionName)) {
            this.executor = new Function_DayOfQuarter();
        } else if ("dayOfMonth".equals(functionName)) {
            this.executor = new Function_DayOfMonth();
        } else {
            throw new BirtException("org.eclipse.birt.core.script.function.bre", null, (Object)(String.valueOf(Messages.getString("invalid.function.name")) + "BirtDateTime." + functionName));
        }
    }

    private static int year(java.util.Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        return BirtDateTime.getCalendar(d).get(1);
    }

    private static int quarter(java.util.Date d) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        int month = BirtDateTime.getCalendar(d).get(2);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                return 1;
            }
            case 3: 
            case 4: 
            case 5: {
                return 2;
            }
            case 6: 
            case 7: 
            case 8: {
                return 3;
            }
            case 9: 
            case 10: 
            case 11: {
                return 4;
            }
        }
        return -1;
    }

    private static int weekOfQuarter(java.util.Date d) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        int dayOfWeek = BirtDateTime.getCalendar(d).get(7);
        int dayOfQtr = BirtDateTime.getDayOfQuarter(d);
        int quarter = BirtDateTime.quarter(d);
        int dayCountTillLastSunday = dayOfQtr - dayOfWeek + 1;
        int weekOfQuarter = 1;
        while (dayCountTillLastSunday > 1) {
            dayCountTillLastSunday -= 7;
            ++weekOfQuarter;
        }
        weekOfQuarter = quarter * 100 + weekOfQuarter;
        return weekOfQuarter;
    }

    private static int dayOfQuarter(java.util.Date d) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        int dayOfYear = BirtDateTime.getCalendar(d).get(6);
        int quarter = BirtDateTime.quarter(d);
        int year = BirtDateTime.getCalendar(d).get(1);
        int[] dayCountPerQtr_NLY = new int[]{90, 91, 92, 92};
        int[] dayCountPerQtr_LY = new int[]{91, 91, 92, 92};
        boolean isLeapYear = false;
        int[] dayCountPerQtr = null;
        isLeapYear = year % 4 == 0 && year % 100 != 0 ? true : year % 400 == 0;
        dayCountPerQtr = isLeapYear ? dayCountPerQtr_LY : dayCountPerQtr_NLY;
        int totalDaysTillQtr = 0;
        int dayOfQuarter = 0;
        int i = 0;
        while (i < quarter - 1) {
            totalDaysTillQtr += dayCountPerQtr[i];
            ++i;
        }
        dayOfQuarter = dayOfYear - totalDaysTillQtr;
        dayOfQuarter = quarter * 100 + dayOfQuarter;
        return dayOfQuarter;
    }

    private static int getDayOfQuarter(java.util.Date d) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        int dayOfYear = BirtDateTime.getCalendar(d).get(6);
        int quarter = BirtDateTime.quarter(d);
        int year = BirtDateTime.getCalendar(d).get(1);
        int[] dayCountPerQtr_NLY = new int[]{90, 91, 92, 92};
        int[] dayCountPerQtr_LY = new int[]{91, 91, 92, 92};
        boolean isLeapYear = false;
        int[] dayCountPerQtr = null;
        isLeapYear = year % 4 == 0 && year % 100 != 0 ? true : year % 400 == 0;
        dayCountPerQtr = isLeapYear ? dayCountPerQtr_LY : dayCountPerQtr_NLY;
        int totalDaysTillQtr = 0;
        int dayOfQuarter = 0;
        int i = 0;
        while (i < quarter - 1) {
            totalDaysTillQtr += dayCountPerQtr[i];
            ++i;
        }
        dayOfQuarter = dayOfYear - totalDaysTillQtr;
        return dayOfQuarter;
    }

    private static int month(java.util.Date d) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        return BirtDateTime.getCalendar(d).get(2) + 1;
    }

    private static String month(java.util.Date d, int option) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        Calendar c = BirtDateTime.getCalendar(d);
        int month = c.get(2);
        if (option == 1) {
            return String.valueOf(month + 1);
        }
        if (option == 2) {
            return BirtDateTime.getMonthFormat().format(d);
        }
        if (option == 3) {
            return BirtDateTime.getAbbrMonthFormat().format(d);
        }
        return null;
    }

    private static int week(java.util.Date d) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        return BirtDateTime.getCalendar(d).get(3);
    }

    private static int weekOfMonth(java.util.Date d) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        return BirtDateTime.getCalendar(d).get(4);
    }

    private static int weekOfYear(java.util.Date d) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        return BirtDateTime.getCalendar(d).get(3);
    }

    private static int day(java.util.Date d) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        return BirtDateTime.getCalendar(d).get(5);
    }

    private static String weekDay(java.util.Date d) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        return String.valueOf(BirtDateTime.getCalendar(d).get(7));
    }

    private static String weekDay(java.util.Date d, int option) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        switch (option) {
            case 1: {
                return String.valueOf(BirtDateTime.getWeekDay(d, 1));
            }
            case 2: {
                return String.valueOf(BirtDateTime.getWeekDay(d, 2));
            }
            case 3: {
                return String.valueOf(BirtDateTime.getWeekDay(d, 2) - 1);
            }
            case 4: {
                return BirtDateTime.getWeekFormat().format(d);
            }
            case 5: {
                return BirtDateTime.getAbbrWeekFormat().format(d);
            }
        }
        return null;
    }

    private static int dayOfYear(java.util.Date d) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        return BirtDateTime.getCalendar(d).get(6);
    }

    private static int dayOfMonth(java.util.Date d) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        return BirtDateTime.getCalendar(d).get(5);
    }

    private static int hour(java.util.Date d) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        return BirtDateTime.getCalendar(d).get(10);
    }

    private static int minute(java.util.Date d) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        return BirtDateTime.getCalendar(d).get(12);
    }

    private static int second(java.util.Date d) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        return BirtDateTime.getCalendar(d).get(13);
    }

    private static int dayOfWeek(java.util.Date d) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        return BirtDateTime.getCalendar(d).get(7);
    }

    private static java.util.Date today() {
        Calendar calendar = Calendar.getInstance((TimeZone)threadTimeZone.get());
        calendar.set(11, 0);
        calendar.clear(12);
        calendar.clear(13);
        calendar.clear(14);
        return calendar.getTime();
    }

    private static Timestamp now() {
        java.util.Date now = new java.util.Date();
        return new Timestamp(now.getTime());
    }

    private static int diffYear(java.util.Date d1, java.util.Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        int startYear = BirtDateTime.year(d1);
        int endYear = BirtDateTime.year(d2);
        return endYear - startYear;
    }

    private static int diffMonth(java.util.Date d1, java.util.Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        int startMonth = BirtDateTime.year(d1) * 12 + BirtDateTime.month(d1);
        int endMonth = BirtDateTime.year(d2) * 12 + BirtDateTime.month(d2);
        return endMonth - startMonth;
    }

    private static int diffQuarter(java.util.Date d1, java.util.Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        int startQuter = BirtDateTime.year(d1) * 4 + BirtDateTime.quarter(d1);
        int endQuter = BirtDateTime.year(d2) * 4 + BirtDateTime.quarter(d2);
        return endQuter - startQuter;
    }

    private static long diffWeek(java.util.Date d1, java.util.Date d2) {
        java.util.Date sd1 = BirtDateTime.getWeekStartDay(d1);
        java.util.Date sd2 = BirtDateTime.getWeekStartDay(d2);
        return BirtDateTime.diffDay(sd1, sd2) / 7L;
    }

    public static java.util.Date getWeekStartDay(java.util.Date date) {
        int diffDay = 1 - Integer.valueOf(BirtDateTime.weekDay(date));
        return BirtDateTime.addDay(date, diffDay);
    }

    private static long diffDay(java.util.Date d1, java.util.Date d2) {
        Calendar c1 = Calendar.getInstance((TimeZone)threadTimeZone.get());
        c1.setTime(d1);
        Calendar c2 = Calendar.getInstance((TimeZone)threadTimeZone.get());
        c2.setTime(d2);
        if (c1.after((Object)c2)) {
            return -BirtDateTime.diffDay(c2, c1);
        }
        return BirtDateTime.diffDay(c1, c2);
    }

    private static long diffDay(Calendar d1, Calendar d2) {
        int days = d2.get(6) - d1.get(6);
        int y2 = d2.get(1);
        if (d1.get(1) != y2) {
            do {
                days += d1.getActualMaximum(6);
                d1.add(1, 1);
            } while (d1.get(1) != y2);
        }
        return days;
    }

    private static long diffHour(java.util.Date d1, java.util.Date d2) {
        return BirtDateTime.diffSecond(d1, d2) / 3600L;
    }

    private static long diffMinute(java.util.Date d1, java.util.Date d2) {
        return BirtDateTime.diffSecond(d1, d2) / 60L;
    }

    private static long diffSecond(java.util.Date d1, java.util.Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        long diff = d2.getTime() - d1.getTime();
        return diff / 1000L;
    }

    private static java.util.Date addYear(java.util.Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(1, num);
        return startCal.getTime();
    }

    private static java.util.Date addMonth(java.util.Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(2, num);
        return startCal.getTime();
    }

    private static java.util.Date addQuarter(java.util.Date date, int num) {
        return BirtDateTime.addMonth(date, num * 3);
    }

    private static java.util.Date addWeek(java.util.Date date, int num) {
        return BirtDateTime.addDay(date, num * 7);
    }

    private static java.util.Date addDay(java.util.Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(5, num);
        return startCal.getTime();
    }

    private static java.util.Date addHour(java.util.Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(11, num);
        return startCal.getTime();
    }

    private static java.util.Date addMinute(java.util.Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(12, num);
        return startCal.getTime();
    }

    private static void adjustFiscalYear(Calendar current, Object fiscalStart) throws BirtException {
        Calendar start = fiscalStart instanceof Calendar ? (Calendar)fiscalStart : BirtDateTime.getCalendar(DataTypeUtil.toDate((Object)fiscalStart));
        start.set(1, current.get(1));
        current.add(6, 1 - start.get(6));
    }

    private static void adjustFiscalMonth(Calendar current, Object fiscalStart) throws BirtException {
        Calendar start = fiscalStart instanceof Calendar ? (Calendar)fiscalStart : BirtDateTime.getCalendar(DataTypeUtil.toDate((Object)fiscalStart));
        current.add(5, 1 - start.get(5));
    }

    private static java.util.Date getDate(int year, int month, int day, int hours, int minutes, int seconds) {
        java.util.Date newDate = new java.util.Date();
        Calendar calendar = BirtDateTime.getCalendar(newDate);
        calendar.set(year, month, day, hours, minutes, seconds);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private static java.util.Date addSecond(java.util.Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(13, num);
        return startCal.getTime();
    }

    private static int getWeekDay(java.util.Date d, int startDay) {
        int dayOfWeek = BirtDateTime.getCalendar(d).get(7);
        if (dayOfWeek >= startDay) {
            return dayOfWeek - startDay + 1;
        }
        return (dayOfWeek - startDay + 1 + 7) % 8;
    }

    private static Calendar getCalendar(java.util.Date d) {
        Calendar c = null;
        c = d instanceof Date ? Calendar.getInstance((TimeZone)TimeZone.getDefault(), (ULocale)threadLocale.get()) : Calendar.getInstance((TimeZone)threadTimeZone.get(), (ULocale)threadLocale.get());
        if (d == null) {
            c.clear();
            c.set(1970, 0, 1);
        } else {
            c.setTime(d);
        }
        return c;
    }

    private static boolean existNullValue(Object[] args) {
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (args[i] == null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Object execute(Object[] arguments, IScriptFunctionContext scriptContext) throws BirtException {
        if (scriptContext != null) {
            Object timeZone;
            Object locale = scriptContext.findProperty("org.eclipse.birt.core.script.functionservice.context.locale");
            if (!(locale instanceof ULocale)) {
                locale = ULocale.getDefault();
            }
            if (threadLocale.get() != locale) {
                threadLocale.set((ULocale)locale);
                ArrayList<SimpleDateFormat> sdfList = new ArrayList<SimpleDateFormat>();
                sdfList.add(new SimpleDateFormat("MMM", threadLocale.get()));
                sdfList.add(new SimpleDateFormat("MMMM", threadLocale.get()));
                sdfList.add(new SimpleDateFormat("EEE", threadLocale.get()));
                sdfList.add(new SimpleDateFormat("EEEE", threadLocale.get()));
                threadSDFArray.set(sdfList);
            }
            if (!((timeZone = scriptContext.findProperty("org.eclipse.birt.core.script.functionservice.context.timeZone")) instanceof TimeZone)) {
                timeZone = TimeZone.getDefault();
            }
            if (threadTimeZone.get() != timeZone) {
                threadTimeZone.set((TimeZone)timeZone);
            }
        }
        return this.executor.execute(arguments, scriptContext);
    }

    private static Calendar getDefaultFiscalYearStartDate(IScriptFunctionContext context) {
        Object property;
        Object object = property = context == null ? null : context.findProperty(PROPERTY_FISCAL_YEAR_START_DATE);
        if (property == null || property == UniqueTag.NOT_FOUND) {
            property = System.getProperty(PROPERTY_FISCAL_YEAR_START_DATE);
        }
        Calendar start = Calendar.getInstance();
        if (property != null) {
            try {
                java.util.Date date = FISCAL_YEAR_DATE_FORMAT.parse(property.toString());
                start.setTime(date);
                return start;
            }
            catch (ParseException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage());
            }
        }
        start.set(2, 6);
        start.set(5, 1);
        start.set(11, 0);
        start.set(12, 0);
        start.set(13, 0);
        start.set(14, 0);
        return start;
    }

    private static Calendar getFiscalYearStateDate(IScriptFunctionContext context, Object[] args) throws BirtException {
        if (args.length > 1) {
            return BirtDateTime.getCalendar(DataTypeUtil.toDate((Object)args[1]));
        }
        return BirtDateTime.getDefaultFiscalYearStartDate(context);
    }

    private static class Function_AddDay
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddDay() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.addDay(DataTypeUtil.toDate((Object)args[0]), ((Number)args[1]).intValue());
        }
    }

    private static class Function_AddHour
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddHour() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.addHour(DataTypeUtil.toDate((Object)args[0]), ((Number)args[1]).intValue());
        }
    }

    private static class Function_AddMinute
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddMinute() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.addMinute(DataTypeUtil.toDate((Object)args[0]), ((Number)args[1]).intValue());
        }
    }

    private static class Function_AddMonth
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddMonth() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.addMonth(DataTypeUtil.toDate((Object)args[0]), ((Number)args[1]).intValue());
        }
    }

    private static class Function_AddQuarter
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddQuarter() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.addQuarter(DataTypeUtil.toDate((Object)args[0]), ((Number)args[1]).intValue());
        }
    }

    private static class Function_AddSecond
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddSecond() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.addSecond(DataTypeUtil.toDate((Object)args[0]), ((Number)args[1]).intValue());
        }
    }

    private static class Function_AddWeek
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddWeek() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.addWeek(DataTypeUtil.toDate((Object)args[0]), ((Number)args[1]).intValue());
        }
    }

    private static class Function_AddYear
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddYear() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.addYear(DataTypeUtil.toDate((Object)args[0]), ((Number)args[1]).intValue());
        }
    }

    private static class Function_Date
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Date() {
            this.minParamCount = 3;
            this.maxParamCount = 6;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            int i = 0;
            while (i < args.length) {
                if (args[i] instanceof String) {
                    args[i] = Double.parseDouble((String)args[i]);
                }
                ++i;
            }
            if (args.length == 3) {
                return BirtDateTime.getDate(((Number)args[0]).intValue(), ((Number)args[1]).intValue(), ((Number)args[2]).intValue(), 0, 0, 0);
            }
            if (args.length == 4) {
                return BirtDateTime.getDate(((Number)args[0]).intValue(), ((Number)args[1]).intValue(), ((Number)args[2]).intValue(), ((Number)args[3]).intValue(), 0, 0);
            }
            if (args.length == 5) {
                return BirtDateTime.getDate(((Number)args[0]).intValue(), ((Number)args[1]).intValue(), ((Number)args[2]).intValue(), ((Number)args[3]).intValue(), ((Number)args[4]).intValue(), 0);
            }
            return BirtDateTime.getDate(((Number)args[0]).intValue(), ((Number)args[1]).intValue(), ((Number)args[2]).intValue(), ((Number)args[3]).intValue(), ((Number)args[4]).intValue(), ((Number)args[5]).intValue());
        }
    }

    private static class Function_Day
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Day() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.day(DataTypeUtil.toDate((Object)args[0]));
        }
    }

    private static class Function_DayOfMonth
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DayOfMonth() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.dayOfMonth(DataTypeUtil.toDate((Object)args[0]));
        }
    }

    private static class Function_DayOfQuarter
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DayOfQuarter() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            if (args[0] instanceof java.util.Date) {
                return BirtDateTime.dayOfQuarter((java.util.Date)args[0]);
            }
            return BirtDateTime.dayOfQuarter(DataTypeUtil.toDate((Object)args[0]));
        }
    }

    private static class Function_DayOfWeek
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DayOfWeek() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.dayOfWeek(DataTypeUtil.toDate((Object)args[0]));
        }
    }

    private static class Function_DayOfYear
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DayOfYear() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.dayOfYear(DataTypeUtil.toDate((Object)args[0]));
        }
    }

    private static class Function_DiffDay
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffDay() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.diffDay(DataTypeUtil.toDate((Object)args[0]), DataTypeUtil.toDate((Object)args[1]));
        }
    }

    private static class Function_DiffHour
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffHour() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.diffHour(DataTypeUtil.toDate((Object)args[0]), DataTypeUtil.toDate((Object)args[1]));
        }
    }

    private static class Function_DiffMinute
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffMinute() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.diffMinute(DataTypeUtil.toDate((Object)args[0]), DataTypeUtil.toDate((Object)args[1]));
        }
    }

    private static class Function_DiffMonth
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffMonth() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.diffMonth(DataTypeUtil.toDate((Object)args[0]), DataTypeUtil.toDate((Object)args[1]));
        }
    }

    private static class Function_DiffQuarter
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffQuarter() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.diffQuarter(DataTypeUtil.toDate((Object)args[0]), DataTypeUtil.toDate((Object)args[1]));
        }
    }

    private static class Function_DiffSecond
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffSecond() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.diffSecond(DataTypeUtil.toDate((Object)args[0]), DataTypeUtil.toDate((Object)args[1]));
        }
    }

    private static class Function_DiffWeek
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffWeek() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.diffWeek(DataTypeUtil.toDate((Object)args[0]), DataTypeUtil.toDate((Object)args[1]));
        }
    }

    private static class Function_DiffYear
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffYear() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.diffYear(DataTypeUtil.toDate((Object)args[0]), DataTypeUtil.toDate((Object)args[1]));
        }
    }

    private static class Function_FirstDayOfFiscalMonth
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_FirstDayOfFiscalMonth() {
            this.minParamCount = 1;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args, IScriptFunctionContext context) throws BirtException {
            Calendar current;
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            if (args[0] instanceof Number) {
                current = BirtDateTime.getFiscalYearStateDate(context, args);
                current.add(2, ((Number)args[0]).intValue() - 1);
            } else {
                current = BirtDateTime.getCalendar(DataTypeUtil.toDate((Object)args[0]));
                Calendar start = BirtDateTime.getFiscalYearStateDate(context, args);
                BirtDateTime.adjustFiscalMonth(current, start);
                current.set(5, Math.min(start.get(5), current.getActualMaximum(5)));
            }
            return current.getTime();
        }
    }

    private static class Function_FirstDayOfFiscalQuarter
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_FirstDayOfFiscalQuarter() {
            this.minParamCount = 1;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args, IScriptFunctionContext context) throws BirtException {
            Calendar current;
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            if (args[0] instanceof Number) {
                current = BirtDateTime.getFiscalYearStateDate(context, args);
                current.add(2, (((Number)args[0]).intValue() - 1) * 3);
            } else {
                current = BirtDateTime.getCalendar(DataTypeUtil.toDate((Object)args[0]));
                Calendar start = BirtDateTime.getFiscalYearStateDate(context, args);
                BirtDateTime.adjustFiscalMonth(current, start);
                int monthRemaindary = (current.get(2) - start.get(2) + 12) % 3;
                current.add(2, -monthRemaindary);
                current.set(5, Math.min(start.get(5), current.getActualMaximum(5)));
            }
            return current.getTime();
        }
    }

    private static class Function_FirstDayOfFiscalWeek
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_FirstDayOfFiscalWeek() {
            this.minParamCount = 1;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args, IScriptFunctionContext context) throws BirtException {
            Calendar current;
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            if (args[0] instanceof Number) {
                current = BirtDateTime.getFiscalYearStateDate(context, args);
                current.add(3, ((Number)args[0]).intValue() - 1);
            } else {
                current = BirtDateTime.getCalendar(DataTypeUtil.toDate((Object)args[0]));
            }
            current.set(7, current.getFirstDayOfWeek());
            return current.getTime();
        }
    }

    private static class Function_FirstDayOfFiscalYear
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_FirstDayOfFiscalYear() {
            this.minParamCount = 1;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args, IScriptFunctionContext context) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            Calendar current = null;
            if (args[0] instanceof Number) {
                current = BirtDateTime.getFiscalYearStateDate(context, args);
                current.set(1, ((Number)args[0]).intValue());
                if (current.get(6) > 1) {
                    current.add(1, -1);
                }
            } else {
                current = BirtDateTime.getCalendar(DataTypeUtil.toDate((Object)args[0]));
                Calendar start = BirtDateTime.getFiscalYearStateDate(context, args);
                BirtDateTime.adjustFiscalYear(current, start);
                current.set(2, start.get(2));
                current.set(5, Math.min(start.get(5), current.getActualMaximum(5)));
            }
            return current.getTime();
        }
    }

    private static class Function_FirstDayOfMonth
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_FirstDayOfMonth() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            Calendar cal = BirtDateTime.getCalendar(DataTypeUtil.toDate((Object)args[0]));
            cal.set(5, 1);
            return cal.getTime();
        }
    }

    private static class Function_FirstDayOfQuarter
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_FirstDayOfQuarter() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            java.util.Date date = DataTypeUtil.toDate((Object)args[0]);
            Calendar cal = BirtDateTime.getCalendar(date);
            int quarter = BirtDateTime.quarter(date);
            cal.set(2, (quarter - 1) * 3);
            cal.set(5, 1);
            return cal.getTime();
        }
    }

    private static class Function_FirstDayOfWeek
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_FirstDayOfWeek() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            Calendar cal = BirtDateTime.getCalendar(DataTypeUtil.toDate((Object)args[0]));
            cal.set(7, cal.getFirstDayOfWeek());
            return cal.getTime();
        }
    }

    private static class Function_FirstDayOfYear
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_FirstDayOfYear() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            Calendar cal = BirtDateTime.getCalendar(DataTypeUtil.toDate((Object)args[0]));
            cal.set(6, 1);
            return cal.getTime();
        }
    }

    private static class Function_FiscalDay
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_FiscalDay() {
            this.minParamCount = 1;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args, IScriptFunctionContext context) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            Calendar current = BirtDateTime.getCalendar(DataTypeUtil.toDate((Object)args[0]));
            Calendar start = BirtDateTime.getFiscalYearStateDate(context, args);
            BirtDateTime.adjustFiscalYear(current, start);
            return current.get(6);
        }
    }

    private static class Function_FiscalMonth
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_FiscalMonth() {
            this.minParamCount = 1;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args, IScriptFunctionContext context) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            Calendar current = BirtDateTime.getCalendar(DataTypeUtil.toDate((Object)args[0]));
            Calendar start = BirtDateTime.getFiscalYearStateDate(context, args);
            BirtDateTime.adjustFiscalYear(current, start);
            return current.get(2) + 1;
        }
    }

    private static class Function_FiscalQuarter
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_FiscalQuarter() {
            this.minParamCount = 1;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args, IScriptFunctionContext context) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            Calendar current = BirtDateTime.getCalendar(DataTypeUtil.toDate((Object)args[0]));
            Calendar start = BirtDateTime.getFiscalYearStateDate(context, args);
            BirtDateTime.adjustFiscalYear(current, start);
            return current.get(2) / 3 + 1;
        }
    }

    private static class Function_FiscalWeek
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_FiscalWeek() {
            this.minParamCount = 1;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args, IScriptFunctionContext context) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            Calendar current = BirtDateTime.getCalendar(DataTypeUtil.toDate((Object)args[0]));
            int currentWeek = current.get(3);
            Calendar start = BirtDateTime.getFiscalYearStateDate(context, args);
            start.set(1, current.get(1));
            int startWeek = start.get(3);
            if (currentWeek >= startWeek) {
                return currentWeek - startWeek + 1;
            }
            start.set(1, current.get(1) - 1);
            Calendar lastYearLastWeek = BirtDateTime.getCalendar(new java.util.Date(start.get(1) - 1, 11, 31));
            while (lastYearLastWeek.get(3) == 1) {
                lastYearLastWeek.add(5, -1);
            }
            return lastYearLastWeek.get(3) - start.get(3) + 1 + currentWeek;
        }
    }

    private static class Function_FiscalYear
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_FiscalYear() {
            this.minParamCount = 1;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args, IScriptFunctionContext context) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            Calendar current = BirtDateTime.getCalendar(DataTypeUtil.toDate((Object)args[0]));
            Calendar start = BirtDateTime.getFiscalYearStateDate(context, args);
            if (start.get(6) > 1) {
                BirtDateTime.adjustFiscalYear(current, start);
                return current.get(1) + 1;
            }
            return current.get(1);
        }
    }

    private static class Function_Hour
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Hour() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.hour(DataTypeUtil.toDate((Object)args[0]));
        }
    }

    private static class Function_Minute
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Minute() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.minute(DataTypeUtil.toDate((Object)args[0]));
        }
    }

    private static class Function_Month
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Month() {
            this.minParamCount = 1;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            java.util.Date date = null;
            date = args[0] instanceof java.util.Date ? (java.util.Date)args[0] : DataTypeUtil.toDate((Object)args[0]);
            if (args.length == 1) {
                return BirtDateTime.month(date);
            }
            return BirtDateTime.month(date, ((Number)args[1]).intValue());
        }
    }

    private static class Function_Now
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Now() {
            this.minParamCount = 0;
            this.maxParamCount = 0;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            return BirtDateTime.now();
        }
    }

    private static class Function_Quarter
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Quarter() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            if (args[0] instanceof java.util.Date) {
                return BirtDateTime.quarter((java.util.Date)args[0]);
            }
            return BirtDateTime.quarter(DataTypeUtil.toDate((Object)args[0]));
        }
    }

    private static class Function_Second
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Second() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.second(DataTypeUtil.toDate((Object)args[0]));
        }
    }

    private static class Function_Today
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Today() {
            this.minParamCount = 0;
            this.maxParamCount = 0;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.today();
        }
    }

    private static class Function_Week
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Week() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.week(DataTypeUtil.toDate((Object)args[0]));
        }
    }

    private static class Function_WeekDay
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_WeekDay() {
            this.minParamCount = 1;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            if (args.length == 1) {
                return BirtDateTime.weekDay(DataTypeUtil.toDate((Object)args[0]));
            }
            return BirtDateTime.weekDay(DataTypeUtil.toDate((Object)args[0]), ((Number)args[1]).intValue());
        }
    }

    private static class Function_WeekOfMonth
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_WeekOfMonth() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.weekOfMonth(DataTypeUtil.toDate((Object)args[0]));
        }
    }

    private static class Function_WeekOfQuarter
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_WeekOfQuarter() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            if (args[0] instanceof java.util.Date) {
                return BirtDateTime.weekOfQuarter((java.util.Date)args[0]);
            }
            return BirtDateTime.weekOfQuarter(DataTypeUtil.toDate((Object)args[0]));
        }
    }

    private static class Function_WeekOfYear
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_WeekOfYear() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.weekOfYear(DataTypeUtil.toDate((Object)args[0]));
        }
    }

    private static class Function_Year
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Year() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.year(DataTypeUtil.toDate((Object)args[0]));
        }
    }
}

