/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel.layout;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.OutputStream;
import java.util.Locale;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.layout.Page;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class ExcelContext {
    protected static final String DEFAULT_SHEET_NAME = "Report";
    private boolean wrappingText = true;
    private String officeVersion = "office2003";
    private String tempFileDir;
    private ULocale locale;
    private TimeZone timeZone;
    private Boolean hideGridlines = false;
    private boolean enableMultipleSheet = true;
    private boolean ignoreImage = true;
    private String sheetName;
    private String sheetPrefix;
    private OutputStream out;
    private IReportContent report;
    private int dpi;
    private boolean isAutoLayout = true;
    private int contentWidth;
    private int pageWidth;
    private int pageHeight;
    private int leftMargin;
    private int rightMargin;
    private int topMargin;
    private int bottomMargin;
    private int headerHeight;
    private int footerHeight;
    private int sheetIndex = 1;
    private boolean isRTL = false;
    private IReportContext reportContext;
    private Page page;

    public void initialize(IEmitterServices service) throws EngineException {
        IRenderOption renderOption;
        Object option;
        IReportContext reportContext;
        if (service == null) {
            return;
        }
        this.out = EmitterUtil.getOuputStream((IEmitterServices)service, (String)"report.xls");
        if (service.getReportEngine() != null) {
            this.tempFileDir = service.getReportEngine().getConfig().getTempDir();
        }
        if ((reportContext = service.getReportContext()) != null) {
            Locale locale = reportContext.getLocale();
            this.locale = locale == null ? ULocale.getDefault() : ULocale.forLocale((Locale)locale);
            this.timeZone = reportContext.getTimeZone();
            if (this.timeZone == null) {
                this.timeZone = TimeZone.getDefault();
            }
        }
        if ((option = (renderOption = service.getRenderOption()).getOption("excelRenderOption.multipleSheet")) instanceof Boolean) {
            this.enableMultipleSheet = (Boolean)option;
        }
        this.reportContext = service.getReportContext();
    }

    public IReportContext getReportContext() {
        return this.reportContext;
    }

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public void setReport(IReportContent report) {
        Object ignoreImage;
        Object hideGridlines;
        Object officeVersion;
        this.report = report;
        IRenderOption renderOptions = report.getReportContext().getRenderOption();
        Object dpi = renderOptions.getOption("RenderDpi");
        int renderDpi = 0;
        if (dpi != null && dpi instanceof Integer) {
            renderDpi = (Integer)dpi;
        }
        this.dpi = PropertyUtil.getRenderDpi((IReportContent)report, (int)renderDpi);
        Object textWrapping = renderOptions.getOption("excelRenderOption.wrappingText");
        if (textWrapping instanceof Boolean) {
            this.wrappingText = (Boolean)textWrapping;
        }
        if ("office2007".equals(officeVersion = renderOptions.getOption("excelRenderOption.officeVersion"))) {
            this.officeVersion = "office2007";
        }
        if ((hideGridlines = renderOptions.getOption("excelRenderOption.hideGridlines")) instanceof Boolean) {
            this.hideGridlines = (Boolean)hideGridlines;
        }
        if ((ignoreImage = renderOptions.getOption("excelRenderOption.ignoreImage")) instanceof Boolean) {
            this.ignoreImage = (Boolean)ignoreImage;
        }
        ReportDesignHandle designHandle = report.getDesign().getReportDesign();
        this.parseReportOrientation(designHandle);
        this.parseReportLayout(designHandle);
        this.parseSheetName(designHandle);
    }

    private void parseSheetName(ReportDesignHandle designHandle) {
        String reportTitle = designHandle.getStringProperty("title");
        this.sheetPrefix = reportTitle != null ? reportTitle : DEFAULT_SHEET_NAME;
        this.sheetPrefix = ExcelUtil.getValidSheetName(this.sheetPrefix);
        this.sheetName = this.generateSheetName();
    }

    private String generateSheetName() {
        if (this.sheetIndex == 1) {
            return this.sheetPrefix;
        }
        int indexLength = String.valueOf(this.sheetIndex - 1).length();
        if (this.sheetPrefix.length() + indexLength > 31) {
            return String.valueOf(this.sheetPrefix.substring(0, 31 - indexLength)) + (this.sheetIndex - 1);
        }
        return String.valueOf(this.sheetPrefix) + (this.sheetIndex - 1);
    }

    private void parseReportLayout(ReportDesignHandle designHandle) {
        String reportLayoutPreference = designHandle.getLayoutPreference();
        if ("fixed layout".equals(reportLayoutPreference)) {
            this.isAutoLayout = false;
        }
    }

    private void parseReportOrientation(ReportDesignHandle designHandle) {
        String reportOrientation = designHandle.getBidiOrientation();
        if ("rtl".equalsIgnoreCase(reportOrientation)) {
            this.isRTL = true;
        }
    }

    public void parsePageSize(IPageContent page) {
        this.pageWidth = ExcelUtil.convertDimensionType(page.getPageWidth(), 0.0f, this.dpi);
        this.pageHeight = ExcelUtil.convertDimensionType(page.getPageHeight(), 0.0f, this.dpi);
        this.leftMargin = ExcelUtil.convertDimensionType(page.getMarginLeft(), this.pageWidth, this.dpi);
        this.rightMargin = ExcelUtil.convertDimensionType(page.getMarginRight(), this.pageWidth, this.dpi);
        this.topMargin = ExcelUtil.convertDimensionType(page.getMarginTop(), this.pageHeight, this.dpi);
        this.bottomMargin = ExcelUtil.convertDimensionType(page.getMarginBottom(), this.pageHeight, this.dpi);
        this.headerHeight = ExcelUtil.convertDimensionType(page.getHeaderHeight(), this.pageHeight, this.dpi);
        this.footerHeight = ExcelUtil.convertDimensionType(page.getFooterHeight(), this.pageHeight, this.dpi);
        this.contentWidth = this.pageWidth - this.leftMargin - this.rightMargin;
    }

    public boolean getWrappingText() {
        return this.wrappingText;
    }

    public String getOfficeVersion() {
        return this.officeVersion;
    }

    public String getTempFileDir() {
        return this.tempFileDir;
    }

    public ULocale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public boolean isEnableMultipleSheet() {
        return this.enableMultipleSheet;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public boolean getHideGridlines() {
        return this.hideGridlines;
    }

    public boolean isIgnoreImage() {
        return this.ignoreImage;
    }

    public void setIgnoreImage(boolean isIgnoreImage) {
        this.ignoreImage = isIgnoreImage;
    }

    public OutputStream getOutputSteam() {
        return this.out;
    }

    public IReportContent getReport() {
        return this.report;
    }

    public int getDpi() {
        return this.dpi;
    }

    public boolean isRTL() {
        return this.isRTL;
    }

    public void setSheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
        this.sheetName = this.generateSheetName();
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public boolean isAutoLayout() {
        return this.isAutoLayout;
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public float getTopMargin() {
        return (float)this.topMargin / 1000.0f;
    }

    public float getBottomMargin() {
        return (float)this.bottomMargin / 1000.0f;
    }

    public float getLeftMargin() {
        return (float)this.leftMargin / 1000.0f;
    }

    public float getRightMargin() {
        return (float)this.rightMargin / 1000.0f;
    }

    public float getHeaderHeight() {
        return (float)this.headerHeight / 1000.0f;
    }

    public float getFooterHeight() {
        return (float)this.footerHeight / 1000.0f;
    }
}

