/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api.querydefn;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.api.timefunction.ITimeFunction;
import org.eclipse.birt.data.engine.core.DataException;

public class Binding
implements IBinding {
    private List<String> aggregateOn;
    private Map<String, IBaseExpression> argument;
    private List<IBaseExpression> orderedArgument;
    private IBaseExpression expr;
    private IBaseExpression filter;
    private String aggrFunc;
    private String name;
    private String displayName;
    private int dataType;
    private boolean exportable;
    private ITimeFunction timeFunction;

    public Binding(String name) {
        this(name, null);
    }

    public Binding(String name, IBaseExpression expr) {
        this.name = name;
        this.expr = expr;
        this.aggregateOn = new ArrayList<String>();
        this.argument = new LinkedHashMap<String, IBaseExpression>();
        this.dataType = expr != null ? expr.getDataType() : 0;
        this.exportable = true;
    }

    @Override
    public void addAggregateOn(String levelName) throws DataException {
        if (!this.aggregateOn.contains(levelName)) {
            this.aggregateOn.add(levelName);
        }
    }

    @Override
    @Deprecated
    public void addArgument(IBaseExpression expr) {
        if (expr != null) {
            if (this.orderedArgument == null) {
                this.orderedArgument = new ArrayList<IBaseExpression>();
            }
            this.orderedArgument.add(expr);
        }
    }

    @Override
    public void addArgument(String name, IBaseExpression expr) {
        if ("Data Field".equals(name)) {
            this.argument.put("Expression", expr);
        } else {
            this.argument.put(name, expr);
        }
        this.orderedArgument = null;
    }

    public void removeArgument(IBaseExpression expr) {
        this.argument.values().remove(expr);
        this.orderedArgument = null;
    }

    @Override
    public String getAggrFunction() {
        return this.aggrFunc;
    }

    @Override
    public List getAggregatOns() {
        return this.aggregateOn;
    }

    @Override
    public List getArguments() throws DataException {
        if (this.orderedArgument != null) {
            return this.orderedArgument;
        }
        this.orderedArgument = new ArrayList<IBaseExpression>();
        if (this.aggrFunc == null) {
            return this.orderedArgument;
        }
        IAggrFunction info = AggregationManager.getInstance().getAggregation(this.aggrFunc);
        if (info == null) {
            return this.orderedArgument;
        }
        IParameterDefn[] parameters = info.getParameterDefn();
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                IParameterDefn pInfo = parameters[i];
                if (this.argument.get(pInfo.getName()) != null) {
                    this.orderedArgument.add(this.argument.get(pInfo.getName()));
                }
                ++i;
            }
        }
        return this.orderedArgument;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public IBaseExpression getFilter() {
        return this.filter;
    }

    @Override
    public void setAggrFunction(String functionName) {
        this.aggrFunc = functionName;
    }

    @Override
    public void setDataType(int type) {
        this.dataType = type;
    }

    @Override
    public void setExpression(IBaseExpression expr) {
        this.expr = expr;
    }

    @Override
    public void setFilter(IBaseExpression expr) {
        this.filter = expr;
    }

    @Override
    public String getBindingName() {
        return this.name;
    }

    @Override
    public IBaseExpression getExpression() {
        return this.expr;
    }

    @Override
    public String getDisplayName() throws DataException {
        return this.displayName == null ? this.name : this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) throws DataException {
        this.displayName = displayName;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Binding other = (Binding)obj;
        return this.name.equals(other.getBindingName());
    }

    @Override
    public boolean exportable() throws DataException {
        return this.exportable;
    }

    @Override
    public void setExportable(boolean exportable) throws DataException {
        this.exportable = exportable;
    }

    @Override
    public void setTimeFunction(ITimeFunction timeFunction) {
        this.timeFunction = timeFunction;
    }

    @Override
    public ITimeFunction getTimeFunction() {
        return this.timeFunction;
    }

    public IBinding clone() {
        Binding n = new Binding(this.name, this.expr);
        n.expr = this.expr;
        n.aggrFunc = this.aggrFunc;
        n.dataType = this.dataType;
        n.displayName = this.displayName;
        n.exportable = this.exportable;
        n.filter = this.filter;
        n.timeFunction = this.timeFunction;
        for (String string : this.aggregateOn) {
            n.aggregateOn.add(string);
        }
        if (this.orderedArgument != null) {
            for (IBaseExpression iBaseExpression : this.orderedArgument) {
                n.orderedArgument.add(iBaseExpression);
            }
        }
        for (Map.Entry entry : this.argument.entrySet()) {
            n.argument.put((String)entry.getKey(), (IBaseExpression)entry.getValue());
        }
        return n;
    }
}

