/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.calculator;

import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.aggregation.calculator.ICalculator;
import org.eclipse.birt.data.engine.core.DataException;

public class NumberCalculator
implements ICalculator {
    @Override
    public Number add(Object a, Object b) throws DataException {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return (Double)b;
        }
        if (b == null) {
            return (Double)a;
        }
        if (this.isNaNorInfinity(a, b)) {
            return Double.NaN;
        }
        return (Double)a + (Double)b;
    }

    @Override
    public Number subtract(Object a, Object b) throws DataException {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return 0.0 - (Double)b;
        }
        if (b == null) {
            return (Double)a;
        }
        if (this.isNaNorInfinity(a, b)) {
            return Double.NaN;
        }
        return (Double)a - (Double)b;
    }

    @Override
    public Number multiply(Object a, Object b) throws DataException {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return (Double)b;
        }
        if (b == null) {
            return (Double)a;
        }
        if (this.isNaNorInfinity(a, b)) {
            return Double.NaN;
        }
        return (Double)a * (Double)b;
    }

    @Override
    public Number divide(Object dividend, Object divisor) throws DataException {
        if (dividend == null) {
            return null;
        }
        if (divisor == null) {
            return (Double)dividend;
        }
        if (this.isNaNorInfinity(dividend, divisor)) {
            return Double.NaN;
        }
        return (Double)dividend / (Double)divisor;
    }

    @Override
    public Number safeDivide(Object dividend, Object divisor, Number ifZero) throws DataException {
        try {
            return this.divide(dividend, divisor);
        }
        catch (ArithmeticException arithmeticException) {
            return ifZero;
        }
    }

    @Override
    public Object getTypedObject(Object obj) throws DataException {
        try {
            return DataTypeUtil.toDouble((Object)obj);
        }
        catch (BirtException e) {
            throw DataException.wrap((BirtException)e);
        }
    }

    protected boolean isNaNorInfinity(Object a, Object b) {
        return this.isNaNorInfinity(a) || this.isNaNorInfinity(b);
    }

    protected boolean isNaNorInfinity(Object a) {
        return a instanceof Double && (((Double)a).isInfinite() || ((Double)a).isNaN()) || a instanceof Float && (((Float)a).isInfinite() || ((Float)a).isNaN());
    }
}

