/*
 * Decompiled with CFR 0.152.
 */
package razerdp.widget;

import android.app.Dialog;
import android.content.Context;
import android.util.Pair;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import razerdp.basepopup.BasePopupWindow;
import razerdp.basepopup.QuickPopupBuilder;
import razerdp.basepopup.QuickPopupConfig;
import razerdp.widget.OnQuickPopupClickListenerWrapper;

public class QuickPopup
extends BasePopupWindow {
    private QuickPopupConfig mConfig;
    private QuickPopupBuilder mBuilder;

    public QuickPopup(Fragment fragment, QuickPopupBuilder builder) {
        super(fragment, builder.getWidth(), builder.getHeight());
        this.mBuilder = builder;
        this.mConfig = builder.getConfig();
        if (this.mConfig == null) {
            throw new NullPointerException("QuickPopupConfig must be not null!");
        }
        this.setContentView(this.mConfig.getContentViewLayoutid());
    }

    public QuickPopup(Dialog dialog, QuickPopupBuilder builder) {
        super(dialog, builder.getWidth(), builder.getHeight());
        this.mBuilder = builder;
        this.mConfig = builder.getConfig();
        if (this.mConfig == null) {
            throw new NullPointerException("QuickPopupConfig must be not null!");
        }
        this.setContentView(this.mConfig.getContentViewLayoutid());
    }

    public QuickPopup(Context context, QuickPopupBuilder builder) {
        super(context, builder.getWidth(), builder.getHeight());
        this.mBuilder = builder;
        this.mConfig = builder.getConfig();
        if (this.mConfig == null) {
            throw new NullPointerException("QuickPopupConfig must be not null!");
        }
        this.setContentView(this.mConfig.getContentViewLayoutid());
    }

    @Override
    public void onViewCreated(View contentView) {
        super.onViewCreated(contentView);
        this.applyConfigSetting(this.mConfig);
    }

    protected <C extends QuickPopupConfig> void applyConfigSetting(C config) {
        if (config.getPopupBlurOption() != null) {
            this.setBlurOption(config.getPopupBlurOption());
        } else {
            this.setBlurBackgroundEnable((config.flag & 0x4000) != 0, config.getOnBlurOptionInitListener());
        }
        this.setPopupFadeEnable((config.flag & 0x80) != 0);
        for (Map.Entry<String, Object> entry : config.getInvokeParams().entrySet()) {
            String methodName = entry.getKey();
            Method method = config.getMethod(methodName);
            if (method == null) continue;
            try {
                method.invoke((Object)this, entry.getValue());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.applyClick();
    }

    private void applyClick() {
        HashMap<Integer, Pair<View.OnClickListener, Boolean>> eventsMap = this.mConfig.getListenersHolderMap();
        if (eventsMap == null || eventsMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, Pair<View.OnClickListener, Boolean>> entry : eventsMap.entrySet()) {
            int viewId = entry.getKey();
            final Pair<View.OnClickListener, Boolean> event = entry.getValue();
            Object v = this.findViewById(viewId);
            if (v == null) continue;
            if (((Boolean)event.second).booleanValue()) {
                v.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (event.first != null) {
                            if (event.first instanceof OnQuickPopupClickListenerWrapper) {
                                ((OnQuickPopupClickListenerWrapper)event.first).mQuickPopup = QuickPopup.this;
                            }
                            ((View.OnClickListener)event.first).onClick(v);
                        }
                        QuickPopup.this.dismiss();
                    }
                });
                continue;
            }
            v.setOnClickListener((View.OnClickListener)event.first);
        }
    }

    @Nullable
    public QuickPopupConfig getConfig() {
        return this.mConfig;
    }

    @Override
    public void onDestroy() {
        if (this.mBuilder != null) {
            this.mBuilder.clear(true);
        }
        this.mBuilder = null;
        this.mConfig = null;
        super.onDestroy();
    }
}

