/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.animation.Animator;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Message;
import android.util.Log;
import android.view.DisplayCutout;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import razerdp.basepopup.BasePopupEvent;
import razerdp.basepopup.BasePopupFlag;
import razerdp.basepopup.BasePopupSDK;
import razerdp.basepopup.BasePopupUnsafe;
import razerdp.basepopup.BasePopupWindow;
import razerdp.basepopup.ClearMemoryObject;
import razerdp.basepopup.WindowManagerProxy;
import razerdp.blur.PopupBlurOption;
import razerdp.library.R;
import razerdp.util.KeyboardUtils;
import razerdp.util.PopupUiUtils;
import razerdp.util.PopupUtils;
import razerdp.util.log.PopupLog;

final class BasePopupHelper
implements KeyboardUtils.OnKeyboardChangeListener,
BasePopupFlag,
ClearMemoryObject {
    BasePopupWindow mPopupWindow;
    WeakHashMap<Object, BasePopupEvent.EventObserver> eventObserverMap;
    Map<Integer, Boolean> mFlagCacheMap;
    static final long DEFAULT_KEYBOARD_SHOW_DELAY = 350L;
    static final int DEFAULT_OVERLAY_STATUS_BAR_MODE = 0x30000000;
    static final int DEFAULT_OVERLAY_NAVIGATION_BAR_MODE = 0x10000000;
    private static final int CONTENT_VIEW_ID = R.id.base_popup_content_root;
    static final int STATUS_START_SHOWING = 1;
    static final int STATUS_START_DISMISS = 2;
    int showFlag = 0;
    BasePopupWindow.Priority priority = BasePopupWindow.Priority.NORMAL;
    ShowMode mShowMode = ShowMode.SCREEN;
    int contentRootId = CONTENT_VIEW_ID;
    int flag = 151916733;
    Animation mShowAnimation;
    Animator mShowAnimator;
    Animation mDismissAnimation;
    Animator mDismissAnimator;
    boolean preventInitShowAnimation;
    boolean preventInitDismissAnimation;
    Animation mMaskViewShowAnimation;
    Animation mMaskViewDismissAnimation;
    boolean isDefaultMaskViewShowAnimation;
    boolean isDefaultMaskViewDismissAnimation;
    boolean overlayMask = false;
    long showDuration;
    long dismissDuration;
    long showKeybaordDelay = 350L;
    int animationStyleRes;
    BasePopupWindow.OnDismissListener mOnDismissListener;
    BasePopupWindow.OnBeforeShowCallback mOnBeforeShowCallback;
    BasePopupWindow.OnPopupWindowShowListener mOnPopupWindowShowListener;
    BasePopupWindow.GravityMode horizontalGravityMode = BasePopupWindow.GravityMode.RELATIVE_TO_ANCHOR;
    BasePopupWindow.GravityMode verticalGravityMode = BasePopupWindow.GravityMode.RELATIVE_TO_ANCHOR;
    int popupGravity = 0;
    int offsetX;
    int offsetY;
    int maskOffsetX;
    int maskOffsetY;
    int preMeasureWidth;
    int preMeasureHeight;
    int keyboardGravity = 80;
    int keyboardOffsetX;
    int keyboardOffsetY;
    int popupViewWidth = 0;
    int popupViewHeight = 0;
    int layoutDirection = 0;
    Rect mAnchorViewBound;
    PopupBlurOption mBlurOption;
    Drawable mBackgroundDrawable = new ColorDrawable(BasePopupWindow.DEFAULT_BACKGROUND_COLOR);
    int alignBackgroundGravity = 48;
    View mBackgroundView;
    EditText mAutoShowInputEdittext;
    KeyboardUtils.OnKeyboardChangeListener mKeyboardStateChangeListener;
    KeyboardUtils.OnKeyboardChangeListener mUserKeyboardStateChangeListener;
    BasePopupWindow.KeyEventListener mKeyEventListener;
    int mSoftInputMode = 1;
    ViewGroup.MarginLayoutParams layoutParams;
    int maxWidth;
    int maxHeight;
    int minWidth;
    int minHeight;
    int keybaordAlignViewId;
    View keybaordAlignView;
    InnerShowInfo mShowInfo;
    ViewTreeObserver.OnGlobalLayoutListener mGlobalLayoutListener;
    LinkedViewLayoutChangeListenerWrapper mLinkedViewLayoutChangeListenerWrapper;
    View mLinkedTarget;
    Rect navigationBarBounds;
    Rect cutoutSafeRect;
    int lastOverLayStatusBarMode;
    int overlayStatusBarMode = 0x30000000;
    int lastOverlayNavigationBarMode;
    int overlayNavigationBarMode = 0x10000000;
    boolean hideKeyboardOnDismiss = true;
    BasePopupUnsafe.OnFitWindowManagerLayoutParamsCallback mOnFitWindowManagerLayoutParamsCallback;
    private Runnable dismissAnimationDelayRunnable = new Runnable(){

        @Override
        public void run() {
            BasePopupHelper.this.flag &= 0xFF7FFFFF;
            if (BasePopupHelper.this.mPopupWindow != null) {
                BasePopupHelper.this.mPopupWindow.superDismiss();
            }
        }
    };

    BasePopupHelper(BasePopupWindow popupWindow) {
        this.mFlagCacheMap = new HashMap<Integer, Boolean>();
        this.mAnchorViewBound = new Rect();
        this.navigationBarBounds = new Rect();
        this.cutoutSafeRect = new Rect();
        this.mPopupWindow = popupWindow;
        this.eventObserverMap = new WeakHashMap();
        this.mMaskViewShowAnimation = new AlphaAnimation(0.0f, 1.0f);
        this.mMaskViewDismissAnimation = new AlphaAnimation(1.0f, 0.0f);
        this.mMaskViewShowAnimation.setFillAfter(true);
        this.mMaskViewShowAnimation.setInterpolator((Interpolator)new DecelerateInterpolator());
        this.mMaskViewShowAnimation.setDuration((long)Resources.getSystem().getInteger(0x10E0000));
        this.isDefaultMaskViewShowAnimation = true;
        this.mMaskViewDismissAnimation.setFillAfter(true);
        this.mMaskViewDismissAnimation.setInterpolator((Interpolator)new DecelerateInterpolator());
        this.mMaskViewDismissAnimation.setDuration((long)Resources.getSystem().getInteger(0x10E0000));
        this.isDefaultMaskViewDismissAnimation = true;
    }

    void cacheFlag(int flag, boolean onceCache) {
        if (onceCache && this.mFlagCacheMap.containsKey(flag)) {
            return;
        }
        this.mFlagCacheMap.put(flag, (this.flag & flag) != 0);
    }

    boolean restoreFlag(int flag, boolean defaultValue) {
        if (this.mFlagCacheMap.containsKey(flag)) {
            return this.mFlagCacheMap.remove(flag);
        }
        return defaultValue;
    }

    void observerEvent(Object who, BasePopupEvent.EventObserver observer) {
        this.eventObserverMap.put(who, observer);
    }

    void removeEventObserver(Object who) {
        this.eventObserverMap.remove(who);
    }

    void sendEvent(Message msg) {
        if (msg == null) {
            return;
        }
        if (msg.what < 0) {
            return;
        }
        for (Map.Entry<Object, BasePopupEvent.EventObserver> entry : this.eventObserverMap.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().onEvent(msg);
        }
    }

    View inflate(Context context, int layoutId) {
        try {
            FrameLayout tempLayout = new FrameLayout(context);
            View result = LayoutInflater.from((Context)context).inflate(layoutId, (ViewGroup)tempLayout, false);
            ViewGroup.LayoutParams childParams = result.getLayoutParams();
            if (childParams != null) {
                this.checkAndSetGravity(childParams);
                this.layoutParams = childParams instanceof ViewGroup.MarginLayoutParams ? new ViewGroup.MarginLayoutParams((ViewGroup.MarginLayoutParams)childParams) : new ViewGroup.MarginLayoutParams(childParams);
                if (this.popupViewWidth != 0 && this.layoutParams.width != this.popupViewWidth) {
                    this.layoutParams.width = this.popupViewWidth;
                }
                if (this.popupViewHeight != 0 && this.layoutParams.height != this.popupViewHeight) {
                    this.layoutParams.height = this.popupViewHeight;
                }
                tempLayout = null;
                return result;
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    void preMeasurePopupView(View mContentView, int w, int h) {
        if (mContentView != null) {
            int measureWidth = View.MeasureSpec.makeMeasureSpec((int)Math.max(w, 0), (int)(w == -2 ? 0 : 0x40000000));
            int measureHeight = View.MeasureSpec.makeMeasureSpec((int)Math.max(w, h), (int)(h == -2 ? 0 : 0x40000000));
            mContentView.measure(measureWidth, measureHeight);
            this.preMeasureWidth = mContentView.getMeasuredWidth();
            this.preMeasureHeight = mContentView.getMeasuredHeight();
            mContentView.setFocusableInTouchMode(true);
        }
    }

    void checkAndSetGravity(ViewGroup.LayoutParams p) {
        if (p == null || this.popupGravity != 0) {
            return;
        }
        if (p instanceof LinearLayout.LayoutParams) {
            this.popupGravity = ((LinearLayout.LayoutParams)p).gravity;
        } else if (p instanceof FrameLayout.LayoutParams) {
            this.popupGravity = ((FrameLayout.LayoutParams)p).gravity;
        }
    }

    void startShowAnimate(int width, int height) {
        if (!this.preventInitShowAnimation && this.initShowAnimation(width, height) == null) {
            this.initShowAnimator(width, height);
        }
        this.preventInitShowAnimation = true;
        Message msg = Message.obtain();
        msg.what = 1;
        this.sendEvent(msg);
        if (this.mShowAnimation != null) {
            this.mShowAnimation.cancel();
            this.mPopupWindow.mDisplayAnimateView.startAnimation(this.mShowAnimation);
        } else if (this.mShowAnimator != null) {
            this.mShowAnimator.setTarget((Object)this.mPopupWindow.getDisplayAnimateView());
            this.mShowAnimator.cancel();
            this.mShowAnimator.start();
        }
    }

    void startDismissAnimate(int width, int height) {
        if (!this.preventInitDismissAnimation && this.initDismissAnimation(width, height) == null) {
            this.initDismissAnimator(width, height);
        }
        this.preventInitDismissAnimation = true;
        if (this.mDismissAnimation != null) {
            this.mDismissAnimation.cancel();
            this.mPopupWindow.mDisplayAnimateView.startAnimation(this.mDismissAnimation);
            if (this.mOnDismissListener != null) {
                this.mOnDismissListener.onDismissAnimationStart();
            }
            this.setFlag(0x800000, true);
        } else if (this.mDismissAnimator != null) {
            this.mDismissAnimator.setTarget((Object)this.mPopupWindow.getDisplayAnimateView());
            this.mDismissAnimator.cancel();
            this.mDismissAnimator.start();
            if (this.mOnDismissListener != null) {
                this.mOnDismissListener.onDismissAnimationStart();
            }
            this.setFlag(0x800000, true);
        }
    }

    Animation initShowAnimation(int width, int height) {
        if (this.mShowAnimation == null) {
            this.mShowAnimation = this.mPopupWindow.onCreateShowAnimation(width, height);
            if (this.mShowAnimation != null) {
                this.showDuration = PopupUtils.getAnimationDuration(this.mShowAnimation, 0L);
                this.setToBlur(this.mBlurOption);
            }
        }
        return this.mShowAnimation;
    }

    Animator initShowAnimator(int width, int height) {
        if (this.mShowAnimator == null) {
            this.mShowAnimator = this.mPopupWindow.onCreateShowAnimator(width, height);
            if (this.mShowAnimator != null) {
                this.showDuration = PopupUtils.getAnimatorDuration(this.mShowAnimator, 0L);
                this.setToBlur(this.mBlurOption);
            }
        }
        return this.mShowAnimator;
    }

    Animation initDismissAnimation(int width, int height) {
        if (this.mDismissAnimation == null) {
            this.mDismissAnimation = this.mPopupWindow.onCreateDismissAnimation(width, height);
            if (this.mDismissAnimation != null) {
                this.dismissDuration = PopupUtils.getAnimationDuration(this.mDismissAnimation, 0L);
                this.setToBlur(this.mBlurOption);
            }
        }
        return this.mDismissAnimation;
    }

    Animator initDismissAnimator(int width, int height) {
        if (this.mDismissAnimator == null) {
            this.mDismissAnimator = this.mPopupWindow.onCreateDismissAnimator(width, height);
            if (this.mDismissAnimator != null) {
                this.dismissDuration = PopupUtils.getAnimatorDuration(this.mDismissAnimator, 0L);
                this.setToBlur(this.mBlurOption);
            }
        }
        return this.mDismissAnimator;
    }

    void setToBlur(PopupBlurOption option) {
        this.mBlurOption = option;
        if (option != null) {
            if (option.getBlurInDuration() <= 0L && this.showDuration > 0L) {
                option.setBlurInDuration(this.showDuration);
            }
            if (option.getBlurOutDuration() <= 0L && this.dismissDuration > 0L) {
                option.setBlurOutDuration(this.dismissDuration);
            }
        }
    }

    void setShowAnimation(Animation showAnimation) {
        if (this.mShowAnimation == showAnimation) {
            return;
        }
        if (this.mShowAnimation != null) {
            this.mShowAnimation.cancel();
        }
        this.mShowAnimation = showAnimation;
        this.showDuration = PopupUtils.getAnimationDuration(this.mShowAnimation, 0L);
        this.setToBlur(this.mBlurOption);
    }

    void setShowAnimator(Animator showAnimator) {
        if (this.mShowAnimation != null || this.mShowAnimator == showAnimator) {
            return;
        }
        if (this.mShowAnimator != null) {
            this.mShowAnimator.cancel();
        }
        this.mShowAnimator = showAnimator;
        this.showDuration = PopupUtils.getAnimatorDuration(this.mShowAnimator, 0L);
        this.setToBlur(this.mBlurOption);
    }

    void setDismissAnimation(Animation dismissAnimation) {
        if (this.mDismissAnimation == dismissAnimation) {
            return;
        }
        if (this.mDismissAnimation != null) {
            this.mDismissAnimation.cancel();
        }
        this.mDismissAnimation = dismissAnimation;
        this.dismissDuration = PopupUtils.getAnimationDuration(this.mDismissAnimation, 0L);
        this.setToBlur(this.mBlurOption);
    }

    void setDismissAnimator(Animator dismissAnimator) {
        if (this.mDismissAnimation != null || this.mDismissAnimator == dismissAnimator) {
            return;
        }
        if (this.mDismissAnimator != null) {
            this.mDismissAnimator.cancel();
        }
        this.mDismissAnimator = dismissAnimator;
        this.dismissDuration = PopupUtils.getAnimatorDuration(this.mDismissAnimator, 0L);
        this.setToBlur(this.mBlurOption);
    }

    BasePopupHelper setPopupViewWidth(int popupViewWidth) {
        if (popupViewWidth != 0) {
            this.getLayoutParams().width = popupViewWidth;
        }
        return this;
    }

    BasePopupHelper setPopupViewHeight(int popupViewHeight) {
        if (popupViewHeight != 0) {
            this.getLayoutParams().height = popupViewHeight;
        }
        return this;
    }

    int getPreMeasureWidth() {
        return this.preMeasureWidth;
    }

    int getPreMeasureHeight() {
        return this.preMeasureHeight;
    }

    boolean isPopupFadeEnable() {
        return (this.flag & 0x80) != 0;
    }

    boolean isWithAnchor() {
        return (this.flag & 0x200) != 0;
    }

    boolean isFitsizable() {
        return (this.flag & 0x1000) != 0;
    }

    BasePopupHelper withAnchor(boolean showAsDropDown) {
        this.setFlag(512, showAsDropDown);
        if (showAsDropDown && (this.popupGravity == 0 || this.popupGravity == -1)) {
            this.popupGravity = 80;
        }
        return this;
    }

    BasePopupHelper setShowLocation(int x, int y) {
        this.mAnchorViewBound.set(x, y, x + 1, y + 1);
        return this;
    }

    int getPopupGravity() {
        return Gravity.getAbsoluteGravity((int)this.popupGravity, (int)this.layoutDirection);
    }

    BasePopupHelper setLayoutDirection(int layoutDirection) {
        this.layoutDirection = layoutDirection;
        return this;
    }

    BasePopupHelper setPopupGravity(BasePopupWindow.GravityMode mode, int popupGravity) {
        this.setPopupGravityMode(mode, mode);
        this.popupGravity = popupGravity;
        return this;
    }

    BasePopupHelper setPopupGravityMode(BasePopupWindow.GravityMode horizontalGravityMode, BasePopupWindow.GravityMode verticalGravityMode) {
        this.horizontalGravityMode = horizontalGravityMode;
        this.verticalGravityMode = verticalGravityMode;
        return this;
    }

    int getOffsetX() {
        return this.offsetX;
    }

    int getOffsetY() {
        return this.offsetY;
    }

    boolean isAutoShowInputMethod() {
        return (this.flag & 0x400) != 0;
    }

    boolean isAutoMirror() {
        return (this.flag & 0x100) != 0;
    }

    boolean isOutSideDismiss() {
        return (this.flag & 1) != 0;
    }

    boolean isOutSideTouchable() {
        return (this.flag & 2) != 0;
    }

    BasePopupHelper getAnchorLocation(View v) {
        if (v == null) {
            if (this.mShowMode != ShowMode.POSITION) {
                this.mAnchorViewBound.setEmpty();
            }
            return this;
        }
        int[] location = new int[2];
        v.getLocationOnScreen(location);
        this.mAnchorViewBound.set(location[0], location[1], location[0] + v.getWidth(), location[1] + v.getHeight());
        return this;
    }

    public Rect getAnchorViewBound() {
        return this.mAnchorViewBound;
    }

    boolean isBackPressEnable() {
        return (this.flag & 4) != 0;
    }

    boolean isOverlayStatusbar() {
        return (this.flag & 8) != 0;
    }

    boolean isOverlayNavigationBar() {
        return (this.flag & 0x20) != 0;
    }

    void refreshNavigationBarBounds() {
        PopupUiUtils.getNavigationBarBounds(this.navigationBarBounds, (Context)this.mPopupWindow.getContext());
    }

    int getNavigationBarSize() {
        return Math.min(this.navigationBarBounds.width(), this.navigationBarBounds.height());
    }

    int getNavigationBarGravity() {
        return PopupUiUtils.getNavigationBarGravity(this.navigationBarBounds);
    }

    public int getCutoutGravity() {
        this.getSafeInsetBounds(this.cutoutSafeRect);
        if (this.cutoutSafeRect.left > 0) {
            return 3;
        }
        if (this.cutoutSafeRect.top > 0) {
            return 48;
        }
        if (this.cutoutSafeRect.right > 0) {
            return 5;
        }
        if (this.cutoutSafeRect.bottom > 0) {
            return 80;
        }
        return 0;
    }

    void getSafeInsetBounds(Rect r) {
        if (r == null) {
            return;
        }
        if (Build.VERSION.SDK_INT < 28) {
            r.setEmpty();
            return;
        }
        try {
            DisplayCutout cutout = this.mPopupWindow.getContext().getWindow().getDecorView().getRootWindowInsets().getDisplayCutout();
            if (cutout == null) {
                r.setEmpty();
                return;
            }
            r.set(cutout.getSafeInsetLeft(), cutout.getSafeInsetTop(), cutout.getSafeInsetRight(), cutout.getSafeInsetBottom());
        }
        catch (Exception e) {
            PopupLog.e(e);
        }
    }

    BasePopupHelper overlayStatusbar(boolean overlay) {
        if (!overlay && PopupUiUtils.isActivityFullScreen(this.mPopupWindow.getContext())) {
            Log.e((String)"BasePopupWindow", (String)"setOverlayStatusbar: \u5168\u5c4fActivity\u4e0b\u6ca1\u6709StatusBar\uff0c\u6b64\u5904\u4e0d\u80fd\u8bbe\u7f6e\u4e3afalse");
            overlay = true;
        }
        this.setFlag(8, overlay);
        if (!overlay) {
            this.lastOverLayStatusBarMode = this.overlayStatusBarMode;
            this.overlayStatusBarMode = 0;
        } else {
            this.overlayStatusBarMode = this.lastOverLayStatusBarMode;
        }
        return this;
    }

    BasePopupHelper setOverlayStatusbarMode(int mode) {
        this.lastOverLayStatusBarMode = !this.isOverlayStatusbar() ? mode : (this.overlayStatusBarMode = mode);
        return this;
    }

    BasePopupHelper overlayNavigationBar(boolean overlay) {
        this.setFlag(32, overlay);
        if (!overlay) {
            this.lastOverlayNavigationBarMode = this.overlayNavigationBarMode;
            this.overlayNavigationBarMode = 0;
        } else {
            this.overlayNavigationBarMode = this.lastOverlayNavigationBarMode;
        }
        return this;
    }

    BasePopupHelper setOverlayNavigationBarMode(int mode) {
        this.lastOverlayNavigationBarMode = !this.isOverlayNavigationBar() ? mode : (this.overlayNavigationBarMode = mode);
        return this;
    }

    PopupBlurOption getBlurOption() {
        return this.mBlurOption;
    }

    Drawable getPopupBackground() {
        return this.mBackgroundDrawable;
    }

    BasePopupHelper setPopupBackground(Drawable background) {
        this.mBackgroundDrawable = background;
        this.overlayMask = true;
        return this;
    }

    boolean isAlignBackground() {
        return (this.flag & 0x800) != 0;
    }

    BasePopupHelper setAlignBackgound(boolean mAlignBackground) {
        this.setFlag(2048, mAlignBackground);
        if (!mAlignBackground) {
            this.setAlignBackgroundGravity(0);
        }
        return this;
    }

    int getAlignBackgroundGravity() {
        if (this.isAlignBackground() && this.alignBackgroundGravity == 0) {
            this.alignBackgroundGravity = 48;
        }
        return this.alignBackgroundGravity;
    }

    BasePopupHelper setAlignBackgroundGravity(int gravity) {
        this.alignBackgroundGravity = gravity;
        return this;
    }

    BasePopupHelper setForceAdjustKeyboard(boolean adjust) {
        this.setFlag(0x100000, adjust);
        return this;
    }

    boolean isAllowToBlur() {
        return this.mBlurOption != null && this.mBlurOption.isAllowToBlur();
    }

    boolean isClipChildren() {
        return (this.flag & 0x10) != 0;
    }

    @NonNull
    ViewGroup.MarginLayoutParams getLayoutParams() {
        if (this.layoutParams == null) {
            int w = this.popupViewWidth == 0 ? -1 : this.popupViewWidth;
            int h = this.popupViewHeight == 0 ? -2 : this.popupViewHeight;
            this.layoutParams = new ViewGroup.MarginLayoutParams(w, h);
        }
        if (this.layoutParams.width > 0) {
            if (this.minWidth > 0) {
                this.layoutParams.width = Math.max(this.layoutParams.width, this.minWidth);
            }
            if (this.maxWidth > 0) {
                this.layoutParams.width = Math.min(this.layoutParams.width, this.maxWidth);
            }
        }
        if (this.layoutParams.height > 0) {
            if (this.minHeight > 0) {
                this.layoutParams.height = Math.max(this.layoutParams.height, this.minHeight);
            }
            if (this.maxHeight > 0) {
                this.layoutParams.height = Math.min(this.layoutParams.height, this.maxHeight);
            }
        }
        return this.layoutParams;
    }

    BasePopupHelper setContentRootId(View contentRoot) {
        if (contentRoot == null) {
            return this;
        }
        if (contentRoot.getId() == -1) {
            contentRoot.setId(CONTENT_VIEW_ID);
        }
        this.contentRootId = contentRoot.getId();
        return this;
    }

    int getSoftInputMode() {
        return this.mSoftInputMode;
    }

    View getBackgroundView() {
        return this.mBackgroundView;
    }

    BasePopupHelper setBackgroundView(View backgroundView) {
        this.mBackgroundView = backgroundView;
        this.overlayMask = true;
        return this;
    }

    int getMaxWidth() {
        return this.maxWidth;
    }

    int getMaxHeight() {
        return this.maxHeight;
    }

    ShowMode getShowMode() {
        return this.mShowMode;
    }

    BasePopupHelper setShowMode(ShowMode showMode) {
        this.mShowMode = showMode;
        return this;
    }

    int getMinWidth() {
        return this.minWidth;
    }

    int getMinHeight() {
        return this.minHeight;
    }

    public BasePopupHelper linkTo(View anchorView) {
        if (anchorView == null) {
            if (this.mLinkedViewLayoutChangeListenerWrapper != null) {
                this.mLinkedViewLayoutChangeListenerWrapper.detach();
                this.mLinkedViewLayoutChangeListenerWrapper = null;
            }
            this.mLinkedTarget = null;
            return this;
        }
        this.mLinkedTarget = anchorView;
        return this;
    }

    boolean isSyncMaskAnimationDuration() {
        return (this.flag & 0x1000000) != 0;
    }

    boolean isAlignAnchorWidth() {
        if (this.isWithAnchor()) {
            if (this.mShowInfo != null && this.mShowInfo.positionMode) {
                return false;
            }
            return (this.flag & 0x2000000) != 0;
        }
        return false;
    }

    boolean isAlignAnchorHeight() {
        if (this.isWithAnchor()) {
            if (this.mShowInfo != null && this.mShowInfo.positionMode) {
                return false;
            }
            return (this.flag & 0x4000000) != 0;
        }
        return false;
    }

    void prepare(View v, boolean positionMode) {
        if (this.mShowInfo == null) {
            this.mShowInfo = new InnerShowInfo(v, positionMode);
        } else {
            this.mShowInfo.mAnchorView = v;
            this.mShowInfo.positionMode = positionMode;
        }
        if (positionMode) {
            this.setShowMode(ShowMode.POSITION);
        } else {
            this.setShowMode(v == null ? ShowMode.SCREEN : ShowMode.RELATIVE_TO_ANCHOR);
        }
        this.getAnchorLocation(v);
        this.applyToPopupWindow();
    }

    private void applyToPopupWindow() {
        if (this.mPopupWindow == null || this.mPopupWindow.mPopupWindowProxy == null) {
            return;
        }
        this.mPopupWindow.mPopupWindowProxy.setSoftInputMode(this.mSoftInputMode);
        this.mPopupWindow.mPopupWindowProxy.setAnimationStyle(this.animationStyleRes);
        this.mPopupWindow.mPopupWindowProxy.setTouchable((this.flag & 0x8000000) != 0);
        this.mPopupWindow.mPopupWindowProxy.setFocusable((this.flag & 0x8000000) != 0);
    }

    void onDismiss() {
        if (this.isAutoShowInputMethod() && this.hideKeyboardOnDismiss) {
            KeyboardUtils.close(this.mPopupWindow.getContext());
        }
        if (this.mLinkedViewLayoutChangeListenerWrapper != null) {
            this.mLinkedViewLayoutChangeListenerWrapper.detach();
        }
    }

    void setFlag(int flag, boolean added) {
        if (!added) {
            this.flag &= ~flag;
        } else {
            this.flag |= flag;
            if (flag == 256) {
                this.flag |= 0x200;
            }
        }
    }

    boolean onDispatchKeyEvent(KeyEvent event) {
        if (this.mKeyEventListener != null && this.mKeyEventListener.onKey(event)) {
            return true;
        }
        return this.mPopupWindow.onDispatchKeyEvent(event);
    }

    boolean onInterceptTouchEvent(MotionEvent event) {
        return this.mPopupWindow.onInterceptTouchEvent(event);
    }

    boolean onTouchEvent(MotionEvent event) {
        return this.mPopupWindow.onTouchEvent(event);
    }

    boolean onBackPressed() {
        return this.mPopupWindow.onBackPressed();
    }

    void onShow() {
        this.prepareShow();
        if ((this.flag & 0x400000) != 0) {
            return;
        }
        if (this.mShowAnimation == null || this.mShowAnimator == null) {
            this.mPopupWindow.mDisplayAnimateView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    BasePopupHelper.this.mPopupWindow.mDisplayAnimateView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    BasePopupHelper.this.startShowAnimate(BasePopupHelper.this.mPopupWindow.mDisplayAnimateView.getWidth(), BasePopupHelper.this.mPopupWindow.mDisplayAnimateView.getHeight());
                }
            });
        } else {
            this.startShowAnimate(this.mPopupWindow.mDisplayAnimateView.getWidth(), this.mPopupWindow.mDisplayAnimateView.getHeight());
        }
    }

    void onAttachToWindow() {
        this.showFlag &= 0xFFFFFFFE;
        if (this.mPopupWindow != null) {
            this.mPopupWindow.onShowing();
        }
        if (this.mOnPopupWindowShowListener != null) {
            this.mOnPopupWindowShowListener.onShowing();
        }
    }

    void onPopupLayout(@NonNull Rect popupRect, @NonNull Rect anchorRect) {
        if (this.mPopupWindow != null) {
            this.mPopupWindow.onPopupLayout(popupRect, anchorRect);
        }
    }

    void onSizeChange(int oldW, int oldH, int newW, int newH) {
        if (this.mPopupWindow != null) {
            this.mPopupWindow.onSizeChange(oldW, oldH, newW, newH);
        }
    }

    private void prepareShow() {
        this.showFlag |= 1;
        if (this.mGlobalLayoutListener == null) {
            this.mGlobalLayoutListener = KeyboardUtils.observerKeyboardChange(this.mPopupWindow.getContext(), new KeyboardUtils.OnKeyboardChangeListener(){

                @Override
                public void onKeyboardChange(Rect keyboardBounds, boolean isVisible) {
                    BasePopupHelper.this.onKeyboardChange(keyboardBounds, isVisible);
                    if (!BasePopupHelper.this.mPopupWindow.isShowing()) {
                        PopupUiUtils.safeRemoveGlobalLayoutListener(BasePopupHelper.this.mPopupWindow.getContext().getWindow().getDecorView(), BasePopupHelper.this.mGlobalLayoutListener);
                        return;
                    }
                }
            });
        }
        PopupUiUtils.safeAddGlobalLayoutListener(this.mPopupWindow.getContext().getWindow().getDecorView(), this.mGlobalLayoutListener);
        if (this.mLinkedTarget != null) {
            if (this.mLinkedViewLayoutChangeListenerWrapper == null) {
                this.mLinkedViewLayoutChangeListenerWrapper = new LinkedViewLayoutChangeListenerWrapper(this.mLinkedTarget);
            }
            if (!this.mLinkedViewLayoutChangeListenerWrapper.isAdded) {
                this.mLinkedViewLayoutChangeListenerWrapper.attach();
            }
        }
    }

    void dismiss(boolean animateDismiss) {
        if (this.mPopupWindow == null || !this.mPopupWindow.onBeforeDismissInternal(this.mOnDismissListener)) {
            return;
        }
        if (this.mPopupWindow.mDisplayAnimateView == null || animateDismiss && (this.flag & 0x800000) != 0) {
            return;
        }
        this.showFlag &= 0xFFFFFFFE;
        this.showFlag |= 2;
        Message msg = BasePopupEvent.getMessage(2);
        if (animateDismiss) {
            this.startDismissAnimate(this.mPopupWindow.mDisplayAnimateView.getWidth(), this.mPopupWindow.mDisplayAnimateView.getHeight());
            msg.arg1 = 1;
            this.mPopupWindow.mDisplayAnimateView.removeCallbacks(this.dismissAnimationDelayRunnable);
            this.mPopupWindow.mDisplayAnimateView.postDelayed(this.dismissAnimationDelayRunnable, Math.max(this.dismissDuration, 0L));
        } else {
            msg.arg1 = 0;
            this.mPopupWindow.superDismiss();
        }
        BasePopupUnsafe.StackFetcher.remove(this.mPopupWindow);
        this.sendEvent(msg);
    }

    void forceDismiss() {
        if (this.mDismissAnimation != null) {
            this.mDismissAnimation.cancel();
        }
        if (this.mDismissAnimator != null) {
            this.mDismissAnimator.cancel();
        }
        if (this.mPopupWindow != null && this.hideKeyboardOnDismiss) {
            KeyboardUtils.close(this.mPopupWindow.getContext());
        }
        if (this.dismissAnimationDelayRunnable != null) {
            this.dismissAnimationDelayRunnable.run();
        }
    }

    @Override
    public void onKeyboardChange(Rect keyboardBounds, boolean isVisible) {
        if (this.mKeyboardStateChangeListener != null) {
            this.mKeyboardStateChangeListener.onKeyboardChange(keyboardBounds, isVisible);
        }
        if (this.mUserKeyboardStateChangeListener != null) {
            this.mUserKeyboardStateChangeListener.onKeyboardChange(keyboardBounds, isVisible);
        }
    }

    void update(View v, boolean positionMode) {
        if (!this.mPopupWindow.isShowing() || this.mPopupWindow.mContentView == null) {
            return;
        }
        if (v == null && this.mShowInfo != null) {
            v = this.mShowInfo.mAnchorView;
        }
        this.prepare(v, positionMode);
        this.mPopupWindow.mPopupWindowProxy.update();
    }

    void onConfigurationChanged(Configuration newConfig) {
        this.update(this.mShowInfo == null ? null : this.mShowInfo.mAnchorView, this.mShowInfo == null ? false : this.mShowInfo.positionMode);
    }

    void dispatchOutSideEvent(MotionEvent event, boolean touchInMask, boolean isMaskPressed) {
        if (this.mPopupWindow != null) {
            this.mPopupWindow.dispatchOutSideEvent(event, touchInMask, isMaskPressed);
        }
    }

    boolean hasBackground() {
        if (this.mBackgroundView != null) {
            return true;
        }
        if (this.mBackgroundDrawable instanceof ColorDrawable) {
            return ((ColorDrawable)this.mBackgroundDrawable).getColor() != 0 && this.mBackgroundDrawable.getAlpha() > 0;
        }
        return this.mBackgroundDrawable != null;
    }

    @Nullable
    static Activity findActivity(Object parent) {
        return BasePopupHelper.findActivity(parent, true);
    }

    @Nullable
    static Activity findActivity(Object parent, boolean returnTopIfNull) {
        Activity act = null;
        if (parent instanceof Context) {
            act = PopupUtils.getActivity((Context)parent);
        } else if (parent instanceof Fragment) {
            act = ((Fragment)parent).getActivity();
        } else if (parent instanceof Dialog) {
            act = PopupUtils.getActivity(((Dialog)parent).getContext());
        }
        if (act == null && returnTopIfNull) {
            act = BasePopupSDK.getInstance().getTopActivity();
        }
        return act;
    }

    @Nullable
    static View findDecorView(Object parent) {
        View decorView = null;
        Window window = null;
        if (parent instanceof Dialog) {
            window = ((Dialog)parent).getWindow();
        } else if (parent instanceof DialogFragment) {
            if (((DialogFragment)parent).getDialog() == null) {
                decorView = ((DialogFragment)parent).getView();
            } else {
                window = ((DialogFragment)parent).getDialog().getWindow();
            }
        } else if (parent instanceof Fragment) {
            decorView = ((Fragment)parent).getView();
        } else if (parent instanceof Context) {
            Activity act = PopupUtils.getActivity((Context)parent);
            View view = decorView = act == null ? null : act.findViewById(0x1020002);
        }
        if (decorView != null) {
            return decorView;
        }
        return window == null ? null : window.getDecorView();
    }

    boolean isPrePopupBackgroundExists() {
        if (this.mPopupWindow == null) {
            return false;
        }
        LinkedList<WindowManagerProxy> popupList = WindowManagerProxy.PopupWindowQueueManager.getInstance().getPopupList((Context)this.mPopupWindow.getContext());
        if (popupList == null || popupList.isEmpty()) {
            return false;
        }
        int size = popupList.size();
        if (size == 1) {
            WindowManagerProxy proxy = popupList.get(0);
            if (proxy.mPopupHelper != null && (proxy.mPopupHelper.showFlag & 2) != 0) {
                return false;
            }
        }
        for (WindowManagerProxy windowManagerProxy : popupList) {
            BasePopupHelper helper = windowManagerProxy.mPopupHelper;
            if (helper == null || !helper.hasBackground()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear(boolean destroy) {
        if (this.mPopupWindow != null && this.mPopupWindow.mDisplayAnimateView != null) {
            this.mPopupWindow.mDisplayAnimateView.removeCallbacks(this.dismissAnimationDelayRunnable);
        }
        if (this.eventObserverMap != null) {
            this.eventObserverMap.clear();
        }
        PopupUiUtils.releaseAnimation(this.mShowAnimation, this.mDismissAnimation, this.mShowAnimator, this.mDismissAnimator, this.mMaskViewShowAnimation, this.mMaskViewDismissAnimation);
        if (this.mBlurOption != null) {
            this.mBlurOption.clear();
        }
        if (this.mShowInfo != null) {
            this.mShowInfo.mAnchorView = null;
        }
        if (this.mGlobalLayoutListener != null) {
            PopupUiUtils.safeRemoveGlobalLayoutListener(this.mPopupWindow.getContext().getWindow().getDecorView(), this.mGlobalLayoutListener);
        }
        if (this.mLinkedViewLayoutChangeListenerWrapper != null) {
            this.mLinkedViewLayoutChangeListenerWrapper.detach();
        }
        this.showFlag = 0;
        this.dismissAnimationDelayRunnable = null;
        this.mShowAnimation = null;
        this.mDismissAnimation = null;
        this.mShowAnimator = null;
        this.mDismissAnimator = null;
        this.mMaskViewShowAnimation = null;
        this.mMaskViewDismissAnimation = null;
        this.eventObserverMap = null;
        this.mPopupWindow = null;
        this.mOnPopupWindowShowListener = null;
        this.mOnDismissListener = null;
        this.mOnBeforeShowCallback = null;
        this.mBlurOption = null;
        this.mBackgroundDrawable = null;
        this.mBackgroundView = null;
        this.mAutoShowInputEdittext = null;
        this.mKeyboardStateChangeListener = null;
        this.mShowInfo = null;
        this.mLinkedViewLayoutChangeListenerWrapper = null;
        this.mLinkedTarget = null;
        this.mGlobalLayoutListener = null;
        this.mUserKeyboardStateChangeListener = null;
        this.mKeyEventListener = null;
        this.keybaordAlignView = null;
        this.mOnFitWindowManagerLayoutParamsCallback = null;
    }

    class LinkedViewLayoutChangeListenerWrapper
    implements ViewTreeObserver.OnPreDrawListener {
        private View mTarget;
        private boolean isAdded;
        private float lastX;
        private float lastY;
        private int lastWidth;
        private int lastHeight;
        private int lastVisible;
        private boolean lastShowState;
        private boolean hasChange;
        Rect lastLocationRect = new Rect();
        Rect newLocationRect = new Rect();

        public LinkedViewLayoutChangeListenerWrapper(View target) {
            this.mTarget = target;
        }

        void attach() {
            if (this.mTarget == null || this.isAdded) {
                return;
            }
            this.mTarget.getGlobalVisibleRect(this.lastLocationRect);
            this.refreshViewParams();
            this.mTarget.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
            this.isAdded = true;
        }

        void detach() {
            if (this.mTarget == null || !this.isAdded) {
                return;
            }
            try {
                this.mTarget.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.isAdded = false;
        }

        void refreshViewParams() {
            if (this.mTarget == null) {
                return;
            }
            float curX = this.mTarget.getX();
            float curY = this.mTarget.getY();
            int curWidth = this.mTarget.getWidth();
            int curHeight = this.mTarget.getHeight();
            int curVisible = this.mTarget.getVisibility();
            boolean isShow = this.mTarget.isShown();
            boolean bl = this.hasChange = (curX != this.lastX || curY != this.lastY || curWidth != this.lastWidth || curHeight != this.lastHeight || curVisible != this.lastVisible) && this.isAdded;
            if (!this.hasChange) {
                this.mTarget.getGlobalVisibleRect(this.newLocationRect);
                if (!this.newLocationRect.equals((Object)this.lastLocationRect)) {
                    this.lastLocationRect.set(this.newLocationRect);
                    if (!this.handleShowChange(this.mTarget, this.lastShowState, isShow)) {
                        this.hasChange = true;
                    }
                }
            }
            this.lastX = curX;
            this.lastY = curY;
            this.lastWidth = curWidth;
            this.lastHeight = curHeight;
            this.lastVisible = curVisible;
            this.lastShowState = isShow;
        }

        private boolean handleShowChange(View target, boolean lastShowState, boolean isShow) {
            if (lastShowState && !isShow) {
                if (BasePopupHelper.this.mPopupWindow.isShowing()) {
                    BasePopupHelper.this.dismiss(false);
                    return true;
                }
            } else if (!lastShowState && isShow && !BasePopupHelper.this.mPopupWindow.isShowing()) {
                BasePopupHelper.this.mPopupWindow.tryToShowPopup(target, false);
                return true;
            }
            return false;
        }

        public boolean onPreDraw() {
            if (this.mTarget == null) {
                return true;
            }
            this.refreshViewParams();
            if (this.hasChange) {
                BasePopupHelper.this.update(this.mTarget, false);
            }
            return true;
        }
    }

    static class InnerShowInfo {
        View mAnchorView;
        boolean positionMode;

        InnerShowInfo(View mAnchorView, boolean positionMode) {
            this.mAnchorView = mAnchorView;
            this.positionMode = positionMode;
        }
    }

    static enum ShowMode {
        RELATIVE_TO_ANCHOR,
        SCREEN,
        POSITION;

    }
}

