/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib.helpers;

import cz.adamh.utils.NativeUtils;
import java.io.IOException;
import java.util.Comparator;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuantLibJNIHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuantLibJNIHelpers.class);
    private static final String OS_NAME = System.getProperty("os.name");
    private static final String OS_ARCH = System.getProperty("os.arch");
    private static final String OS_VERSION = System.getProperty("os.version");
    private static final String OS = OS_NAME + " (arch: " + OS_ARCH + ", version: " + OS_VERSION + ")";
    private static boolean libraryIsLoaded = false;
    private static final OperatingSystem OS_SYSTEM = QuantLibJNIHelpers.getOS();
    private static final String ARCH = System.getProperty("os.arch").toLowerCase();

    public static void loadLibrary() {
        try {
            if (libraryIsLoaded) {
                LOGGER.warn("QuantLib native library for {} was already loaded, skipping reloading", (Object)OS);
                return;
            }
            LOGGER.debug("Trying to load QuantLib native library for {}", (Object)OS);
            QuantLibJNIHelpers.traceLogAllSystemProperties();
            String libraryPath = QuantLibJNIHelpers.getLibraryPath();
            NativeUtils.loadLibraryFromJar(libraryPath);
            libraryIsLoaded = true;
            LOGGER.debug("Native library loaded");
        }
        catch (IOException e) {
            throw new UnsupportedOperatingSystemException(e);
        }
    }

    private QuantLibJNIHelpers() {
    }

    private static OperatingSystem getOS() {
        String os = OS_NAME.toLowerCase();
        if (os.startsWith("linux")) {
            return OperatingSystem.Linux;
        }
        if (os.startsWith("mac")) {
            return OperatingSystem.MacOs;
        }
        if (os.startsWith("win")) {
            return OperatingSystem.Windows;
        }
        throw new UnsupportedOperatingSystemException();
    }

    private static String getLibraryName() {
        switch (OS_SYSTEM) {
            case Linux: {
                return "libQuantLibJNI.so";
            }
            case MacOs: {
                return "libQuantLibJNI.jnilib";
            }
            case Windows: {
                return "QuantLibJNI.dll";
            }
        }
        throw new UnsupportedOperatingSystemException();
    }

    private static String getLibraryPath() {
        String rootPath = "/native";
        String path = String.join((CharSequence)"/", rootPath, OS_SYSTEM.name().toLowerCase());
        switch (OS_SYSTEM) {
            case Linux: 
            case MacOs: {
                return String.join((CharSequence)"/", path, QuantLibJNIHelpers.getLibraryName());
            }
            case Windows: {
                return String.join((CharSequence)"/", path, ARCH, QuantLibJNIHelpers.getLibraryName());
            }
        }
        throw new UnsupportedOperatingSystemException();
    }

    private static void traceLogAllSystemProperties() {
        if (!LOGGER.isTraceEnabled()) {
            return;
        }
        LOGGER.trace("System properties:");
        Properties properties = System.getProperties();
        properties.entrySet().stream().sorted(Comparator.comparing(entry -> entry.getKey().toString())).forEach(entry -> LOGGER.trace("\t{}: {}", entry.getKey(), entry.getValue()));
    }

    private static enum OperatingSystem {
        Linux,
        MacOs,
        Windows;

    }

    public static class UnsupportedOperatingSystemException
    extends RuntimeException {
        private static final String MESSAGE = "The operating system '" + OS + "' is not supported.";

        private UnsupportedOperatingSystemException() {
            super(MESSAGE);
        }

        private UnsupportedOperatingSystemException(Exception exception) {
            super(MESSAGE, exception);
        }

        public String getUnsupportedOperatingSystem() {
            return OS;
        }
    }

    public static interface AutoCloseable
    extends java.lang.AutoCloseable {
        public void delete();

        @Override
        default public void close() {
            this.delete();
        }
    }
}

