/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import org.quantlib.BusinessDayConvention;
import org.quantlib.Calendar;
import org.quantlib.Currency;
import org.quantlib.DayCounter;
import org.quantlib.IborIndex;
import org.quantlib.InterestRateIndex;
import org.quantlib.Period;
import org.quantlib.QuantLibJNI;
import org.quantlib.YieldTermStructureHandle;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class SwapIndex
extends InterestRateIndex
implements QuantLibJNIHelpers.AutoCloseable {
    private transient long swigCPtr;
    private transient boolean swigCMemOwnDerived;

    protected SwapIndex(long cPtr, boolean cMemoryOwn) {
        super(QuantLibJNI.SwapIndex_SWIGSmartPtrUpcast(cPtr), true);
        this.swigCMemOwnDerived = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(SwapIndex obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void swigSetCMemOwn(boolean own) {
        this.swigCMemOwnDerived = own;
        super.swigSetCMemOwn(own);
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwnDerived) {
                this.swigCMemOwnDerived = false;
                QuantLibJNI.delete_SwapIndex(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public SwapIndex(String familyName, Period tenor, int settlementDays, Currency currency, Calendar calendar, Period fixedLegTenor, BusinessDayConvention fixedLegConvention, DayCounter fixedLegDayCounter, IborIndex iborIndex) {
        this(QuantLibJNI.new_SwapIndex__SWIG_0(familyName, Period.getCPtr(tenor), tenor, settlementDays, Currency.getCPtr(currency), currency, Calendar.getCPtr(calendar), calendar, Period.getCPtr(fixedLegTenor), fixedLegTenor, fixedLegConvention.swigValue(), DayCounter.getCPtr(fixedLegDayCounter), fixedLegDayCounter, IborIndex.getCPtr(iborIndex), iborIndex), true);
    }

    public SwapIndex(String familyName, Period tenor, int settlementDays, Currency currency, Calendar calendar, Period fixedLegTenor, BusinessDayConvention fixedLegConvention, DayCounter fixedLegDayCounter, IborIndex iborIndex, YieldTermStructureHandle discountCurve) {
        this(QuantLibJNI.new_SwapIndex__SWIG_1(familyName, Period.getCPtr(tenor), tenor, settlementDays, Currency.getCPtr(currency), currency, Calendar.getCPtr(calendar), calendar, Period.getCPtr(fixedLegTenor), fixedLegTenor, fixedLegConvention.swigValue(), DayCounter.getCPtr(fixedLegDayCounter), fixedLegDayCounter, IborIndex.getCPtr(iborIndex), iborIndex, YieldTermStructureHandle.getCPtr(discountCurve), discountCurve), true);
    }

    public Period fixedLegTenor() {
        return new Period(QuantLibJNI.SwapIndex_fixedLegTenor(this.swigCPtr, this), true);
    }

    public BusinessDayConvention fixedLegConvention() {
        return BusinessDayConvention.swigToEnum(QuantLibJNI.SwapIndex_fixedLegConvention(this.swigCPtr, this));
    }

    public IborIndex iborIndex() {
        long cPtr = QuantLibJNI.SwapIndex_iborIndex(this.swigCPtr, this);
        return cPtr == 0L ? null : new IborIndex(cPtr, true);
    }

    public YieldTermStructureHandle forwardingTermStructure() {
        return new YieldTermStructureHandle(QuantLibJNI.SwapIndex_forwardingTermStructure(this.swigCPtr, this), true);
    }

    public YieldTermStructureHandle discountingTermStructure() {
        return new YieldTermStructureHandle(QuantLibJNI.SwapIndex_discountingTermStructure(this.swigCPtr, this), true);
    }

    public SwapIndex clone(YieldTermStructureHandle h) {
        long cPtr = QuantLibJNI.SwapIndex_clone__SWIG_0(this.swigCPtr, this, YieldTermStructureHandle.getCPtr(h), h);
        return cPtr == 0L ? null : new SwapIndex(cPtr, true);
    }

    public SwapIndex clone(YieldTermStructureHandle forwarding, YieldTermStructureHandle discounting) {
        long cPtr = QuantLibJNI.SwapIndex_clone__SWIG_1(this.swigCPtr, this, YieldTermStructureHandle.getCPtr(forwarding), forwarding, YieldTermStructureHandle.getCPtr(discounting), discounting);
        return cPtr == 0L ? null : new SwapIndex(cPtr, true);
    }

    public SwapIndex clone(Period tenor) {
        long cPtr = QuantLibJNI.SwapIndex_clone__SWIG_2(this.swigCPtr, this, Period.getCPtr(tenor), tenor);
        return cPtr == 0L ? null : new SwapIndex(cPtr, true);
    }
}

