/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.quantlib.QuantLibJNI;
import org.quantlib.Quote;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class QuoteVector
extends AbstractList<Quote>
implements QuantLibJNIHelpers.AutoCloseable,
RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected QuoteVector(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(QuoteVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(QuoteVector obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_QuoteVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public QuoteVector(Quote[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (Quote element : initialElements) {
            this.add(element);
        }
    }

    public QuoteVector(Iterable<Quote> initialElements) {
        this();
        for (Quote element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public Quote get(int index) {
        return this.doGet(index);
    }

    @Override
    public Quote set(int index, Quote e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(Quote e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, Quote e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public Quote remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public QuoteVector() {
        this(QuantLibJNI.new_QuoteVector__SWIG_0(), true);
    }

    public QuoteVector(QuoteVector other) {
        this(QuantLibJNI.new_QuoteVector__SWIG_1(QuoteVector.getCPtr(other), other), true);
    }

    public long capacity() {
        return QuantLibJNI.QuoteVector_capacity(this.swigCPtr, this);
    }

    public void reserve(long n) {
        QuantLibJNI.QuoteVector_reserve(this.swigCPtr, this, n);
    }

    @Override
    public boolean isEmpty() {
        return QuantLibJNI.QuoteVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        QuantLibJNI.QuoteVector_clear(this.swigCPtr, this);
    }

    public QuoteVector(int count, Quote value) {
        this(QuantLibJNI.new_QuoteVector__SWIG_2(count, Quote.getCPtr(value), value), true);
    }

    private int doSize() {
        return QuantLibJNI.QuoteVector_doSize(this.swigCPtr, this);
    }

    private void doAdd(Quote x) {
        QuantLibJNI.QuoteVector_doAdd__SWIG_0(this.swigCPtr, this, Quote.getCPtr(x), x);
    }

    private void doAdd(int index, Quote x) {
        QuantLibJNI.QuoteVector_doAdd__SWIG_1(this.swigCPtr, this, index, Quote.getCPtr(x), x);
    }

    private Quote doRemove(int index) {
        long cPtr = QuantLibJNI.QuoteVector_doRemove(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new Quote(cPtr, true);
    }

    private Quote doGet(int index) {
        long cPtr = QuantLibJNI.QuoteVector_doGet(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new Quote(cPtr, true);
    }

    private Quote doSet(int index, Quote val) {
        long cPtr = QuantLibJNI.QuoteVector_doSet(this.swigCPtr, this, index, Quote.getCPtr(val), val);
        return cPtr == 0L ? null : new Quote(cPtr, true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        QuantLibJNI.QuoteVector_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

