/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.quantlib.IntervalPrice;
import org.quantlib.QuantLibJNI;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class IntervalPriceVector
extends AbstractList<IntervalPrice>
implements QuantLibJNIHelpers.AutoCloseable,
RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected IntervalPriceVector(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(IntervalPriceVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(IntervalPriceVector obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_IntervalPriceVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public IntervalPriceVector(IntervalPrice[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (IntervalPrice element : initialElements) {
            this.add(element);
        }
    }

    public IntervalPriceVector(Iterable<IntervalPrice> initialElements) {
        this();
        for (IntervalPrice element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public IntervalPrice get(int index) {
        return this.doGet(index);
    }

    @Override
    public IntervalPrice set(int index, IntervalPrice e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(IntervalPrice e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, IntervalPrice e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public IntervalPrice remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public IntervalPriceVector() {
        this(QuantLibJNI.new_IntervalPriceVector__SWIG_0(), true);
    }

    public IntervalPriceVector(IntervalPriceVector other) {
        this(QuantLibJNI.new_IntervalPriceVector__SWIG_1(IntervalPriceVector.getCPtr(other), other), true);
    }

    public long capacity() {
        return QuantLibJNI.IntervalPriceVector_capacity(this.swigCPtr, this);
    }

    public void reserve(long n) {
        QuantLibJNI.IntervalPriceVector_reserve(this.swigCPtr, this, n);
    }

    @Override
    public boolean isEmpty() {
        return QuantLibJNI.IntervalPriceVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        QuantLibJNI.IntervalPriceVector_clear(this.swigCPtr, this);
    }

    public IntervalPriceVector(int count, IntervalPrice value) {
        this(QuantLibJNI.new_IntervalPriceVector__SWIG_2(count, IntervalPrice.getCPtr(value), value), true);
    }

    private int doSize() {
        return QuantLibJNI.IntervalPriceVector_doSize(this.swigCPtr, this);
    }

    private void doAdd(IntervalPrice x) {
        QuantLibJNI.IntervalPriceVector_doAdd__SWIG_0(this.swigCPtr, this, IntervalPrice.getCPtr(x), x);
    }

    private void doAdd(int index, IntervalPrice x) {
        QuantLibJNI.IntervalPriceVector_doAdd__SWIG_1(this.swigCPtr, this, index, IntervalPrice.getCPtr(x), x);
    }

    private IntervalPrice doRemove(int index) {
        return new IntervalPrice(QuantLibJNI.IntervalPriceVector_doRemove(this.swigCPtr, this, index), true);
    }

    private IntervalPrice doGet(int index) {
        return new IntervalPrice(QuantLibJNI.IntervalPriceVector_doGet(this.swigCPtr, this, index), false);
    }

    private IntervalPrice doSet(int index, IntervalPrice val) {
        return new IntervalPrice(QuantLibJNI.IntervalPriceVector_doSet(this.swigCPtr, this, index, IntervalPrice.getCPtr(val), val), true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        QuantLibJNI.IntervalPriceVector_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

