/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.quantlib.Instrument;
import org.quantlib.QuantLibJNI;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class InstrumentVector
extends AbstractList<Instrument>
implements QuantLibJNIHelpers.AutoCloseable,
RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected InstrumentVector(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(InstrumentVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(InstrumentVector obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_InstrumentVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public InstrumentVector(Instrument[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (Instrument element : initialElements) {
            this.add(element);
        }
    }

    public InstrumentVector(Iterable<Instrument> initialElements) {
        this();
        for (Instrument element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public Instrument get(int index) {
        return this.doGet(index);
    }

    @Override
    public Instrument set(int index, Instrument e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(Instrument e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, Instrument e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public Instrument remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public InstrumentVector() {
        this(QuantLibJNI.new_InstrumentVector__SWIG_0(), true);
    }

    public InstrumentVector(InstrumentVector other) {
        this(QuantLibJNI.new_InstrumentVector__SWIG_1(InstrumentVector.getCPtr(other), other), true);
    }

    public long capacity() {
        return QuantLibJNI.InstrumentVector_capacity(this.swigCPtr, this);
    }

    public void reserve(long n) {
        QuantLibJNI.InstrumentVector_reserve(this.swigCPtr, this, n);
    }

    @Override
    public boolean isEmpty() {
        return QuantLibJNI.InstrumentVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        QuantLibJNI.InstrumentVector_clear(this.swigCPtr, this);
    }

    public InstrumentVector(int count, Instrument value) {
        this(QuantLibJNI.new_InstrumentVector__SWIG_2(count, Instrument.getCPtr(value), value), true);
    }

    private int doSize() {
        return QuantLibJNI.InstrumentVector_doSize(this.swigCPtr, this);
    }

    private void doAdd(Instrument x) {
        QuantLibJNI.InstrumentVector_doAdd__SWIG_0(this.swigCPtr, this, Instrument.getCPtr(x), x);
    }

    private void doAdd(int index, Instrument x) {
        QuantLibJNI.InstrumentVector_doAdd__SWIG_1(this.swigCPtr, this, index, Instrument.getCPtr(x), x);
    }

    private Instrument doRemove(int index) {
        long cPtr = QuantLibJNI.InstrumentVector_doRemove(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new Instrument(cPtr, true);
    }

    private Instrument doGet(int index) {
        long cPtr = QuantLibJNI.InstrumentVector_doGet(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new Instrument(cPtr, true);
    }

    private Instrument doSet(int index, Instrument val) {
        long cPtr = QuantLibJNI.InstrumentVector_doSet(this.swigCPtr, this, index, Instrument.getCPtr(val), val);
        return cPtr == 0L ? null : new Instrument(cPtr, true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        QuantLibJNI.InstrumentVector_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

