/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import org.quantlib.Coupon;
import org.quantlib.Date;
import org.quantlib.FloatingRateCouponPricer;
import org.quantlib.InterestRateIndex;
import org.quantlib.QuantLibJNI;
import org.quantlib.YieldTermStructureHandle;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class FloatingRateCoupon
extends Coupon
implements QuantLibJNIHelpers.AutoCloseable {
    private transient long swigCPtr;
    private transient boolean swigCMemOwnDerived;

    protected FloatingRateCoupon(long cPtr, boolean cMemoryOwn) {
        super(QuantLibJNI.FloatingRateCoupon_SWIGSmartPtrUpcast(cPtr), true);
        this.swigCMemOwnDerived = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(FloatingRateCoupon obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void swigSetCMemOwn(boolean own) {
        this.swigCMemOwnDerived = own;
        super.swigSetCMemOwn(own);
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwnDerived) {
                this.swigCMemOwnDerived = false;
                QuantLibJNI.delete_FloatingRateCoupon(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public Date fixingDate() {
        return new Date(QuantLibJNI.FloatingRateCoupon_fixingDate(this.swigCPtr, this), true);
    }

    public int fixingDays() {
        return QuantLibJNI.FloatingRateCoupon_fixingDays(this.swigCPtr, this);
    }

    public boolean isInArrears() {
        return QuantLibJNI.FloatingRateCoupon_isInArrears(this.swigCPtr, this);
    }

    public double gearing() {
        return QuantLibJNI.FloatingRateCoupon_gearing(this.swigCPtr, this);
    }

    public double spread() {
        return QuantLibJNI.FloatingRateCoupon_spread(this.swigCPtr, this);
    }

    public double indexFixing() {
        return QuantLibJNI.FloatingRateCoupon_indexFixing(this.swigCPtr, this);
    }

    public double adjustedFixing() {
        return QuantLibJNI.FloatingRateCoupon_adjustedFixing(this.swigCPtr, this);
    }

    public double convexityAdjustment() {
        return QuantLibJNI.FloatingRateCoupon_convexityAdjustment(this.swigCPtr, this);
    }

    public double price(YieldTermStructureHandle discountCurve) {
        return QuantLibJNI.FloatingRateCoupon_price(this.swigCPtr, this, YieldTermStructureHandle.getCPtr(discountCurve), discountCurve);
    }

    public InterestRateIndex index() {
        long cPtr = QuantLibJNI.FloatingRateCoupon_index(this.swigCPtr, this);
        return cPtr == 0L ? null : new InterestRateIndex(cPtr, true);
    }

    public void setPricer(FloatingRateCouponPricer p) {
        QuantLibJNI.FloatingRateCoupon_setPricer(this.swigCPtr, this, FloatingRateCouponPricer.getCPtr(p), p);
    }
}

