/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import org.quantlib.Currency;
import org.quantlib.Date;
import org.quantlib.ExchangeRate;
import org.quantlib.QuantLibJNI;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class ExchangeRateManager
implements QuantLibJNIHelpers.AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected ExchangeRateManager(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(ExchangeRateManager obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(ExchangeRateManager obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_ExchangeRateManager(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static ExchangeRateManager instance() {
        return new ExchangeRateManager(QuantLibJNI.ExchangeRateManager_instance(), false);
    }

    public void add(ExchangeRate arg0, Date startDate, Date endDate) {
        QuantLibJNI.ExchangeRateManager_add__SWIG_0(this.swigCPtr, this, ExchangeRate.getCPtr(arg0), arg0, Date.getCPtr(startDate), startDate, Date.getCPtr(endDate), endDate);
    }

    public void add(ExchangeRate arg0, Date startDate) {
        QuantLibJNI.ExchangeRateManager_add__SWIG_1(this.swigCPtr, this, ExchangeRate.getCPtr(arg0), arg0, Date.getCPtr(startDate), startDate);
    }

    public void add(ExchangeRate arg0) {
        QuantLibJNI.ExchangeRateManager_add__SWIG_2(this.swigCPtr, this, ExchangeRate.getCPtr(arg0), arg0);
    }

    public ExchangeRate lookup(Currency source, Currency target, Date date, ExchangeRate.Type type) {
        return new ExchangeRate(QuantLibJNI.ExchangeRateManager_lookup__SWIG_0(this.swigCPtr, this, Currency.getCPtr(source), source, Currency.getCPtr(target), target, Date.getCPtr(date), date, type.swigValue()), true);
    }

    public ExchangeRate lookup(Currency source, Currency target, Date date) {
        return new ExchangeRate(QuantLibJNI.ExchangeRateManager_lookup__SWIG_1(this.swigCPtr, this, Currency.getCPtr(source), source, Currency.getCPtr(target), target, Date.getCPtr(date), date), true);
    }

    public void clear() {
        QuantLibJNI.ExchangeRateManager_clear(this.swigCPtr, this);
    }
}

