/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import org.quantlib.Currency;
import org.quantlib.Money;
import org.quantlib.QuantLibJNI;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class ExchangeRate
implements QuantLibJNIHelpers.AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected ExchangeRate(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(ExchangeRate obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(ExchangeRate obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_ExchangeRate(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public ExchangeRate(Currency source, Currency target, double rate) {
        this(QuantLibJNI.new_ExchangeRate(Currency.getCPtr(source), source, Currency.getCPtr(target), target, rate), true);
    }

    public Currency source() {
        return new Currency(QuantLibJNI.ExchangeRate_source(this.swigCPtr, this), false);
    }

    public Currency target() {
        return new Currency(QuantLibJNI.ExchangeRate_target(this.swigCPtr, this), false);
    }

    public Type type() {
        return Type.swigToEnum(QuantLibJNI.ExchangeRate_type(this.swigCPtr, this));
    }

    public double rate() {
        return QuantLibJNI.ExchangeRate_rate(this.swigCPtr, this);
    }

    public Money exchange(Money amount) {
        return new Money(QuantLibJNI.ExchangeRate_exchange(this.swigCPtr, this, Money.getCPtr(amount), amount), true);
    }

    public static ExchangeRate chain(ExchangeRate r1, ExchangeRate r2) {
        return new ExchangeRate(QuantLibJNI.ExchangeRate_chain(ExchangeRate.getCPtr(r1), r1, ExchangeRate.getCPtr(r2), r2), true);
    }

    public static final class Type {
        public static final Type Direct = new Type("Direct");
        public static final Type Derived = new Type("Derived");
        private static Type[] swigValues = new Type[]{Direct, Derived};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static Type swigToEnum(int swigValue) {
            if (swigValue < swigValues.length && swigValue >= 0 && Type.swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (Type.swigValues[i].swigValue != swigValue) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + Type.class + " with value " + swigValue);
        }

        private Type(String swigName) {
            this.swigName = swigName;
            this.swigValue = swigNext++;
        }

        private Type(String swigName, int swigValue) {
            this.swigName = swigName;
            this.swigValue = swigValue;
            swigNext = swigValue + 1;
        }

        private Type(String swigName, Type swigEnum) {
            this.swigName = swigName;
            this.swigValue = swigEnum.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

