/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import org.quantlib.QuantLibJNI;
import org.quantlib.Quote;
import org.quantlib.QuoteHandle;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class DeltaVolQuote
extends Quote
implements QuantLibJNIHelpers.AutoCloseable {
    private transient long swigCPtr;
    private transient boolean swigCMemOwnDerived;

    protected DeltaVolQuote(long cPtr, boolean cMemoryOwn) {
        super(QuantLibJNI.DeltaVolQuote_SWIGSmartPtrUpcast(cPtr), true);
        this.swigCMemOwnDerived = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(DeltaVolQuote obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void swigSetCMemOwn(boolean own) {
        this.swigCMemOwnDerived = own;
        super.swigSetCMemOwn(own);
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwnDerived) {
                this.swigCMemOwnDerived = false;
                QuantLibJNI.delete_DeltaVolQuote(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public DeltaVolQuote(double delta, QuoteHandle vol, double maturity, DeltaType deltaType) {
        this(QuantLibJNI.new_DeltaVolQuote__SWIG_0(delta, QuoteHandle.getCPtr(vol), vol, maturity, deltaType.swigValue()), true);
    }

    public DeltaVolQuote(QuoteHandle vol, DeltaType deltaType, double maturity, AtmType atmType) {
        this(QuantLibJNI.new_DeltaVolQuote__SWIG_1(QuoteHandle.getCPtr(vol), vol, deltaType.swigValue(), maturity, atmType.swigValue()), true);
    }

    public double delta() {
        return QuantLibJNI.DeltaVolQuote_delta(this.swigCPtr, this);
    }

    public double maturity() {
        return QuantLibJNI.DeltaVolQuote_maturity(this.swigCPtr, this);
    }

    public AtmType atmType() {
        return AtmType.swigToEnum(QuantLibJNI.DeltaVolQuote_atmType(this.swigCPtr, this));
    }

    public DeltaType deltaType() {
        return DeltaType.swigToEnum(QuantLibJNI.DeltaVolQuote_deltaType(this.swigCPtr, this));
    }

    public static final class AtmType {
        public static final AtmType AtmNull = new AtmType("AtmNull");
        public static final AtmType AtmSpot = new AtmType("AtmSpot");
        public static final AtmType AtmFwd = new AtmType("AtmFwd");
        public static final AtmType AtmDeltaNeutral = new AtmType("AtmDeltaNeutral");
        public static final AtmType AtmVegaMax = new AtmType("AtmVegaMax");
        public static final AtmType AtmGammaMax = new AtmType("AtmGammaMax");
        public static final AtmType AtmPutCall50 = new AtmType("AtmPutCall50");
        private static AtmType[] swigValues = new AtmType[]{AtmNull, AtmSpot, AtmFwd, AtmDeltaNeutral, AtmVegaMax, AtmGammaMax, AtmPutCall50};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static AtmType swigToEnum(int swigValue) {
            if (swigValue < swigValues.length && swigValue >= 0 && AtmType.swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (AtmType.swigValues[i].swigValue != swigValue) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + AtmType.class + " with value " + swigValue);
        }

        private AtmType(String swigName) {
            this.swigName = swigName;
            this.swigValue = swigNext++;
        }

        private AtmType(String swigName, int swigValue) {
            this.swigName = swigName;
            this.swigValue = swigValue;
            swigNext = swigValue + 1;
        }

        private AtmType(String swigName, AtmType swigEnum) {
            this.swigName = swigName;
            this.swigValue = swigEnum.swigValue;
            swigNext = this.swigValue + 1;
        }
    }

    public static final class DeltaType {
        public static final DeltaType Spot = new DeltaType("Spot");
        public static final DeltaType Fwd = new DeltaType("Fwd");
        public static final DeltaType PaSpot = new DeltaType("PaSpot");
        public static final DeltaType PaFwd = new DeltaType("PaFwd");
        private static DeltaType[] swigValues = new DeltaType[]{Spot, Fwd, PaSpot, PaFwd};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static DeltaType swigToEnum(int swigValue) {
            if (swigValue < swigValues.length && swigValue >= 0 && DeltaType.swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (DeltaType.swigValues[i].swigValue != swigValue) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + DeltaType.class + " with value " + swigValue);
        }

        private DeltaType(String swigName) {
            this.swigName = swigName;
            this.swigValue = swigNext++;
        }

        private DeltaType(String swigName, int swigValue) {
            this.swigName = swigName;
            this.swigValue = swigValue;
            swigNext = swigValue + 1;
        }

        private DeltaType(String swigName, DeltaType swigEnum) {
            this.swigName = swigName;
            this.swigValue = swigEnum.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

