/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.quantlib.Date;
import org.quantlib.QuantLibJNI;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class DateVector
extends AbstractList<Date>
implements QuantLibJNIHelpers.AutoCloseable,
RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected DateVector(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(DateVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(DateVector obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_DateVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public DateVector(Date[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (Date element : initialElements) {
            this.add(element);
        }
    }

    public DateVector(Iterable<Date> initialElements) {
        this();
        for (Date element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public Date get(int index) {
        return this.doGet(index);
    }

    @Override
    public Date set(int index, Date e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(Date e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, Date e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public Date remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public DateVector() {
        this(QuantLibJNI.new_DateVector__SWIG_0(), true);
    }

    public DateVector(DateVector other) {
        this(QuantLibJNI.new_DateVector__SWIG_1(DateVector.getCPtr(other), other), true);
    }

    public long capacity() {
        return QuantLibJNI.DateVector_capacity(this.swigCPtr, this);
    }

    public void reserve(long n) {
        QuantLibJNI.DateVector_reserve(this.swigCPtr, this, n);
    }

    @Override
    public boolean isEmpty() {
        return QuantLibJNI.DateVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        QuantLibJNI.DateVector_clear(this.swigCPtr, this);
    }

    public DateVector(int count, Date value) {
        this(QuantLibJNI.new_DateVector__SWIG_2(count, Date.getCPtr(value), value), true);
    }

    private int doSize() {
        return QuantLibJNI.DateVector_doSize(this.swigCPtr, this);
    }

    private void doAdd(Date x) {
        QuantLibJNI.DateVector_doAdd__SWIG_0(this.swigCPtr, this, Date.getCPtr(x), x);
    }

    private void doAdd(int index, Date x) {
        QuantLibJNI.DateVector_doAdd__SWIG_1(this.swigCPtr, this, index, Date.getCPtr(x), x);
    }

    private Date doRemove(int index) {
        return new Date(QuantLibJNI.DateVector_doRemove(this.swigCPtr, this, index), true);
    }

    private Date doGet(int index) {
        return new Date(QuantLibJNI.DateVector_doGet(this.swigCPtr, this, index), false);
    }

    private Date doSet(int index, Date val) {
        return new Date(QuantLibJNI.DateVector_doSet(this.swigCPtr, this, index, Date.getCPtr(val), val), true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        QuantLibJNI.DateVector_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

