/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.quantlib.CalibrationPair;
import org.quantlib.QuantLibJNI;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class CalibrationSet
extends AbstractList<CalibrationPair>
implements QuantLibJNIHelpers.AutoCloseable,
RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected CalibrationSet(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(CalibrationSet obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(CalibrationSet obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_CalibrationSet(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public CalibrationSet(CalibrationPair[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (CalibrationPair element : initialElements) {
            this.add(element);
        }
    }

    public CalibrationSet(Iterable<CalibrationPair> initialElements) {
        this();
        for (CalibrationPair element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public CalibrationPair get(int index) {
        return this.doGet(index);
    }

    @Override
    public CalibrationPair set(int index, CalibrationPair e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(CalibrationPair e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, CalibrationPair e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public CalibrationPair remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public CalibrationSet() {
        this(QuantLibJNI.new_CalibrationSet__SWIG_0(), true);
    }

    public CalibrationSet(CalibrationSet other) {
        this(QuantLibJNI.new_CalibrationSet__SWIG_1(CalibrationSet.getCPtr(other), other), true);
    }

    public long capacity() {
        return QuantLibJNI.CalibrationSet_capacity(this.swigCPtr, this);
    }

    public void reserve(long n) {
        QuantLibJNI.CalibrationSet_reserve(this.swigCPtr, this, n);
    }

    @Override
    public boolean isEmpty() {
        return QuantLibJNI.CalibrationSet_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        QuantLibJNI.CalibrationSet_clear(this.swigCPtr, this);
    }

    public CalibrationSet(int count, CalibrationPair value) {
        this(QuantLibJNI.new_CalibrationSet__SWIG_2(count, CalibrationPair.getCPtr(value), value), true);
    }

    private int doSize() {
        return QuantLibJNI.CalibrationSet_doSize(this.swigCPtr, this);
    }

    private void doAdd(CalibrationPair x) {
        QuantLibJNI.CalibrationSet_doAdd__SWIG_0(this.swigCPtr, this, CalibrationPair.getCPtr(x), x);
    }

    private void doAdd(int index, CalibrationPair x) {
        QuantLibJNI.CalibrationSet_doAdd__SWIG_1(this.swigCPtr, this, index, CalibrationPair.getCPtr(x), x);
    }

    private CalibrationPair doRemove(int index) {
        return new CalibrationPair(QuantLibJNI.CalibrationSet_doRemove(this.swigCPtr, this, index), true);
    }

    private CalibrationPair doGet(int index) {
        return new CalibrationPair(QuantLibJNI.CalibrationSet_doGet(this.swigCPtr, this, index), false);
    }

    private CalibrationPair doSet(int index, CalibrationPair val) {
        return new CalibrationPair(QuantLibJNI.CalibrationSet_doSet(this.swigCPtr, this, index, CalibrationPair.getCPtr(val), val), true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        QuantLibJNI.CalibrationSet_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

