/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import org.quantlib.Date;
import org.quantlib.Period;
import org.quantlib.QuantLibJNI;
import org.quantlib.ZeroInflationIndex;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class CPI
implements QuantLibJNIHelpers.AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected CPI(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(CPI obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(CPI obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_CPI(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static double laggedFixing(ZeroInflationIndex index, Date date, Period observationLag, InterpolationType interpolationType) {
        return QuantLibJNI.CPI_laggedFixing(ZeroInflationIndex.getCPtr(index), index, Date.getCPtr(date), date, Period.getCPtr(observationLag), observationLag, interpolationType.swigValue());
    }

    public CPI() {
        this(QuantLibJNI.new_CPI(), true);
    }

    public static final class InterpolationType {
        public static final InterpolationType AsIndex = new InterpolationType("AsIndex");
        public static final InterpolationType Flat = new InterpolationType("Flat");
        public static final InterpolationType Linear = new InterpolationType("Linear");
        private static InterpolationType[] swigValues = new InterpolationType[]{AsIndex, Flat, Linear};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static InterpolationType swigToEnum(int swigValue) {
            if (swigValue < swigValues.length && swigValue >= 0 && InterpolationType.swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (InterpolationType.swigValues[i].swigValue != swigValue) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + InterpolationType.class + " with value " + swigValue);
        }

        private InterpolationType(String swigName) {
            this.swigName = swigName;
            this.swigValue = swigNext++;
        }

        private InterpolationType(String swigName, int swigValue) {
            this.swigName = swigName;
            this.swigValue = swigValue;
            swigNext = swigValue + 1;
        }

        private InterpolationType(String swigName, InterpolationType swigEnum) {
            this.swigName = swigName;
            this.swigValue = swigEnum.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

