/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import org.quantlib.CalibrationHelper;
import org.quantlib.PricingEngine;
import org.quantlib.QuantLibJNI;
import org.quantlib.QuoteHandle;
import org.quantlib.VolatilityType;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class BlackCalibrationHelper
extends CalibrationHelper
implements QuantLibJNIHelpers.AutoCloseable {
    private transient long swigCPtr;
    private transient boolean swigCMemOwnDerived;

    protected BlackCalibrationHelper(long cPtr, boolean cMemoryOwn) {
        super(QuantLibJNI.BlackCalibrationHelper_SWIGSmartPtrUpcast(cPtr), true);
        this.swigCMemOwnDerived = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(BlackCalibrationHelper obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void swigSetCMemOwn(boolean own) {
        this.swigCMemOwnDerived = own;
        super.swigSetCMemOwn(own);
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwnDerived) {
                this.swigCMemOwnDerived = false;
                QuantLibJNI.delete_BlackCalibrationHelper(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setPricingEngine(PricingEngine engine) {
        QuantLibJNI.BlackCalibrationHelper_setPricingEngine(this.swigCPtr, this, PricingEngine.getCPtr(engine), engine);
    }

    public double marketValue() {
        return QuantLibJNI.BlackCalibrationHelper_marketValue(this.swigCPtr, this);
    }

    public double modelValue() {
        return QuantLibJNI.BlackCalibrationHelper_modelValue(this.swigCPtr, this);
    }

    public double impliedVolatility(double targetValue, double accuracy, long maxEvaluations, double minVol, double maxVol) {
        return QuantLibJNI.BlackCalibrationHelper_impliedVolatility(this.swigCPtr, this, targetValue, accuracy, maxEvaluations, minVol, maxVol);
    }

    public double blackPrice(double volatility) {
        return QuantLibJNI.BlackCalibrationHelper_blackPrice(this.swigCPtr, this, volatility);
    }

    public QuoteHandle volatility() {
        return new QuoteHandle(QuantLibJNI.BlackCalibrationHelper_volatility(this.swigCPtr, this), true);
    }

    public VolatilityType volatilityType() {
        return VolatilityType.swigToEnum(QuantLibJNI.BlackCalibrationHelper_volatilityType(this.swigCPtr, this));
    }

    @Override
    public double calibrationError() {
        return QuantLibJNI.BlackCalibrationHelper_calibrationError(this.swigCPtr, this);
    }

    public static final class CalibrationErrorType {
        public static final CalibrationErrorType RelativePriceError = new CalibrationErrorType("RelativePriceError");
        public static final CalibrationErrorType PriceError = new CalibrationErrorType("PriceError");
        public static final CalibrationErrorType ImpliedVolError = new CalibrationErrorType("ImpliedVolError");
        private static CalibrationErrorType[] swigValues = new CalibrationErrorType[]{RelativePriceError, PriceError, ImpliedVolError};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static CalibrationErrorType swigToEnum(int swigValue) {
            if (swigValue < swigValues.length && swigValue >= 0 && CalibrationErrorType.swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (CalibrationErrorType.swigValues[i].swigValue != swigValue) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + CalibrationErrorType.class + " with value " + swigValue);
        }

        private CalibrationErrorType(String swigName) {
            this.swigName = swigName;
            this.swigValue = swigNext++;
        }

        private CalibrationErrorType(String swigName, int swigValue) {
            this.swigName = swigName;
            this.swigValue = swigValue;
            swigNext = swigValue + 1;
        }

        private CalibrationErrorType(String swigName, CalibrationErrorType swigEnum) {
            this.swigName = swigName;
            this.swigValue = swigEnum.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

