/*
 * Decompiled with CFR 0.152.
 */
package io.eblock.eos4j.ecc;

import io.eblock.eos4j.utils.EException;
import java.math.BigInteger;
import java.util.Random;

public class FieldElement {
    private BigInteger q;
    private BigInteger x;
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    public FieldElement(BigInteger q, BigInteger x) {
        this.x = x;
        if (x.compareTo(q) >= 0) {
            throw new EException("error", "x value too large in field element");
        }
        this.q = q;
    }

    public FieldElement add(FieldElement b) {
        return new FieldElement(this.q, this.x.add(b.toBigInteger()).mod(this.q));
    }

    public FieldElement subtract(FieldElement b) {
        return new FieldElement(this.q, this.x.subtract(b.toBigInteger()).mod(this.q));
    }

    public FieldElement multiply(FieldElement b) {
        return new FieldElement(this.q, this.x.multiply(b.toBigInteger()).mod(this.q));
    }

    public FieldElement divide(FieldElement b) {
        return new FieldElement(this.q, this.x.multiply(b.toBigInteger().modInverse(this.q)).mod(this.q));
    }

    public FieldElement negate() {
        return new FieldElement(this.q, this.x.negate().mod(this.q));
    }

    public FieldElement square() {
        return new FieldElement(this.q, this.x.multiply(this.x).mod(this.q));
    }

    public FieldElement invert() {
        return new FieldElement(this.q, this.x.modInverse(this.q));
    }

    public String toString() {
        return this.toBigInteger().toString(16);
    }

    public FieldElement sqrt() {
        if (!this.q.testBit(0)) {
            throw new RuntimeException("not done yet");
        }
        if (this.q.testBit(1)) {
            FieldElement z = new FieldElement(this.q, this.x.modPow(this.q.shiftRight(2).add(BigInteger.ONE), this.q));
            return z.square().equals(this) ? z : null;
        }
        BigInteger qMinusOne = this.q.subtract(BigInteger.ONE);
        BigInteger legendreExponent = qMinusOne.shiftRight(1);
        if (!this.x.modPow(legendreExponent, this.q).equals(BigInteger.ONE)) {
            return null;
        }
        BigInteger u = qMinusOne.shiftRight(2);
        BigInteger k = u.shiftLeft(1).add(BigInteger.ONE);
        BigInteger Q = this.x;
        BigInteger fourQ = Q.shiftLeft(2).mod(this.q);
        Random rand = new Random();
        while (true) {
            BigInteger P;
            if ((P = new BigInteger(this.q.bitLength(), rand)).compareTo(this.q) >= 0 || !P.multiply(P).subtract(fourQ).modPow(legendreExponent, this.q).equals(qMinusOne)) {
                continue;
            }
            BigInteger[] result = FieldElement.lucasSequence(this.q, P, Q, k);
            BigInteger U = result[0];
            BigInteger V = result[1];
            if (V.multiply(V).mod(this.q).equals(fourQ)) {
                if (V.testBit(0)) {
                    V = V.add(this.q);
                }
                V = V.shiftRight(1);
                return new FieldElement(this.q, V);
            }
            if (!U.equals(BigInteger.ONE) && !U.equals(qMinusOne)) break;
        }
        return null;
    }

    private static BigInteger[] lucasSequence(BigInteger p, BigInteger P, BigInteger Q, BigInteger k) {
        int j;
        int n = k.bitLength();
        int s = k.getLowestSetBit();
        BigInteger Uh = BigInteger.ONE;
        BigInteger Vl = TWO;
        BigInteger Vh = P;
        BigInteger Ql = BigInteger.ONE;
        BigInteger Qh = BigInteger.ONE;
        for (j = n - 1; j >= s + 1; --j) {
            Ql = Ql.multiply(Qh).mod(p);
            if (k.testBit(j)) {
                Qh = Ql.multiply(Q).mod(p);
                Uh = Uh.multiply(Vh).mod(p);
                Vl = Vh.multiply(Vl).subtract(P.multiply(Ql)).mod(p);
                Vh = Vh.multiply(Vh).subtract(Qh.shiftLeft(1)).mod(p);
                continue;
            }
            Qh = Ql;
            Uh = Uh.multiply(Vl).subtract(Ql).mod(p);
            Vh = Vh.multiply(Vl).subtract(P.multiply(Ql)).mod(p);
            Vl = Vl.multiply(Vl).subtract(Ql.shiftLeft(1)).mod(p);
        }
        Ql = Ql.multiply(Qh).mod(p);
        Qh = Ql.multiply(Q).mod(p);
        Uh = Uh.multiply(Vl).subtract(Ql).mod(p);
        Vl = Vh.multiply(Vl).subtract(P.multiply(Ql)).mod(p);
        Ql = Ql.multiply(Qh).mod(p);
        for (j = 1; j <= s; ++j) {
            Uh = Uh.multiply(Vl).mod(p);
            Vl = Vl.multiply(Vl).subtract(Ql.shiftLeft(1)).mod(p);
            Ql = Ql.multiply(Ql).mod(p);
        }
        return new BigInteger[]{Uh, Vl};
    }

    public BigInteger toBigInteger() {
        return this.x;
    }

    public int getFieldSize() {
        return this.q.bitLength();
    }

    public BigInteger getQ() {
        return this.q;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FieldElement)) {
            return false;
        }
        FieldElement o = (FieldElement)other;
        return this.q.equals(o.q) && this.x.equals(o.x);
    }

    public int hashCode() {
        return this.q.hashCode() ^ this.x.hashCode();
    }
}

