/*
 * Decompiled with CFR 0.152.
 */
package io.github.qudtlib.maven.rdfio.filter;

import io.github.qudtlib.maven.rdfio.filter.ExcludeFilter;
import io.github.qudtlib.maven.rdfio.filter.Filter;
import io.github.qudtlib.maven.rdfio.filter.IncludeFilter;
import io.github.qudtlib.maven.rdfio.filter.SparqlUpdateFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;

public class Filters {
    private final List<Filter> filters = new ArrayList<Filter>();
    private Log log;

    @Parameter
    public void setInclude(IncludeFilter includeFilter) {
        this.filters.add(includeFilter);
    }

    @Parameter
    public void setExclude(ExcludeFilter excludeFilter) {
        this.filters.add(excludeFilter);
    }

    @Parameter
    public void setSparqlUpdate(String update) {
        this.filters.add(new SparqlUpdateFilter(update));
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void filter(Model inputGraph) throws MojoExecutionException {
        for (Filter filter : this.filters) {
            long sizeBefore = inputGraph.size();
            long start = System.currentTimeMillis();
            filter.setLog(this.log);
            filter.filter(inputGraph);
            long sizeAfter = inputGraph.size();
            long end = System.currentTimeMillis();
            this.log.info((CharSequence)String.format("Filter %s changed statement count from %d to %d (diff: %d) in %d millis", filter.getClass().getSimpleName(), sizeBefore, sizeAfter, sizeAfter - sizeBefore, end - start));
        }
    }

    public void setLog(Log log) {
        this.log = log;
    }
}

