/*
 * Decompiled with CFR 0.152.
 */
package com.gc.craftsman.logstash.logback.thread;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestScopeContext<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(RequestScopeContext.class);
    private static RequestScopeContext instance = new RequestScopeContext();
    private ThreadLocal<Map<K, V>> localMap = new ThreadLocal();
    private ThreadLocal<Set<K>> localSet = new ThreadLocal();

    private RequestScopeContext() {
    }

    public static RequestScopeContext getInstance() {
        return instance;
    }

    public void init() {
        this.localMap.set(Maps.newConcurrentMap());
        this.localSet.set(Sets.newConcurrentHashSet());
        logger.debug("request scope context init");
    }

    public boolean isReady() {
        return this.localMap.get() != null;
    }

    public Map<K, V> getLocalMap() {
        return this.localMap.get();
    }

    public Set<K> getLocalSet() {
        return this.localSet.get();
    }

    public void setLocalMapAndSet(Map map, Set set) {
        this.localMap.set(map);
        this.localSet.set(set);
    }

    public void put(K key, V value) {
        if (this.localSet.get() == null) {
            this.localSet.set(Sets.newConcurrentHashSet());
        }
        this.localSet.get().add(key);
        if (this.localMap.get() == null) {
            this.localMap.set(Maps.newConcurrentMap());
        }
        if (value != null) {
            this.localMap.get().put(key, value);
        }
    }

    public V get(K key) {
        return this.localMap.get().get(key);
    }

    public boolean containsKey(K key) {
        return this.localSet.get().contains(key);
    }

    public boolean notContainsKey(K key) {
        return !this.containsKey(key);
    }

    public void clear() {
        this.localMap.remove();
        this.localSet.remove();
        logger.debug("request scope context clear");
    }
}

