/*
 * Decompiled with CFR 0.152.
 */
package io.github.pturczyk.yaml.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;

@Named
@Singleton
public class YamlFileUtils {
    private static final String[] YAML_EXTENSIONS = new String[]{"yml", "yaml"};

    public Set<String> getAbsoluteFilePaths(Set<String> paths) {
        HashSet<String> result = new HashSet<String>();
        for (String path : paths) {
            File file = new File(path);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                for (File yamlFile : FileUtils.listFiles((File)file, (String[])YAML_EXTENSIONS, (boolean)true)) {
                    result.add(yamlFile.getAbsolutePath());
                }
                continue;
            }
            result.add(file.getAbsolutePath());
        }
        return result;
    }

    public InputStream openStream(String filePath) throws FileNotFoundException {
        return new FileInputStream(filePath);
    }
}

