/*
 * Decompiled with CFR 0.152.
 */
package io.phillipuniverse;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

@Mojo(name="install", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public final class GitHookInstallMojo
extends AbstractMojo {
    private static final String NEW_LINE = System.lineSeparator();
    private static final String SHEBANG = "#!/bin/sh" + NEW_LINE;
    private static final List<String> validHooks = Arrays.asList("applypatch-msg", "pre-applypatch", "post-applypatch", "pre-commit", "prepare-commit-msg", "commit-msg", "post-commit", "pre-rebase", "post-checkout", "post-merge", "pre-receive", "update", "post-receive", "post-update", "pre-auto-gc", "post-rewrite", "pre-push");
    @Parameter
    private Map<String, String> hooks;
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private String buildDirectory;
    @Parameter(property="githook.plugin.skip")
    private boolean skip = false;
    @Parameter(property="githook.plugin.skipRepositoryCheck")
    private boolean skipRepositoryCheck = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping GitHook plugin execution");
            return;
        }
        Path hooksDir = this.getOrCreateHooksDirectory(this.buildDirectory);
        if (!this.skipRepositoryCheck && hooksDir == null) {
            throw new MojoExecutionException(String.format("Not a git repository, could not find a .git/hooks directory anywhere in the hierarchy of %s. Turn off this behavior with skipRepositoryCheck=false", this.buildDirectory));
        }
        if (hooksDir == null) {
            this.getLog().info((CharSequence)"No .git directory found, skipping plugin execution");
            return;
        }
        for (Map.Entry<String, String> hook : this.hooks.entrySet()) {
            String hookName = hook.getKey();
            if (!validHooks.contains(hookName)) {
                this.getLog().error((CharSequence)String.format("`%s` hook is not a valid git-hook name", hookName));
                continue;
            }
            String hookScript = hook.getValue();
            String finalScript = (hookScript.startsWith("#!") ? "" : SHEBANG) + hookScript + NEW_LINE;
            try {
                this.getLog().info((CharSequence)String.format("Installing %s hook into %s", hookName, hooksDir.toAbsolutePath().toString()));
                this.writeFile(hooksDir.resolve(hookName), finalScript.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not write hook with name: " + hookName, (Exception)e);
            }
        }
    }

    private synchronized void writeFile(Path path, byte[] bytes) throws IOException {
        boolean success;
        File created = Files.write(path, bytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING).toFile();
        boolean bl = success = created.setExecutable(true, true) && created.setReadable(true, true) && created.setWritable(true, true);
        if (!success) {
            throw new IllegalStateException(String.format("Could not set permissions on created file %s", created.getAbsolutePath()));
        }
    }

    private Path getOrCreateHooksDirectory(String base) {
        this.getLog().debug((CharSequence)String.format("Searching for .git directory starting at %s", base));
        File gitMetadataDir = ((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(new File(base))).getGitDir();
        if (gitMetadataDir == null) {
            return null;
        }
        Path hooksDir = gitMetadataDir.toPath().resolve("hooks");
        if (!hooksDir.toFile().exists()) {
            this.getLog().info((CharSequence)String.format("Creating missing hooks directory at %s", hooksDir.toAbsolutePath().toString()));
            try {
                Files.createDirectories(hooksDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
                return null;
            }
        }
        return hooksDir;
    }
}

