/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.util;

import org.apache.niolex.commons.concurrent.ThreadUtil;

public abstract class Runme
extends Thread {
    private volatile boolean isWorking = false;
    private long sleepInterval = 1000L;

    public Runme() {
        super("Runme");
    }

    @Override
    public void start() {
        this.setDaemon(true);
        super.start();
    }

    @Override
    public final void run() {
        if (this.isWorking) {
            ThreadUtil.sleep(System.nanoTime() % this.sleepInterval);
        } else {
            this.isWorking = true;
        }
        while (this.isWorking) {
            try {
                this.runMe();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ThreadUtil.sleep(this.sleepInterval);
        }
    }

    public abstract void runMe();

    public void stopMe() {
        this.isWorking = false;
        this.interrupt();
    }

    public void setSleepInterval(long sleepInterval) {
        this.sleepInterval = sleepInterval;
    }

    public void setInitialSleep(boolean sleep) {
        this.isWorking = sleep;
    }
}

