/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.util;

import java.util.Collection;
import org.apache.niolex.commons.bean.Pair;
import org.apache.niolex.commons.test.Check;
import org.apache.niolex.commons.test.MockUtil;

public class MathUtil
extends MockUtil {
    public static Pair<Integer, Double> calcStandardDeviation(int ... array) {
        Check.lt(0, array.length, "the input array must contain as least one element.");
        long total = 0L;
        for (int i : array) {
            total += (long)i;
        }
        int avg = (int)(total / (long)array.length);
        double msr = 0.0;
        for (int i : array) {
            msr += Math.pow(avg - i, 2.0);
        }
        return Pair.create(avg, Math.sqrt(msr / (double)array.length));
    }

    public static Pair<Integer, Double> calcStandardDeviation(Collection<Integer> coll) {
        Check.lt(0, coll.size(), "the input collection must contain as least one element.");
        long total = 0L;
        for (int i : coll) {
            total += (long)i;
        }
        int avg = (int)(total / (long)coll.size());
        double msr = 0.0;
        for (int i : coll) {
            msr += Math.pow(avg - i, 2.0);
        }
        return Pair.create(avg, Math.sqrt(msr / (double)coll.size()));
    }

    public static final int max(int a, int b, int c) {
        return a > b ? (a > c ? a : c) : (b > c ? b : c);
    }

    public static final int max(int ... values) {
        int r = Integer.MIN_VALUE;
        for (int v : values) {
            if (v <= r) continue;
            r = v;
        }
        return r;
    }

    public static final int min(int a, int b, int c) {
        return a < b ? (a < c ? a : c) : (b < c ? b : c);
    }

    public static final int min(int ... values) {
        int r = Integer.MAX_VALUE;
        for (int v : values) {
            if (v >= r) continue;
            r = v;
        }
        return r;
    }

    public static final long sum(int ... values) {
        long r = 0L;
        for (int v : values) {
            r += (long)v;
        }
        return r;
    }

    public static final double avg(int ... values) {
        long s = MathUtil.sum(values);
        return (double)s / (double)values.length;
    }
}

