/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.util;

import java.util.Arrays;
import org.apache.niolex.commons.test.Check;
import org.apache.niolex.commons.test.Tester;

public class CommonStatistics {
    private double[] value;
    private int size;
    private boolean sorted = false;

    public static final double pow2(double v) {
        return v * v;
    }

    public CommonStatistics() {
        this.value = new double[100];
        this.size = 0;
    }

    public CommonStatistics(double[] dataSet) {
        this.size = dataSet.length;
        this.value = Arrays.copyOf(dataSet, this.size);
    }

    public void addValue(double v) {
        if (this.size == this.value.length) {
            this.value = Arrays.copyOf(this.value, this.size * 2);
        }
        this.sorted = false;
        this.value[this.size++] = v;
    }

    public void sortData() {
        if (this.sorted) {
            return;
        }
        Arrays.sort(this.value, 0, this.size);
        this.sorted = true;
    }

    public Statistics percentileStatistics(double percentile) {
        int len;
        Check.between(0.0, percentile, 100.0, "percentile muster in the range of [0.0, 100.0]");
        this.sortData();
        Statistics s = new Statistics();
        s.size = len = (int)(percentile * (double)(this.size - 1) / 100.0) + 1;
        double sum = 0.0;
        for (int i = 0; i < len; ++i) {
            sum += this.value[i];
        }
        double avg = sum / (double)len;
        double variance = 0.0;
        for (int i = 0; i < len; ++i) {
            variance += CommonStatistics.pow2(this.value[i] - avg);
        }
        s.avg = avg;
        s.sd = Math.pow(variance /= (double)len, 0.5);
        s.variance = variance;
        s.median = len % 2 == 0 ? (this.value[len / 2 - 1] + this.value[len / 2]) / 2.0 : this.value[len / 2];
        s.sum = sum;
        s.min = this.value[0];
        s.max = this.value[len - 1];
        return s;
    }

    public double percentileValue(double percentile) {
        Check.between(0.0, percentile, 100.0, "percentile muster in the range of [0.0, 100.0]");
        this.sortData();
        double dIdx = percentile * (double)(this.size - 1) / 100.0;
        int idx = (int)dIdx;
        if (Tester.equal(dIdx, (double)idx)) {
            return this.value[idx];
        }
        double f = dIdx - (double)idx;
        return this.value[idx] * (1.0 - f) + this.value[idx + 1] * f;
    }

    public static class Statistics {
        public double avg = -1.0;
        public double sd = -1.0;
        public double variance = -1.0;
        public double median = -1.0;
        public double sum = 0.0;
        public double max = -1.0;
        public double min = -1.0;
        public int size;
    }
}

