/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.test;

import org.apache.niolex.commons.codec.StringUtil;
import org.apache.niolex.commons.test.Check;

public abstract class TidyUtil {
    public static final String removePrefix(String str, int prefix) {
        String[] lines = StringUtil.splitLines(str, true);
        StringBuilder sb = new StringBuilder();
        for (String l : lines) {
            if (l.length() > prefix) {
                sb.append(l.substring(prefix));
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static final int matchParenthesis(String s, int start) {
        int end = s.length();
        int numL = 0;
        for (int i = start; i < end; ++i) {
            if (s.charAt(i) == '(') {
                ++numL;
                continue;
            }
            if (s.charAt(i) != ')' || --numL != 0) continue;
            return i;
        }
        throw new IllegalArgumentException("Parentheses can not be matched: " + s.substring(start));
    }

    public static final void generateChar(StringBuilder sb, char ch, int count) {
        for (int i = 0; i < count; ++i) {
            sb.append(ch);
        }
    }

    public static final void generateSeparator(StringBuilder sb, int[] colLen) {
        sb.append('+');
        for (int i = 0; i < colLen.length; ++i) {
            TidyUtil.generateChar(sb, '-', colLen[i]);
            sb.append('+');
        }
        sb.append('\n');
    }

    public static final boolean generateCell(StringBuilder sb, int colLen, Object value, Align align) {
        if (value == null) {
            TidyUtil.generateChar(sb, ' ', colLen);
            return false;
        }
        String str = value.toString();
        int len = str.length();
        if (len > colLen) {
            sb.append(str.substring(0, colLen));
            return true;
        }
        if (len == colLen) {
            sb.append(str);
            return false;
        }
        int left = 0;
        switch (align) {
            case LEFT: {
                left = 0;
                break;
            }
            case MIDDILE: {
                left = (colLen - len) / 2;
                break;
            }
            default: {
                left = colLen - len;
            }
        }
        TidyUtil.generateChar(sb, ' ', left);
        sb.append(str);
        TidyUtil.generateChar(sb, ' ', colLen - left - len);
        return false;
    }

    public static final void generateRow(StringBuilder sb, int[] colLen, Object[] values, boolean isTitle) {
        Check.eq(values.length, colLen.length, "No enough col length.");
        boolean overflow = false;
        sb.append('|');
        for (int i = 0; i < values.length; ++i) {
            overflow = isTitle ? TidyUtil.generateCell(sb, colLen[i], values[i], Align.MIDDILE) : (values[i] instanceof Number ? TidyUtil.generateCell(sb, colLen[i], values[i], Align.RIGHT) : TidyUtil.generateCell(sb, colLen[i], values[i], Align.LEFT));
            if (overflow) {
                sb.append('^');
                continue;
            }
            sb.append('|');
        }
        sb.append('\n');
    }

    public static final String generateTable(int[] colLen, String[] titles, Object ... values) {
        StringBuilder sb = new StringBuilder();
        TidyUtil.generateSeparator(sb, colLen);
        TidyUtil.generateRow(sb, colLen, titles, true);
        TidyUtil.generateSeparator(sb, colLen);
        Object[] tmp = new Object[colLen.length];
        for (int i = 0; i < values.length; i += colLen.length) {
            for (int k = 0; k < colLen.length; ++k) {
                tmp[k] = i + k < values.length ? values[i + k] : null;
            }
            TidyUtil.generateRow(sb, colLen, tmp, false);
        }
        TidyUtil.generateSeparator(sb, colLen);
        return sb.toString();
    }

    public static enum Align {
        LEFT,
        MIDDILE,
        RIGHT;

    }
}

