/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.test;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import org.apache.niolex.commons.codec.IntegerUtil;
import org.apache.niolex.commons.concurrent.ThreadUtil;
import org.apache.niolex.commons.test.TidyUtil;
import org.apache.niolex.commons.util.Runme;

public class SystemInfo {
    private static final ThreadGroup TOP_GROUP = ThreadUtil.topGroup();
    private static final int[] COL_LEN = new int[]{20, 20, 11};
    private static final String[] TITLES = new String[]{"Category", "Attribute", "Value"};
    private static final SystemInfo INSTANCE = new SystemInfo();
    private MemoryUsage heapMem;
    private MemoryUsage nonHeapMem;
    private int usedRatio;
    private int cpuNumber;
    private double loadAverage;
    private List<GarbageCollectorMXBean> gcList;
    private int totalThreadCount;
    private int activeThreadCount;
    private Runme runme;

    public static final SystemInfo getInstance() {
        INSTANCE.refreshSystemInfo();
        return INSTANCE;
    }

    private SystemInfo() {
    }

    public synchronized void autoRefresh(int refreshInterval) {
        if (this.runme == null) {
            this.runme = new Runme(){

                @Override
                public void runMe() {
                    SystemInfo.this.refreshSystemInfo();
                }
            };
            this.runme.setSleepInterval(refreshInterval);
            this.runme.start();
        } else {
            this.runme.setSleepInterval(refreshInterval);
        }
    }

    public synchronized void stopRefresh() {
        if (this.runme != null) {
            this.runme.stopMe();
            this.runme = null;
        }
    }

    public void refreshSystemInfo() {
        this.gcList = ManagementFactory.getGarbageCollectorMXBeans();
        MemoryMXBean m = ManagementFactory.getMemoryMXBean();
        this.heapMem = m.getHeapMemoryUsage();
        this.nonHeapMem = m.getNonHeapMemoryUsage();
        this.usedRatio = (int)(this.heapMem.getUsed() * 100L / this.heapMem.getCommitted());
        OperatingSystemMXBean o = ManagementFactory.getOperatingSystemMXBean();
        this.cpuNumber = o.getAvailableProcessors();
        this.loadAverage = o.getSystemLoadAverage();
        ThreadMXBean t = ManagementFactory.getThreadMXBean();
        this.totalThreadCount = t.getThreadCount();
        this.activeThreadCount = TOP_GROUP.activeCount();
    }

    public String generateSystemInfo() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("Heap Memory");
        list.add("Used");
        list.add(IntegerUtil.formatSize(this.heapMem.getUsed()));
        list.add("Heap Memory");
        list.add("Committed");
        list.add(IntegerUtil.formatSize(this.heapMem.getCommitted()));
        list.add("Heap Memory");
        list.add("Used Ratio");
        list.add(this.usedRatio + "%");
        list.add("nonHeap Memory");
        list.add("Used");
        list.add(IntegerUtil.formatSize(this.nonHeapMem.getUsed()));
        list.add("nonHeap Memory");
        list.add("Committed");
        list.add(IntegerUtil.formatSize(this.nonHeapMem.getCommitted()));
        list.add("CPU");
        list.add("Number");
        list.add(this.cpuNumber);
        list.add("CPU");
        list.add("Load Average");
        list.add(this.loadAverage);
        for (GarbageCollectorMXBean bean : this.gcList) {
            list.add("GC");
            list.add("Name");
            list.add(bean.getName());
            list.add("GC");
            list.add("Collection Count");
            list.add(bean.getCollectionCount());
            list.add("GC");
            list.add("Collection Time");
            list.add(bean.getCollectionTime());
        }
        list.add("Threads");
        list.add("Total Count");
        list.add(this.totalThreadCount);
        list.add("Threads");
        list.add("Active Count");
        list.add(this.activeThreadCount);
        return TidyUtil.generateTable(COL_LEN, TITLES, list.toArray());
    }

    public MemoryUsage getHeapMem() {
        return this.heapMem;
    }

    public MemoryUsage getNonHeapMem() {
        return this.nonHeapMem;
    }

    public int getUsedRatio() {
        return this.usedRatio;
    }

    public int getCpuNumber() {
        return this.cpuNumber;
    }

    public double getLoadAverage() {
        return this.loadAverage;
    }

    public List<GarbageCollectorMXBean> getGcList() {
        return this.gcList;
    }

    public int getTotalThreadCount() {
        return this.totalThreadCount;
    }

    public int getActiveThreadCount() {
        return this.activeThreadCount;
    }
}

