/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.test;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.niolex.commons.bean.Pair;
import org.apache.niolex.commons.codec.StringUtil;
import org.apache.niolex.commons.reflect.FieldFilter;

public class SQLGenerator {
    public static final String generateColumnName(String fieldName) {
        StringBuilder sb = new StringBuilder();
        boolean upperFlag = true;
        for (int i = 0; i < fieldName.length(); ++i) {
            char c = fieldName.charAt(i);
            if (Character.isUpperCase(c)) {
                if (upperFlag) {
                    sb.append(c);
                    continue;
                }
                upperFlag = true;
                sb.append('_');
                sb.append(c);
                continue;
            }
            upperFlag = false;
            sb.append(Character.toUpperCase(c));
        }
        return sb.toString();
    }

    public static final List<Pair<String, String>> generateColumnMappingList(Class<?> clazz) {
        ArrayList<Pair<String, String>> mappingList = new ArrayList<Pair<String, String>>();
        List<Field> list = FieldFilter.c().noStatic().noSynthetic().clazz(clazz).find().results();
        for (Field f : list) {
            String fieldName = f.getName();
            mappingList.add(Pair.create(fieldName, SQLGenerator.generateColumnName(fieldName)));
        }
        return mappingList;
    }

    public static final String generateInsert(Class<?> clazz, String tableName) {
        StringBuilder sb = new StringBuilder();
        StringBuilder sbK = new StringBuilder();
        StringBuilder sbV = new StringBuilder();
        List<Pair<String, String>> list = SQLGenerator.generateColumnMappingList(clazz);
        sb.append("INSERT INTO ").append(tableName).append(" (");
        for (Pair<String, String> p : list) {
            sbV.append("#{").append((String)p.a).append("}, ");
            sbK.append((String)p.b).append(", ");
        }
        sbK.setLength(sbK.length() - 2);
        sbV.setLength(sbV.length() - 2);
        sb.append(sbK.toString()).append(") VALUES (");
        sb.append(sbV.toString()).append(");");
        return sb.toString();
    }

    public static final String generateUpdate(Class<?> clazz, String tableName, String ... whereConditions) {
        StringBuilder sb = new StringBuilder();
        StringBuilder where = new StringBuilder();
        List<Pair<String, String>> list = SQLGenerator.generateColumnMappingList(clazz);
        sb.append("UPDATE ").append(tableName).append(" SET ");
        for (Pair<String, String> p : list) {
            if (StringUtil.isIn((String)p.a, whereConditions)) {
                where.append((String)p.b).append(" = #{").append((String)p.a).append("} AND ");
                continue;
            }
            sb.append((String)p.b).append(" = #{").append((String)p.a).append("}, ");
        }
        sb.setLength(sb.length() - 2);
        where.setLength(where.length() - 5);
        sb.append(" WHERE ").append(where.toString()).append(';');
        return sb.toString();
    }

    public static final String generateSelect(Class<?> clazz, String tableName, String ... whereConditions) {
        StringBuilder sb = new StringBuilder();
        StringBuilder where = new StringBuilder();
        List<Pair<String, String>> list = SQLGenerator.generateColumnMappingList(clazz);
        sb.append("SELECT ");
        for (Pair<String, String> p : list) {
            if (StringUtil.isIn((String)p.a, whereConditions)) {
                where.append((String)p.b).append(" = #{").append((String)p.a).append("} AND ");
                continue;
            }
            sb.append((String)p.b).append(", ");
        }
        sb.setLength(sb.length() - 2);
        where.setLength(where.length() - 5);
        sb.append(" FROM ").append(tableName).append(" WHERE ").append(where.toString()).append(';');
        return sb.toString();
    }
}

