/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.test;

import org.apache.niolex.commons.util.SystemUtil;

public abstract class Performance {
    private final int innerIteration;
    private final int outerIteration;
    private long max;
    private long min;

    public Performance(int innerIteration, int outerIteration) {
        this.innerIteration = innerIteration;
        this.outerIteration = outerIteration;
    }

    protected abstract void run();

    protected void oneRun() {
        for (int j = 0; j < this.innerIteration; ++j) {
            this.run();
        }
    }

    public void start() {
        long cu;
        this.oneRun();
        this.max = Integer.MIN_VALUE;
        this.min = Integer.MAX_VALUE;
        long total = 0L;
        long ein = System.currentTimeMillis();
        for (int i = 0; i < this.outerIteration; ++i) {
            long in = System.currentTimeMillis();
            this.oneRun();
            cu = System.currentTimeMillis() - in;
            if (cu > this.max) {
                this.max = cu;
            }
            if (cu < this.min) {
                this.min = cu;
            }
            total += cu;
        }
        cu = total / (long)this.outerIteration;
        System.out.println("PERF done, total time " + (System.currentTimeMillis() - ein) + "ms.");
        SystemUtil.printTable(new int[]{10, 10, 10, 10}, new String[]{"ITERATIONS", "AVG", "MAX", "MIN"}, this.outerIteration, cu, this.max, this.min);
    }
}

