/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.test;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.apache.niolex.commons.codec.Base16Util;
import org.apache.niolex.commons.reflect.FieldUtil;
import org.apache.niolex.commons.util.Const;

public abstract class ObjToStringUtil
implements Const {
    private static final int INDENT = 2;
    private static final int LSP_LEN = LINE_SP.length();
    private static final String INDENT_STR = "                         ";

    public static final String objToString(Object o) {
        StringBuilder sb = new StringBuilder();
        ObjToStringUtil.printFields(o, sb, 2);
        return sb.toString();
    }

    private static final void printFields(Object o, StringBuilder sb, int indentation) {
        if (o == null) {
            sb.append("null");
        } else if (indentation > 12) {
            sb.append(o);
        } else if (o.getClass().isArray()) {
            ObjToStringUtil.printArray(o, sb, indentation);
        } else if (o instanceof Collection) {
            ObjToStringUtil.printCollection((Collection)o, sb, indentation);
        } else if (o instanceof Map) {
            ObjToStringUtil.printMap((Map)o, sb, indentation);
        } else if (o.getClass().getName().startsWith("java")) {
            sb.append(o);
        } else {
            ObjToStringUtil.printObject(o, sb, indentation);
        }
    }

    private static final void printArray(Object o, StringBuilder sb, int indentation) {
        if (o instanceof byte[]) {
            byte[] os = (byte[])o;
            sb.append("(").append(os.length).append(")[");
            sb.append(Base16Util.byteToBase16(os)).append(']');
        } else {
            int length = Array.getLength(o);
            sb.append("(").append(length).append(")[");
            if (length != 0) {
                sb.append(LINE_SP);
                for (int i = 0; i < length; ++i) {
                    ObjToStringUtil.printArrayItem(i, Array.get(o, i), sb, indentation);
                }
                ObjToStringUtil.generateIndentation(sb, indentation - 2);
            }
            sb.append(']');
        }
    }

    private static final void printCollection(Collection<? extends Object> os, StringBuilder sb, int indentation) {
        sb.append("(").append(os.size()).append(")[");
        if (os.size() != 0) {
            sb.append(LINE_SP);
            int i = 0;
            for (Object object : os) {
                ObjToStringUtil.printArrayItem(i++, object, sb, indentation);
            }
            ObjToStringUtil.generateIndentation(sb, indentation - 2);
        }
        sb.append(']');
    }

    private static final void printArrayItem(int index, Object o2, StringBuilder sb, int indentation) {
        ObjToStringUtil.generateIndentation(sb, indentation);
        sb.append(index);
        sb.append(" => ");
        ObjToStringUtil.printFields(o2, sb, indentation + 2);
        sb.append(LINE_SP);
    }

    private static final void printMap(Map<? extends Object, ? extends Object> map, StringBuilder sb, int indentation) {
        sb.append("{").append(LINE_SP);
        for (Map.Entry<? extends Object, ? extends Object> entry : map.entrySet()) {
            ObjToStringUtil.printObjectItem(entry.getKey().toString(), entry.getValue(), sb, indentation);
        }
        ObjToStringUtil.printObjectEnd(sb, indentation);
    }

    private static final void printObject(Object o, StringBuilder sb, int indentation) {
        sb.append("{").append(LINE_SP);
        for (Field f : FieldUtil.getAllFields(o.getClass())) {
            if (f.isSynthetic() || (f.getModifiers() & 8) > 0) continue;
            ObjToStringUtil.printObjectItem(f.getName(), FieldUtil.getFieldValue(o, f), sb, indentation);
        }
        ObjToStringUtil.printObjectEnd(sb, indentation);
    }

    private static final void printObjectItem(String key, Object value, StringBuilder sb, int indentation) {
        ObjToStringUtil.generateIndentation(sb, indentation);
        sb.append(key).append("=");
        ObjToStringUtil.printFields(value, sb, indentation + 2);
        sb.append(LINE_SP);
    }

    private static final void printObjectEnd(StringBuilder sb, int indentation) {
        int i = sb.length() - LSP_LEN;
        if (sb.charAt(i - 1) == '{') {
            sb.delete(i, sb.length());
        } else {
            ObjToStringUtil.generateIndentation(sb, indentation - 2);
        }
        sb.append("}");
    }

    private static final void generateIndentation(StringBuilder sb, int indentation) {
        sb.append(INDENT_STR.substring(0, indentation));
    }
}

