/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.test;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.niolex.commons.concurrent.ThreadUtil;
import org.apache.niolex.commons.util.SystemUtil;

public abstract class MultiPerformance {
    private final int threadsNumber;
    private final int innerIteration;
    private final int outerIteration;
    private volatile long max;
    private volatile long min;
    private AtomicLong total = new AtomicLong();

    public MultiPerformance(int threadsNumber, int innerIteration, int outerIteration) {
        this.threadsNumber = threadsNumber;
        this.innerIteration = innerIteration;
        this.outerIteration = outerIteration;
    }

    protected abstract void run();

    protected void oneRun() {
        for (int j = 0; j < this.innerIteration; ++j) {
            this.run();
        }
    }

    public void start() {
        int i;
        this.oneRun();
        this.max = Integer.MIN_VALUE;
        this.min = Integer.MAX_VALUE;
        this.total.set(0L);
        Run run = new Run();
        long ein = System.currentTimeMillis();
        Thread[] threads = new Thread[this.threadsNumber];
        for (i = 0; i < this.threadsNumber; ++i) {
            threads[i] = new Thread(run);
            threads[i].start();
        }
        for (i = 0; i < this.threadsNumber; ++i) {
            ThreadUtil.join(threads[i]);
        }
        long cu = this.total.get() / (long)this.outerIteration;
        System.out.println("MUL-PERF done, total time " + (System.currentTimeMillis() - ein) + "ms.");
        SystemUtil.printTable(new int[]{10, 10, 10, 10}, new String[]{"ITERATIONS", "AVG", "MAX", "MIN"}, this.outerIteration, cu, this.max, this.min);
    }

    protected class Run
    implements Runnable {
        private AtomicInteger cnt = new AtomicInteger();

        protected Run() {
        }

        @Override
        public void run() {
            while (this.cnt.getAndIncrement() < MultiPerformance.this.outerIteration) {
                long in = System.currentTimeMillis();
                MultiPerformance.this.oneRun();
                long cu = System.currentTimeMillis() - in;
                if (cu > MultiPerformance.this.max) {
                    MultiPerformance.this.max = cu;
                }
                if (cu < MultiPerformance.this.min) {
                    MultiPerformance.this.min = cu;
                }
                MultiPerformance.this.total.addAndGet(cu);
            }
        }
    }
}

