/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.test;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.niolex.commons.bean.Pair;
import org.apache.niolex.commons.test.OrderedRunner;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

public class AnnotationOrderedRunner
extends BlockJUnit4ClassRunner {
    public AnnotationOrderedRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected List<FrameworkMethod> computeTestMethods() {
        List original = super.computeTestMethods();
        ArrayList<Pair<Integer, FrameworkMethod>> annotated = new ArrayList<Pair<Integer, FrameworkMethod>>();
        ArrayList<FrameworkMethod> others = new ArrayList<FrameworkMethod>();
        for (FrameworkMethod fm : original) {
            Method method = fm.getMethod();
            if (method.isAnnotationPresent(Order.class)) {
                int or = method.getAnnotation(Order.class).value();
                annotated.add(Pair.create(or, fm));
                continue;
            }
            others.add(fm);
        }
        Collections.sort(annotated, NumericOrder.INSTANCE);
        Collections.sort(others, OrderedRunner.AlphabeticalOrder.INSTANCE);
        ArrayList<FrameworkMethod> result = new ArrayList<FrameworkMethod>(original.size());
        for (Pair pair : annotated) {
            result.add((FrameworkMethod)pair.b);
        }
        result.addAll(others);
        return result;
    }

    public static class NumericOrder
    implements Comparator<Pair<Integer, FrameworkMethod>> {
        static final NumericOrder INSTANCE = new NumericOrder();

        @Override
        public int compare(Pair<Integer, FrameworkMethod> o1, Pair<Integer, FrameworkMethod> o2) {
            int r = ((Integer)o1.a).compareTo((Integer)o2.a);
            if (r == 0) {
                return ((FrameworkMethod)o1.b).getName().compareTo(((FrameworkMethod)o2.b).getName());
            }
            return r;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Order {
        public int value();
    }
}

