/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.stream;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.niolex.commons.codec.StringUtil;
import org.apache.niolex.commons.util.SystemUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamUtil {
    private static final Logger LOG = LoggerFactory.getLogger(StreamUtil.class);

    public static final Exception closeStream(Closeable s) {
        return SystemUtil.close(s);
    }

    public static final int emptyStream(InputStream in) {
        byte[] buffer = new byte[4096];
        int cnt = 0;
        int total = 0;
        try {
            do {
                total += cnt;
            } while ((cnt = in.read(buffer)) > 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return total;
    }

    public static final int readData(InputStream in, byte[] data) throws IOException {
        int dataPos = 0;
        int length = data.length;
        int count = 0;
        while ((count = in.read(data, dataPos, length - dataPos)) >= 0 && (dataPos += count) != length) {
        }
        return dataPos;
    }

    public static final void writeUTF8(OutputStream out, String s) throws IOException {
        out.write(StringUtil.strToUtf8Byte(s));
    }

    public static final void writeUTF8IgnoreException(OutputStream out, String s) {
        try {
            out.write(StringUtil.strToUtf8Byte(s));
        }
        catch (IOException e) {
            LOG.info("IOException occurred in writeUTF8IgnoreException: {}", (Object)e.getMessage());
        }
    }

    public static final void writeAndClose(OutputStream out, byte[] data) throws IOException {
        try {
            out.write(data);
        }
        finally {
            out.close();
        }
    }

    public static final void writeAndCloseIgnoreException(OutputStream out, byte[] data) {
        try {
            out.write(data);
        }
        catch (IOException e) {
            LOG.info("IOException occurred in writeAndCloseIgnoreException: {}", (Object)e.getMessage());
        }
        finally {
            StreamUtil.closeStream(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int transferAndClose(InputStream in, OutputStream out, int bufSize) throws IOException {
        try {
            int len;
            byte[] data = new byte[bufSize];
            int cnt = 0;
            while ((len = in.read(data)) != -1) {
                out.write(data, 0, len);
                cnt += len;
            }
            int n = cnt;
            return n;
        }
        finally {
            StreamUtil.closeStream(in);
            StreamUtil.closeStream(out);
        }
    }
}

