/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.reflect;

import com.esotericsoftware.reflectasm.FieldAccess;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class FastFieldUtil {
    private static final ConcurrentMap<Class<?>, FieldAccess> FIELD_ACCESS_MAP = new ConcurrentHashMap();

    public static final String[] getFields(Class<?> clazz) {
        return FastFieldUtil.getFieldAccess(clazz).getFieldNames();
    }

    public static final FieldAccess getFieldAccess(Class<?> clazz) {
        FieldAccess fa = (FieldAccess)FIELD_ACCESS_MAP.get(clazz);
        if (fa == null) {
            fa = FieldAccess.get(clazz);
            FIELD_ACCESS_MAP.putIfAbsent(clazz, fa);
        }
        return fa;
    }

    public static final <T> T getFieldValue(Object host, String fieldName) {
        return (T)FastFieldUtil.getFieldAccess(host.getClass()).get(host, fieldName);
    }

    public static final void setFieldValue(Object host, String fieldName, Object value) {
        FastFieldUtil.getFieldAccess(host.getClass()).set(host, fieldName, value);
    }

    public static final void setFieldValue(Object host, String fieldName, boolean value) {
        FieldAccess access = FastFieldUtil.getFieldAccess(host.getClass());
        access.setBoolean(host, access.getIndex(fieldName), value);
    }

    public static final void setFieldValue(Object host, String fieldName, byte value) {
        FieldAccess access = FastFieldUtil.getFieldAccess(host.getClass());
        access.setByte(host, access.getIndex(fieldName), value);
    }

    public static final void setFieldValue(Object host, String fieldName, char value) {
        FieldAccess access = FastFieldUtil.getFieldAccess(host.getClass());
        access.setChar(host, access.getIndex(fieldName), value);
    }

    public static final void setFieldValue(Object host, String fieldName, short value) {
        FieldAccess access = FastFieldUtil.getFieldAccess(host.getClass());
        access.setShort(host, access.getIndex(fieldName), value);
    }

    public static final void setFieldValue(Object host, String fieldName, int value) {
        FieldAccess access = FastFieldUtil.getFieldAccess(host.getClass());
        access.setInt(host, access.getIndex(fieldName), value);
    }

    public static final void setFieldValue(Object host, String fieldName, long value) {
        FieldAccess access = FastFieldUtil.getFieldAccess(host.getClass());
        access.setLong(host, access.getIndex(fieldName), value);
    }

    public static final void setFieldValue(Object host, String fieldName, float value) {
        FieldAccess access = FastFieldUtil.getFieldAccess(host.getClass());
        access.setFloat(host, access.getIndex(fieldName), value);
    }

    public static final void setFieldValue(Object host, String fieldName, double value) {
        FieldAccess access = FastFieldUtil.getFieldAccess(host.getClass());
        access.setDouble(host, access.getIndex(fieldName), value);
    }
}

