/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import org.apache.niolex.commons.codec.IntegerUtil;
import org.apache.niolex.commons.codec.StringUtil;
import org.apache.niolex.commons.internal.IgnoreException;
import org.apache.niolex.commons.test.Check;

public abstract class NetUtil
extends Check {
    public static final Set<InetAddress> getAllLocalAddresses() {
        HashSet<InetAddress> set = new HashSet<InetAddress>();
        IgnoreException.populateLocalAddresses(set);
        return set;
    }

    public static final String getLocalIP() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    public static final String inetSocketAddress2IpPort(InetSocketAddress addr) {
        String s = addr.toString();
        int idx = s.indexOf(47) + 1;
        return s.substring(idx);
    }

    public static final InetSocketAddress ipPort2InetSocketAddress(String ipPort) {
        String[] ip0port1 = StringUtil.split(ipPort, ":", true);
        Check.eq(2, ip0port1.length, "Invalid IP:Port string - " + ipPort);
        int intIP = NetUtil.ipToInt(ip0port1[0]);
        InetAddress addr = NetUtil.getByAddress(IntegerUtil.toFourBytes(intIP));
        int port = Integer.parseInt(ip0port1[1]);
        return new InetSocketAddress(addr, port);
    }

    public static final InetAddress getByAddress(byte[] bytes) {
        try {
            return InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Failed to create InetAddress.", e);
        }
    }

    public static final int ipToInt(String ip) {
        NetUtil.notNull((Object)ip, (String)"The parameter ip is null.", (Object[])new Object[0]);
        String[] nums = StringUtil.split(ip, ".", true);
        String msg = "Invalid IP format: " + ip;
        NetUtil.eq(nums.length, 4, msg);
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            try {
                int k = Integer.parseInt(nums[i]);
                if (k < 0 || k > 255) {
                    throw new IllegalArgumentException(msg);
                }
                res = res << 8 | k;
                continue;
            }
            catch (Throwable t) {
                throw new IllegalArgumentException(msg, t);
            }
        }
        return res;
    }

    public static final String intToIP(int intIP) {
        int[] nums = new int[4];
        for (int i = 3; i > -1; --i) {
            nums[i] = intIP & 0xFF;
            intIP >>= 8;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            sb.append(nums[i]).append('.');
        }
        sb.append(nums[3]);
        return sb.toString();
    }
}

