/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.net;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.niolex.commons.bean.Triple;
import org.apache.niolex.commons.codec.StringUtil;
import org.apache.niolex.commons.collection.CollectionUtil;
import org.apache.niolex.commons.net.DownloadUtil;
import org.apache.niolex.commons.net.HTTPMethod;
import org.apache.niolex.commons.net.NetException;
import org.apache.niolex.commons.stream.StreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HTTPUtil {
    public static final Map<String, String> REQ_HEADER = ImmutableMap.of((Object)"DNT", (Object)"1", (Object)"Accept", (Object)"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8", (Object)"User-Agent", (Object)"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/44.0.2403.155 Safari/537.36", (Object)"Accept-Language", (Object)"zh-cn,zh;q=0.8,en-us;q=0.5,en;q=0.3", (Object)"Cache-Control", (Object)"no-cache");
    private static final Logger LOG = LoggerFactory.getLogger(HTTPUtil.class);
    private static final int CONNECT_TIMEOUT = 6000;
    private static final int READ_TIMEOUT = 6000;
    private static final int MAX_BODY_SIZE = 0xF00000;

    public static final String get(String url) throws NetException {
        return HTTPUtil.get(url, null);
    }

    public static final String get(String url, Map<String, String> params) throws NetException {
        return HTTPUtil.get(url, params, "UTF-8");
    }

    public static final String get(String url, Map<String, String> params, String paramCharset) throws NetException {
        return HTTPUtil.doHTTP(url, params, null, paramCharset, HTTPMethod.GET);
    }

    public static final String post(String url, Map<String, String> params) throws NetException {
        return HTTPUtil.post(url, params, "UTF-8");
    }

    public static final String post(String url, Map<String, String> params, String paramCharset) throws NetException {
        return HTTPUtil.doHTTP(url, params, null, paramCharset, HTTPMethod.POST);
    }

    public static final String post(String url, String postBody) throws NetException {
        return HTTPUtil.post(url, postBody, "UTF-8");
    }

    public static final String post(String url, String postBody, String postCharset) throws NetException {
        return HTTPUtil.doHTTP(url, null, postBody, postCharset, HTTPMethod.POST);
    }

    public static final String doHTTP(String url, Map<String, String> params, String postBody, String reqCharset, HTTPMethod method) throws NetException {
        Triple<Integer, Map<String, List<String>>, byte[]> res = HTTPUtil.doHTTP(url, params, postBody, reqCharset, REQ_HEADER, 6000, 6000, method);
        if (res.z == null) {
            throw new NetException(NetException.ExCode.INVALID_SERVER_RESPONSE, "URL " + url + " response code " + res.x + " [There is no data.]");
        }
        String rest = new String((byte[])res.z, HTTPUtil.inferCharset((Map)res.y, (byte[])res.z));
        if ((Integer)res.x >= 400) {
            throw new NetException(NetException.ExCode.INVALID_SERVER_RESPONSE, "URL " + url + " response code " + res.x + " [Response size " + rest.length() + "]");
        }
        return rest;
    }

    public static final Triple<Integer, Map<String, List<String>>, byte[]> doHTTP(String strUrl, int connectTimeout, int readTimeout, HTTPMethod method) throws NetException {
        return HTTPUtil.doHTTP(strUrl, null, null, null, REQ_HEADER, connectTimeout, readTimeout, method);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Triple<Integer, Map<String, List<String>>, byte[]> doHTTP(String strUrl, Map<String, String> params, String postBody, String reqCharset, Map<String, String> reqHeaders, int connectTimeout, int readTimeout, HTTPMethod method) throws NetException {
        Triple<Integer, Map<String, List<String>>, byte[]> triple;
        int httpResponseCode;
        HttpURLConnection httpCon;
        boolean inErrorStatus;
        InputStream in;
        block20: {
            URL url;
            URLConnection ucon;
            LOG.debug("Start HTTP {} request to [{}], C{}R{}.", new Object[]{method.name(), strUrl, connectTimeout, readTimeout});
            in = null;
            inErrorStatus = true;
            httpCon = null;
            byte[] reqBytes = null;
            String contentType = null;
            if (reqCharset == null) {
                reqCharset = "UTF-8";
            }
            if (!CollectionUtil.isEmpty(params)) {
                if (method.passParametersInURL()) {
                    strUrl = strUrl + '?' + HTTPUtil.prepareWwwFormUrlEncoded(params, reqCharset);
                } else {
                    reqBytes = StringUtil.strToAsciiByte(HTTPUtil.prepareWwwFormUrlEncoded(params, reqCharset));
                    contentType = "application/x-www-form-urlencoded; charset=" + reqCharset;
                }
            }
            if (!StringUtil.isBlank((CharSequence)postBody)) {
                if (method.passParametersInURL()) {
                    throw new IllegalArgumentException("You must use HTTP POST method when you set postBody.");
                }
                if (reqBytes != null) {
                    throw new IllegalArgumentException("You can not use both params and postBody together.");
                }
                reqBytes = postBody.getBytes(reqCharset);
                contentType = "application/json; charset=" + reqCharset;
            }
            if (!((ucon = (url = new URL(strUrl)).openConnection()) instanceof HttpURLConnection)) {
                throw new NetException(NetException.ExCode.INVALID_URL_TYPE, "The request is not in HTTP protocol.");
            }
            httpCon = (HttpURLConnection)ucon;
            if (reqHeaders != null) {
                for (Map.Entry<String, String> entry : reqHeaders.entrySet()) {
                    httpCon.addRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            httpCon.setConnectTimeout(connectTimeout);
            httpCon.setReadTimeout(readTimeout);
            httpCon.setRequestMethod(method.name());
            if (reqBytes == null) {
                httpCon.setDoOutput(false);
            } else {
                httpCon.setRequestProperty("Content-Type", contentType);
                httpCon.setRequestProperty("Content-Length", Integer.toString(reqBytes.length));
                httpCon.setDoOutput(true);
            }
            httpCon.setDoInput(true);
            httpCon.setInstanceFollowRedirects(true);
            httpCon.connect();
            if (reqBytes != null) {
                StreamUtil.writeAndClose(httpCon.getOutputStream(), reqBytes);
            }
            if ((httpResponseCode = httpCon.getResponseCode()) != 301 && httpResponseCode != 302) break block20;
            String location = httpCon.getHeaderField("Location");
            String cookies = httpCon.getHeaderField("Set-Cookie");
            HashMap<String, String> newHeaders = new HashMap<String, String>(reqHeaders);
            newHeaders.put("Referer", strUrl);
            newHeaders.put("Cookie", cookies);
            LOG.debug("Going to redirect to new URL [{}].", (Object)location);
            Triple<Integer, Map<String, List<String>>, byte[]> triple2 = HTTPUtil.doHTTP(location, null, null, null, newHeaders, connectTimeout, readTimeout, method);
            StreamUtil.closeStream(in);
            HTTPUtil.cleanupHttpURLConnection(inErrorStatus, httpCon);
            return triple2;
        }
        try {
            in = httpResponseCode >= 400 ? httpCon.getErrorStream() : httpCon.getInputStream();
            int contentLength = httpCon.getContentLength();
            byte[] ret = HTTPUtil.checkAndDownloadData(strUrl, contentLength, in);
            inErrorStatus = false;
            triple = Triple.create(httpResponseCode, httpCon.getHeaderFields(), ret);
        }
        catch (IllegalArgumentException e) {
            try {
                throw e;
                catch (NetException e2) {
                    LOG.info(e2.getMessage());
                    throw e2;
                }
                catch (Exception e3) {
                    String msg = "Failed to execute HTTP request to [" + strUrl + "], msg=" + e3.toString();
                    LOG.warn(msg);
                    throw new NetException(NetException.ExCode.IOEXCEPTION, msg, e3);
                }
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(in);
                HTTPUtil.cleanupHttpURLConnection(inErrorStatus, httpCon);
                throw throwable;
            }
        }
        StreamUtil.closeStream(in);
        HTTPUtil.cleanupHttpURLConnection(inErrorStatus, httpCon);
        return triple;
    }

    public static byte[] checkAndDownloadData(String strUrl, int contentLength, InputStream in) throws NetException, IOException {
        byte[] ret = null;
        if (in != null && contentLength != 0) {
            ret = contentLength > 0 ? DownloadUtil.commonDownload(in, contentLength) : DownloadUtil.unusualDownload(in, 0, 0xF00000, strUrl, Boolean.TRUE);
            LOG.debug("Succeeded to execute HTTP request to [{}], response size {}.", (Object)strUrl, (Object)ret.length);
        }
        return ret;
    }

    public static void cleanupHttpURLConnection(boolean inErrorStatus, HttpURLConnection httpCon) {
        if (inErrorStatus && httpCon != null) {
            httpCon.disconnect();
        }
    }

    public static final Charset inferCharset(Map<String, List<String>> headers, byte[] body) {
        int length;
        String s;
        int idx;
        String rawCharSet = null;
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String s2;
            int idx2;
            if (!"Content-Type".equalsIgnoreCase(entry.getKey())) continue;
            List<String> list = entry.getValue();
            if (CollectionUtil.isEmpty(list) || (idx2 = (s2 = list.get(0)).toLowerCase().indexOf("charset")) <= 0) break;
            rawCharSet = s2.substring(idx2 + 7);
            break;
        }
        if (rawCharSet == null && (idx = (s = new String(body, 0, length = body.length < 512 ? body.length : 512, StringUtil.US_ASCII)).toLowerCase().indexOf("charset")) > 0) {
            int end = s.length() > (idx += 7) + 20 ? idx + 20 : s.length();
            rawCharSet = s.substring(idx, end);
        }
        if (rawCharSet == null) {
            return StringUtil.UTF_8;
        }
        return HTTPUtil.retrieveCharsetFromString(rawCharSet);
    }

    public static final Charset retrieveCharsetFromString(String rawCharSet) {
        char ch;
        char ch2;
        int idx;
        int end = rawCharSet.length();
        for (idx = 0; idx < end && ((ch2 = rawCharSet.charAt(idx)) == '\'' || ch2 == '\"' || ch2 == ' ' || ch2 == '='); ++idx) {
        }
        int start = idx;
        while (idx < end && (ch = rawCharSet.charAt(idx)) != '\'' && ch != '\"' && ch != ' ' && ch != ';' && ch != '>') {
            ++idx;
        }
        return Charset.forName(rawCharSet.substring(start, idx));
    }

    public static String prepareWwwFormUrlEncoded(Map<String, String> params, String paramCharset) {
        if (CollectionUtil.isEmpty(params)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            try {
                sb.append(URLEncoder.encode(entry.getKey(), paramCharset));
                sb.append('=');
                sb.append(URLEncoder.encode(entry.getValue(), paramCharset));
                sb.append('&');
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static int checkServerStatus(String completeUrl, int connectTimeout, int readTimeout) {
        try {
            URL u = new URL(completeUrl);
            URLConnection c = u.openConnection();
            if (!(c instanceof HttpURLConnection)) {
                return -2;
            }
            HttpURLConnection conn = (HttpURLConnection)c;
            conn.setRequestMethod(HTTPMethod.HEAD.name());
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            conn.setDoInput(true);
            conn.setDoOutput(false);
            conn.connect();
            LOG.info("Check URL [" + completeUrl + "] status: " + conn.getHeaderField(0));
            return conn.getResponseCode();
        }
        catch (IOException e) {
            LOG.warn("Failed to connect to " + completeUrl + " : " + e.getMessage());
            return -1;
        }
    }
}

