/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.net;

import java.util.List;
import java.util.Map;
import org.apache.niolex.commons.net.HTTPClient;
import org.apache.niolex.commons.net.HTTPUtil;

public class HTTPResult {
    private final int respCode;
    private final Map<String, List<String>> respHeaders;
    private final byte[] respBody;
    private String respBodyStr;
    private final HTTPClient client;

    public HTTPResult(int respCode, Map<String, List<String>> respHeaders, byte[] respBody, HTTPClient client) {
        this.respCode = respCode;
        this.respHeaders = respHeaders;
        this.respBody = respBody;
        this.client = client;
    }

    public int getRespCode() {
        return this.respCode;
    }

    public Map<String, List<String>> getRespHeaders() {
        return this.respHeaders;
    }

    public List<String> getHeader(String key) {
        return this.respHeaders.get(key);
    }

    public byte[] getRespBody() {
        return this.respBody;
    }

    public String getRespBodyStr() {
        if (this.respBodyStr == null) {
            this.respBodyStr = new String(this.respBody, HTTPUtil.inferCharset(this.respHeaders, this.respBody));
        }
        return this.respBodyStr;
    }

    public HTTPClient client() {
        return this.client;
    }

    public String toString() {
        return String.format("%s Body Size [%d]", this.respHeaders.get(null), this.respBody == null ? -1 : this.respBody.length);
    }
}

