/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.net;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.niolex.commons.bean.Triple;
import org.apache.niolex.commons.codec.Base64Util;
import org.apache.niolex.commons.codec.StringUtil;
import org.apache.niolex.commons.collection.CollectionUtil;
import org.apache.niolex.commons.net.HTTPMethod;
import org.apache.niolex.commons.net.HTTPResult;
import org.apache.niolex.commons.net.HTTPUtil;
import org.apache.niolex.commons.net.NetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPClient {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPClient.class);
    private final Map<String, String> reqHeaders = new HashMap<String, String>(HTTPUtil.REQ_HEADER);
    private final Map<String, String> cookiesMap = new TreeMap<String, String>();
    private final String endPoint;
    private final String charset;
    private int endPointDirDepth;
    private int connectTimeout = 6000;
    private int readTimeout = 6000;
    private String referer;
    private String authorization;

    public HTTPClient(String endPoint, String charset) {
        this.endPoint = this.processEndPoint(endPoint);
        this.charset = charset;
    }

    public HTTPClient(String endPoint, String charset, int connectTimeout, int readTimeout) {
        this.endPoint = this.processEndPoint(endPoint);
        this.charset = charset;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public void authorization(String userName, String password) {
        this.authorization = "Basic " + Base64Util.byteToBase64(StringUtil.strToUtf8Byte(userName + ":" + password));
        this.reqHeaders.put("Authorization", this.authorization);
    }

    public HTTPResult get(String path, Map<String, String> params) throws NetException {
        Triple<Integer, Map<String, List<String>>, byte[]> res = HTTPUtil.doHTTP(this.generateURL(path), params, null, this.charset, this.reqHeaders, this.connectTimeout, this.readTimeout, HTTPMethod.GET);
        this.processCookie((Map)res.y);
        return new HTTPResult((Integer)res.x, (Map)res.y, (byte[])res.z, this);
    }

    public HTTPResult delete(String path, Map<String, String> params) throws NetException {
        Triple<Integer, Map<String, List<String>>, byte[]> res = HTTPUtil.doHTTP(this.generateURL(path), params, null, this.charset, this.reqHeaders, this.connectTimeout, this.readTimeout, HTTPMethod.DELETE);
        this.processCookie((Map)res.y);
        return new HTTPResult((Integer)res.x, (Map)res.y, (byte[])res.z, this);
    }

    public HTTPResult post(String path, Map<String, String> params) throws NetException {
        Triple<Integer, Map<String, List<String>>, byte[]> res = HTTPUtil.doHTTP(this.generateURL(path), params, null, this.charset, this.reqHeaders, this.connectTimeout, this.readTimeout, HTTPMethod.POST);
        this.processCookie((Map)res.y);
        return new HTTPResult((Integer)res.x, (Map)res.y, (byte[])res.z, this);
    }

    public HTTPResult post(String path, String json) throws NetException {
        Triple<Integer, Map<String, List<String>>, byte[]> res = HTTPUtil.doHTTP(this.generateURL(path), null, json, this.charset, this.reqHeaders, this.connectTimeout, this.readTimeout, HTTPMethod.POST);
        this.processCookie((Map)res.y);
        return new HTTPResult((Integer)res.x, (Map)res.y, (byte[])res.z, this);
    }

    public HTTPResult put(String path, String json) throws NetException {
        Triple<Integer, Map<String, List<String>>, byte[]> res = HTTPUtil.doHTTP(this.generateURL(path), null, json, this.charset, this.reqHeaders, this.connectTimeout, this.readTimeout, HTTPMethod.PUT);
        this.processCookie((Map)res.y);
        return new HTTPResult((Integer)res.x, (Map)res.y, (byte[])res.z, this);
    }

    protected void processCookie(Map<String, List<String>> respHeaders) {
        List<String> cookies = respHeaders.get("Set-Cookie");
        if (cookies == null) {
            cookies = respHeaders.get("set-cookie");
        }
        if (CollectionUtil.isEmpty(cookies)) {
            return;
        }
        for (String c : cookies) {
            c = c.substring(0, c.indexOf(59));
            String[] kv = c.split(" *= *", 2);
            this.cookiesMap.put(kv[0], kv[1]);
        }
        StringBuilder cookie = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, String> en : this.cookiesMap.entrySet()) {
            if (i++ > 0) {
                cookie.append("; ");
            }
            cookie.append(en.getKey()).append('=').append(en.getValue());
        }
        LOG.debug("The new cookie: {}", (Object)cookie);
        this.reqHeaders.put("Cookie", cookie.toString());
    }

    protected String generateURL(String path) {
        String[] tokens = StringUtil.split(path, "/", false);
        if (tokens.length == 0) {
            return this.endPoint;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.endPoint);
        int indent = this.endPointDirDepth;
        for (int i = 0; i < tokens.length; ++i) {
            String item = tokens[i];
            if (item.equals(".")) continue;
            if (item.equals("..")) {
                if (indent == 0) continue;
                --indent;
                sb.setLength(sb.lastIndexOf("/"));
                continue;
            }
            ++indent;
            sb.append('/').append(item);
        }
        this.reqHeaders.put("Referer", this.referer);
        this.referer = sb.toString();
        LOG.debug("The original path: {}, the generated URL: {}", (Object)path, (Object)this.referer);
        return this.referer;
    }

    protected String processEndPoint(String enp) {
        URL u;
        try {
            u = new URL(enp);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The end point is invalid. " + enp);
        }
        String c = u.getProtocol();
        if (!c.equals("https") && !c.equals("http")) {
            throw new IllegalArgumentException("The end point is not using HTTP protocol. " + enp);
        }
        if (u.getQuery() != null) {
            throw new IllegalArgumentException("The end point can not have query part. " + enp);
        }
        if (u.getRef() != null) {
            throw new IllegalArgumentException("The end point can not have ref part. " + enp);
        }
        this.endPointDirDepth = 0;
        String p = u.getPath();
        int end = p.length() - 1;
        for (int i = 0; i < end; ++i) {
            if (p.charAt(i) != '/') continue;
            ++this.endPointDirDepth;
        }
        enp = u.toExternalForm();
        if (enp.endsWith("/")) {
            enp = enp.substring(0, enp.length() - 1);
        }
        this.referer = enp;
        LOG.debug("The processed end point: {}", (Object)this.referer);
        return enp;
    }
}

