/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.niolex.commons.stream.StreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtil.class);

    public static boolean setBin(String pathname, byte[] raw) {
        return FileUtil.setBinaryFileContentToFileSystem(pathname, raw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setBinaryFileContentToFileSystem(String pathname, byte[] raw) {
        boolean bl;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(pathname);
            ((OutputStream)out).write(raw);
            out.flush();
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                LOG.warn("Error occured while store content to file [{}] reason - {}", (Object)pathname, (Object)e.toString());
                bl2 = false;
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(out);
                throw throwable;
            }
            StreamUtil.closeStream(out);
            return bl2;
        }
        StreamUtil.closeStream(out);
        return bl;
    }

    public static boolean setStr(String pathname, String content, Charset charset) {
        return FileUtil.setCharacterFileContentToFileSystem(pathname, content, charset);
    }

    public static boolean setCharacterFileContentToFileSystem(String pathname, String content, Charset charset) {
        return FileUtil.setBinaryFileContentToFileSystem(pathname, content.getBytes(charset));
    }

    public static byte[] getBin(String pathname) {
        return FileUtil.getBinaryFileContentFromFileSystem(pathname);
    }

    public static byte[] getBinaryFileContentFromFileSystem(String pathname) {
        return FileUtil.getBinaryFileContentFromFileSystem(pathname, 0xA00000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBinaryFileContentFromFileSystem(String pathname, int maxSize) {
        byte[] byArray;
        FileInputStream in = null;
        try {
            File file = new File(pathname);
            int size = (int)file.length();
            if (size > maxSize) {
                throw new IllegalStateException("File too large. max " + maxSize + ", file size " + size);
            }
            byte[] raw = new byte[size];
            in = new FileInputStream(file);
            StreamUtil.readData(in, raw);
            byArray = raw;
            StreamUtil.closeStream(in);
        }
        catch (IOException e) {
            LOG.warn("Error occured while read file [{}] from filesystem; reason - {}", (Object)pathname, (Object)e.toString());
            byte[] byArray2 = null;
            return byArray2;
        }
        finally {
            StreamUtil.closeStream(in);
        }
        return byArray;
    }

    public static byte[] getBinaryFileContentFromClassPath(String pathname, Class<?> cls) {
        try {
            InputStream in = cls.getResourceAsStream(pathname);
            if (in != null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream(10240);
                StreamUtil.transferAndClose(in, out, 4096);
                return out.toByteArray();
            }
        }
        catch (Exception e) {
            LOG.warn("Error occured while read file [{}] from class [{}]; reason - {}", new Object[]{pathname, cls, e.toString()});
        }
        return null;
    }

    public static String getStr(String pathname, Charset encoding) {
        return FileUtil.getCharacterFileContentFromFileSystem(pathname, encoding);
    }

    public static String getCharacterFileContentFromFileSystem(String pathname, Charset encoding) {
        byte[] data = FileUtil.getBinaryFileContentFromFileSystem(pathname);
        return data == null ? null : new String(data, encoding);
    }

    public static String getCharacterFileContentFromClassPath(String pathname, Class<?> cls, Charset encoding) {
        byte[] data = FileUtil.getBinaryFileContentFromClassPath(pathname, cls);
        return data == null ? null : new String(data, encoding);
    }
}

